/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.minelittlepony;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.minelittlepony.api.model.BodyPart;
import com.minelittlepony.api.model.PonyModel;
import com.minelittlepony.api.model.SubModel;
import com.minelittlepony.api.model.WingedPonyModel;
import com.minelittlepony.api.model.gear.Gear;
import com.minelittlepony.api.pony.PonyData;
import com.minelittlepony.client.model.ClientPonyModel;
import com.minelittlepony.client.model.ModelType;
import com.minelittlepony.client.model.PlayerModelKey;
import com.minelittlepony.client.model.entity.race.ChangelingModel;
import com.minelittlepony.client.model.entity.race.PegasusModel;
import com.minelittlepony.client.model.entity.race.UnicornModel;
import com.minelittlepony.client.model.part.UnicornHorn;
import com.minelittlepony.mson.api.MsonModel;
import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.FlightType;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.client.minelittlepony.MineLPDelegate;
import com.minelittlepony.unicopia.entity.AmuletSelectors;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

class BodyPartGear<M extends ClientPonyModel<class_1309>>
implements Gear {
    private static final Predicate<class_1309> MINE_LP_HAS_NO_WINGS = e -> !MineLPDelegate.getInstance().getRace((class_1297)e).canFly();
    private static final Predicate<class_1309> MINE_LP_HAS_NO_HORN = e -> !MineLPDelegate.getInstance().getRace((class_1297)e).canCast();
    private static final class_2960 ICARUS_WINGS = Unicopia.id("textures/models/wings/icarus_pony.png");
    private static final class_2960 ICARUS_WINGS_CORRUPTED = Unicopia.id("textures/models/wings/icarus_corrupted_pony.png");
    public static final Predicate<class_1309> BUG_WINGS_PREDICATE = MINE_LP_HAS_NO_WINGS.and(AmuletSelectors.PEGASUS_AMULET.negate()).and(EquinePredicates.PLAYER_CHANGELING);
    public static final class_2960 BUG_WINGS = Unicopia.id("textures/models/wings/bug_pony.png");
    public static final Predicate<class_1309> BAT_WINGS_PREDICATE = MINE_LP_HAS_NO_WINGS.and(AmuletSelectors.PEGASUS_AMULET.negate()).and(EquinePredicates.PLAYER_BAT);
    public static final class_2960 BAT_WINGS = Unicopia.id("textures/models/wings/bat_pony.png");
    public static final Predicate<class_1309> UNICORN_HORN_PREDICATE = MINE_LP_HAS_NO_HORN.and(AmuletSelectors.ALICORN_AMULET.or(EquinePredicates.raceMatches(Race::canCast)));
    public static final class_2960 UNICORN_HORN = Unicopia.id("textures/models/horn/unicorn.png");
    public static final Predicate<class_1309> PEGA_WINGS_PREDICATE = MINE_LP_HAS_NO_WINGS.and(AmuletSelectors.PEGASUS_AMULET.or(EquinePredicates.raceMatches(race -> race != Race.BAT && race.flightType() == FlightType.AVIAN)));
    public static final class_2960 PEGASUS_WINGS = Unicopia.id("textures/models/wings/pegasus_pony.png");
    private final M model;
    private final Predicate<class_1309> renderTargetPredicate;
    private final SubModel part;
    private final Function<class_1297, class_2960> textureSupplier;
    private final BodyPart gearLocation;
    private final LoadingCache<PonyData, PonyData> dataCache = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.SECONDS).build(CacheLoader.from(metadata -> new PonyData(race, metadata.tailLength(), metadata.tailShape(), metadata.gender(), metadata.size(), metadata.glowColor(), metadata.noSkin(), metadata.priority(), metadata.gear())));

    public static BodyPartGear<WingsGearModel> pegasusWings() {
        return new BodyPartGear<WingsGearModel>(com.minelittlepony.api.pony.meta.Race.PEGASUS, BodyPart.BODY, ModelType.PEGASUS, PEGA_WINGS_PREDICATE, WingsGearModel::new, PegasusModel::getWings, e -> {
            if (AmuletSelectors.PEGASUS_AMULET.test((class_1309)e)) {
                return e.method_37908().method_8597().comp_644() ? ICARUS_WINGS_CORRUPTED : ICARUS_WINGS;
            }
            return PEGASUS_WINGS;
        });
    }

    public static BodyPartGear<WingsGearModel> batWings() {
        return new BodyPartGear<WingsGearModel>(com.minelittlepony.api.pony.meta.Race.BATPONY, BodyPart.BODY, ModelType.BAT_PONY, BAT_WINGS_PREDICATE, WingsGearModel::new, WingedPonyModel::getWings, e -> BAT_WINGS);
    }

    public static BodyPartGear<BugWingsGearModel> bugWings() {
        return new BodyPartGear<BugWingsGearModel>(com.minelittlepony.api.pony.meta.Race.CHANGELING, BodyPart.BODY, ModelType.CHANGELING, BUG_WINGS_PREDICATE, BugWingsGearModel::new, WingedPonyModel::getWings, e -> BUG_WINGS);
    }

    public static BodyPartGear<HornGearModel> unicornHorn() {
        return new BodyPartGear<HornGearModel>(com.minelittlepony.api.pony.meta.Race.UNICORN, BodyPart.HEAD, ModelType.UNICORN, UNICORN_HORN_PREDICATE, HornGearModel::new, HornGearModel::getHorn, e -> UNICORN_HORN);
    }

    public BodyPartGear(com.minelittlepony.api.pony.meta.Race race, BodyPart gearLocation, PlayerModelKey<class_1309, ? super M> modelKey, Predicate<class_1309> renderTargetPredicate, MsonModel.Factory<M> modelFactory, Function<? super M, SubModel> partExtractor, Function<class_1297, class_2960> textureSupplier) {
        this.gearLocation = gearLocation;
        this.model = (ClientPonyModel)modelKey.steveKey().createModel(modelFactory);
        this.part = partExtractor.apply(this.model);
        this.renderTargetPredicate = renderTargetPredicate;
        this.textureSupplier = textureSupplier;
    }

    public BodyPart getGearLocation() {
        return this.gearLocation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canRender(PonyModel<?> model, class_1297 entity) {
        if (!(entity instanceof class_1309)) return false;
        class_1309 l = (class_1309)entity;
        if (!MineLPDelegate.getInstance().getRace(entity).isEquine()) return false;
        if (!this.renderTargetPredicate.test(l)) return false;
        return true;
    }

    public <T extends class_1297> class_2960 getTexture(T entity, Gear.Context<T, ?> context) {
        return this.textureSupplier.apply(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pose(PonyModel<?> model, class_1297 entity, boolean rainboom, UUID interpolatorId, float move, float swing, float bodySwing, float tickDelta) {
        PonyData data = this.model.getAttributes().metadata;
        try {
            ((ClientPonyModel)model).copyAttributes(this.model);
            this.model.getAttributes().metadata = (PonyData)this.dataCache.getUnchecked((Object)data);
            this.model.method_17086((class_1309)entity, move, swing, tickDelta);
            this.model.method_17087((class_1309)entity, move, swing, (float)entity.field_6012 + tickDelta, 0.0f, 0.0f);
        }
        finally {
            this.model.getAttributes().metadata = data;
        }
    }

    public static PonyData copyOf(PonyData metadata, com.minelittlepony.api.pony.meta.Race newRace) {
        return new PonyData(newRace, metadata.tailLength(), metadata.tailShape(), metadata.gender(), metadata.size(), metadata.glowColor(), metadata.noSkin(), metadata.priority(), metadata.gear());
    }

    public void render(class_4587 stack, class_4588 consumer, int light, int overlay, int color, UUID interpolatorId) {
        this.part.renderPart(stack, consumer, light, overlay, color, this.model.getAttributes());
    }

    static final class HornGearModel
    extends UnicornModel<class_1309> {
        public HornGearModel(class_630 tree) {
            super(tree, false);
        }

        public UnicornHorn getHorn() {
            return this.horn;
        }
    }

    static final class BugWingsGearModel
    extends ChangelingModel<class_1309> {
        public BugWingsGearModel(class_630 tree) {
            super(tree, false);
        }
    }

    static final class WingsGearModel
    extends PegasusModel<class_1309> {
        public WingsGearModel(class_630 tree) {
            super(tree, false);
        }
    }
}

