/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.particle;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.client.particle.AbstractGeometryBasedParticle;
import com.minelittlepony.unicopia.particle.LightningBoltParticleEffect;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LightningBoltParticle
extends AbstractGeometryBasedParticle {
    private final List<Bolt> branches = new ArrayList<Bolt>();
    private final LightningBoltParticleEffect effect;

    public LightningBoltParticle(LightningBoltParticleEffect effect, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.effect = effect;
    }

    public void method_3070() {
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
            return;
        }
        if (this.effect.changeFrequency() > 0 && this.field_3866 % this.effect.changeFrequency() == 0) {
            this.branches.clear();
        }
        if (this.branches.isEmpty()) {
            this.effect.pathEndPoint().ifPresentOrElse(endpoint -> this.branches.add(this.generateTrunk(endpoint.method_1023(this.field_3874, this.field_3854, this.field_3871).method_46409())), () -> {
                int totalBranches = 2 + this.field_3851.field_9229.method_43048(this.effect.maxBranches());
                while (this.branches.size() < totalBranches) {
                    this.branches.add(this.generateBranch());
                }
            });
            if (!this.effect.silent()) {
                this.field_3851.method_8486(this.field_3874, this.field_3854, this.field_3871, USounds.Vanilla.field_14865, class_3419.field_15252, 10000.0f, 8.0f, true);
            }
        }
        if (this.effect.pathEndPoint().isEmpty() && !this.effect.silent()) {
            this.field_3851.method_8509(2);
        }
    }

    private Bolt generateTrunk(Vector3f end) {
        Vector3f start = new Vector3f(0.0f, 0.0f, 0.0f);
        int kinks = 2 + this.field_3851.field_9229.method_43048(this.effect.maxBranches());
        Vector3f segmentLength = end.sub((Vector3fc)start, new Vector3f()).mul(1.0f / (float)kinks);
        float deviation = this.effect.maxDeviation();
        ArrayList<Vector3f> nodes = new ArrayList<Vector3f>();
        nodes.add(start);
        for (int i = 0; i < kinks - 1; ++i) {
            start = start.add((Vector3fc)segmentLength, new Vector3f()).add((float)this.field_3851.field_9229.method_43385(0.0, (double)deviation), 0.0f, (float)this.field_3851.field_9229.method_43385(0.0, (double)deviation));
            nodes.add(start);
        }
        nodes.add(end);
        return new Bolt(true, nodes);
    }

    private Bolt generateBranch() {
        Vector3f startPos = new Vector3f(0.0f, 0.0f, 0.0f);
        int intendedLength = 2 + this.field_3851.field_9229.method_43048(this.effect.maxBranches());
        float deviation = this.effect.maxDeviation();
        ArrayList<Vector3f> nodes = new ArrayList<Vector3f>();
        while (nodes.size() < intendedLength) {
            startPos = startPos.add((float)this.field_3851.field_9229.method_43385(0.0, (double)deviation), (float)this.field_3851.field_9229.method_43385(0.0, (double)deviation), (float)this.field_3851.field_9229.method_43385(0.0, (double)deviation), new Vector3f());
            nodes.add(startPos);
        }
        return new Bolt(false, nodes);
    }

    public void method_3074(class_4588 drawer, class_4184 camera, float tickDelta) {
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        class_4588 buffer = immediate.getBuffer(class_1921.method_23593());
        RenderSystem.disableCull();
        class_243 cam = camera.method_19326();
        float x = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - cam.method_10216());
        float y = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - cam.method_10214());
        float z = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - cam.method_10215());
        Vector3f origin = new Vector3f(x, y, z);
        Vector3f from = new Vector3f();
        Vector3f to = new Vector3f();
        for (Bolt branch : this.branches) {
            for (int i = 0; i < branch.nodes().size(); ++i) {
                this.renderBranch(buffer, branch.isTrunk() ? 0.05125f : this.field_3851.field_9229.method_43057() / 30.0f + 0.01f, i == 0 ? origin : branch.nodes().get(i - 1).add(x, y, z, from), branch.nodes().get(i).add(x, y, z, to));
            }
        }
        immediate.method_22993();
        RenderSystem.enableCull();
    }

    private void renderBranch(class_4588 buffer, float thickness, Vector3f from, Vector3f to) {
        this.renderQuad(buffer, new Vector3f[]{new Vector3f(from.x - thickness, from.y, from.z + thickness), new Vector3f(to.x - thickness, to.y, to.z + thickness), new Vector3f(to.x + thickness, to.y, to.z + thickness), new Vector3f(from.x + thickness, from.y, from.z + thickness), new Vector3f(from.x - thickness, from.y, from.z - thickness), new Vector3f(to.x - thickness, to.y, to.z - thickness), new Vector3f(to.x + thickness, to.y, to.z - thickness), new Vector3f(from.x + thickness, from.y, from.z - thickness), new Vector3f(from.x - thickness, from.y, from.z - thickness), new Vector3f(to.x - thickness, to.y, to.z - thickness), new Vector3f(to.x - thickness, to.y, to.z + thickness), new Vector3f(from.x - thickness, from.y, from.z + thickness), new Vector3f(from.x + thickness, from.y, from.z - thickness), new Vector3f(to.x + thickness, to.y, to.z - thickness), new Vector3f(to.x + thickness, to.y, to.z + thickness), new Vector3f(from.x + thickness, from.y, from.z + thickness)}, 0.3f, 1.0f);
    }

    record Bolt(boolean isTrunk, List<Vector3f> nodes) {
    }
}

