/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.client.FirstPersonRendererOverrides;
import com.minelittlepony.unicopia.client.minelittlepony.MineLPDelegate;
import com.minelittlepony.unicopia.client.render.spell.SpellEffectsRenderDispatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_897;
import org.jetbrains.annotations.Nullable;

public class AccessoryFeatureRenderer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    private static final List<FeatureFactory<?, ?>> REGISTRY = new ArrayList();
    private final Iterable<Feature<T>> features = REGISTRY.stream().map(f -> f.create(context)).toList();

    @SafeVarargs
    public static <T extends class_1309> void register(FeatureFactory<T, class_572<T>> ... factories) {
        for (FeatureFactory<T, class_572<T>> factory : factories) {
            REGISTRY.add(factory);
        }
    }

    public AccessoryFeatureRenderer(class_3883<T, M> context) {
        super(context);
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (MineLPDelegate.getInstance().getRace((class_1297)entity).isEquine()) {
            return;
        }
        this.features.forEach(feature -> feature.render(matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch));
        Caster.of(entity).ifPresent(caster -> SpellEffectsRenderDispatcher.INSTANCE.render(matrices, vertexConsumers, light, (Caster<?>)caster, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch));
    }

    public void renderArm(class_4587 matrices, class_4597 vertexConsumers, int light, T entity, class_630 arm, class_1306 side) {
        this.features.forEach(feature -> feature.renderArm(matrices, vertexConsumers, light, entity, arm, side));
    }

    public boolean beforeRenderArms(FirstPersonRendererOverrides.ArmRenderer sender, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, T entity, int light) {
        Caster caster = Caster.of(entity).orElse(null);
        if (caster != null) {
            SpellEffectsRenderDispatcher.INSTANCE.render(matrices, vertexConsumers, light, caster, 0.0f, 0.0f, tickDelta, (float)((class_1309)entity).field_6012 + tickDelta, 0.0f, 0.0f);
        }
        boolean cancelled = false;
        for (Feature<T> feature : this.features) {
            cancelled |= feature.beforeRenderArms(sender, tickDelta, matrices, vertexConsumers, entity, light);
        }
        return cancelled;
    }

    public static interface Feature<T extends class_1309> {
        public void render(class_4587 var1, class_4597 var2, int var3, T var4, float var5, float var6, float var7, float var8, float var9, float var10);

        default public void renderArm(class_4587 matrices, class_4597 vertexConsumers, int light, T entity, class_630 arm, class_1306 side) {
        }

        default public boolean beforeRenderArms(FirstPersonRendererOverrides.ArmRenderer sender, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, T entity, int light) {
            return false;
        }
    }

    public static interface FeatureFactory<T extends class_1309, M extends class_583<T>> {
        public Feature<T> create(class_3883<T, M> var1);
    }

    public static interface FeatureRoot<T extends class_1309, M extends class_583<T>> {
        public AccessoryFeatureRenderer<T, M> getAccessories();

        @Nullable
        public static <T extends class_1309, M extends class_583<T>> FeatureRoot<T, M> of(T entity) {
            class_897 renderer = class_310.method_1551().method_1561().method_3953(entity);
            if (renderer instanceof FeatureRoot) {
                return (FeatureRoot)renderer;
            }
            return null;
        }
    }
}

