/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render;

import com.minelittlepony.unicopia.client.FirstPersonRendererOverrides;
import com.minelittlepony.unicopia.client.minelittlepony.MineLPDelegate;
import com.minelittlepony.unicopia.client.render.AccessoryFeatureRenderer;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.duck.EntityDuck;
import com.minelittlepony.unicopia.entity.duck.LivingEntityDuck;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.util.LimbAnimationUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_897;

public class HeldEntityFeatureRenderer<E extends class_1309>
implements AccessoryFeatureRenderer.Feature<E> {
    public HeldEntityFeatureRenderer(class_3883<E, ? extends class_572<E>> context) {
    }

    @Override
    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, E entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        Pony.of(entity).flatMap(Pony::getEntityInArms).ifPresent(passenger -> {
            float leanAmount = ((LivingEntityDuck)entity).getLeaningPitch();
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f - leanAmount * 90.0f));
            class_243 carryPosition = HeldEntityFeatureRenderer.getCarryPosition(Living.living(entity), passenger).method_1037(-leanAmount * (float)Math.PI / 4.0f).method_1019(new class_243(0.0, -0.5, 0.0).method_1021((double)leanAmount));
            matrices.method_22904(carryPosition.field_1352, carryPosition.field_1351, carryPosition.field_1350);
            if (!(passenger instanceof Pony)) {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            }
            this.renderCarriedEntity((class_1309)passenger.asEntity(), matrices, vertexConsumers, light, tickDelta);
            matrices.method_22909();
        });
    }

    @Override
    public void renderArm(class_4587 matrices, class_4597 vertexConsumers, int light, E entity, class_630 arm, class_1306 side) {
    }

    @Override
    public boolean beforeRenderArms(FirstPersonRendererOverrides.ArmRenderer sender, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, E entity, int light) {
        return Pony.of(entity).flatMap(Pony::getEntityInArms).filter(passenger -> {
            float swingProgress = entity.method_6055(class_310.method_1551().method_60646().method_60637(false));
            float f = -0.4f * class_3532.method_15374((float)(class_3532.method_15355((float)swingProgress) * (float)Math.PI));
            float g = 0.2f * class_3532.method_15374((float)(class_3532.method_15355((float)swingProgress) * ((float)Math.PI * 2)));
            float h = -0.2f * class_3532.method_15374((float)(swingProgress * (float)Math.PI));
            matrices.method_22903();
            matrices.method_46416(f, g, h);
            matrices.method_46416(0.0f, -1.3f, passenger instanceof Pony ? -1.9f : -1.3f);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(passenger instanceof Pony ? 33.0f : 13.0f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(passenger instanceof Pony ? 180.0f : 90.0f));
            this.renderCarriedEntity((class_1309)passenger.asEntity(), matrices, vertexConsumers, light, tickDelta);
            matrices.method_22909();
            float equipProgress = 1.0f - sender.getEquipProgress(class_1268.field_5808, tickDelta);
            matrices.method_22903();
            sender.invokeRenderArmHoldingItem(matrices, vertexConsumers, light, equipProgress, swingProgress, class_1306.field_6182);
            matrices.method_22909();
            matrices.method_22903();
            sender.invokeRenderArmHoldingItem(matrices, vertexConsumers, light, equipProgress, swingProgress, class_1306.field_6183);
            matrices.method_22909();
            return false;
        }).isPresent();
    }

    private void renderCarriedEntity(class_1309 p, class_4587 matrices, class_4597 vertexConsumers, int light, float tickDelta) {
        LimbAnimationUtil.resetToZero(p.field_42108);
        class_1297 vehicle = p.method_5854();
        ((EntityDuck)p).setVehicle(null);
        p.field_6220 = 0.0f;
        p.field_6283 = 0.0f;
        float oldHeadYaw = p.field_6241;
        float oldPrevHeadYaw = p.field_6259;
        float oldPrevYaw = p.field_5982;
        float oldYaw = p.method_36454();
        boolean onGround = p.method_24828();
        p.field_6241 = 0.0f;
        p.field_6259 = 0.0f;
        p.field_5982 = 0.0f;
        p.method_36456(0.0f);
        p.method_5636(0.0f);
        p.method_24830(true);
        class_897 renderer = class_310.method_1551().method_1561().method_3953((class_1297)p);
        renderer.method_3936((class_1297)p, 0.0f, tickDelta, matrices, vertexConsumers, light);
        p.field_6241 = oldHeadYaw;
        p.field_6259 = oldPrevHeadYaw;
        p.field_5982 = oldPrevYaw;
        p.method_36456(oldYaw);
        p.method_24830(onGround);
        ((EntityDuck)p).setVehicle(vehicle);
    }

    public static class_243 getCarryPosition(Living<?> entity, Living<?> passenger) {
        float passengerHeight = MineLPDelegate.getInstance().getPonyHeight((class_1297)passenger.asEntity()) / 2.0f;
        float carrierHeight = MineLPDelegate.getInstance().getPonyHeight((class_1297)entity.asEntity()) / 5.0f;
        if (entity instanceof Pony) {
            Pony pony = (Pony)entity;
            if (MineLPDelegate.getInstance().getPlayerPonyRace((class_1657)pony.asEntity()).isEquine() && pony.getPhysics().isFlying()) {
                return new class_243(0.0, (double)(-carrierHeight * 10.0f - passengerHeight * 2.0f), 0.0);
            }
        }
        return new class_243(0.0, (double)(-passengerHeight - carrierHeight), (double)entity.asEntity().method_17681());
    }
}

