/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.client.minelittlepony.MineLPDelegate;
import com.minelittlepony.unicopia.client.render.EntityDisguiseRenderer;
import com.minelittlepony.unicopia.client.render.EntityReplacementManager;
import com.minelittlepony.unicopia.client.render.ModelPartHooks;
import com.minelittlepony.unicopia.client.render.RenderLayerUtil;
import com.minelittlepony.unicopia.client.render.RenderLayers;
import com.minelittlepony.unicopia.client.render.SmittenEyesRenderer;
import com.minelittlepony.unicopia.client.render.model.SphereModel;
import com.minelittlepony.unicopia.entity.Creature;
import com.minelittlepony.unicopia.entity.Equine;
import com.minelittlepony.unicopia.entity.ItemImpl;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.behaviour.Disguise;
import com.minelittlepony.unicopia.entity.duck.LavaAffine;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.util.ColorHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5636;
import net.minecraft.class_758;
import net.minecraft.class_7833;

public class WorldRenderDelegate {
    public static final WorldRenderDelegate INSTANCE = new WorldRenderDelegate();
    private static final Optional<class_243> RED_SKY_COLOR = Optional.of(new class_243(1.0, 0.0, 0.0));
    private static final int DIVER_HELMET_COLOR = class_5253.class_5254.method_59554((float)0.1f, (float)0.5f, (float)0.5f, (float)0.5f);
    private final EntityReplacementManager disguiseLookup = new EntityReplacementManager();
    private final EntityDisguiseRenderer disguiseRenderer = new EntityDisguiseRenderer(this);
    private final SmittenEyesRenderer smittenEyesRenderer = new SmittenEyesRenderer();
    private boolean recurseMinion;
    private boolean recurseFrosting;
    final class_310 client = class_310.method_1551();

    public Optional<class_243> getSkyColor(float tickDelta) {
        if (EquinePredicates.RAGING.test((class_1297)this.client.field_1724)) {
            return RED_SKY_COLOR;
        }
        return Optional.empty();
    }

    public void applyFog(class_4184 camera, class_758.class_4596 fogType, float viewDistance, boolean thickFog, float tickDelta) {
        if (camera.method_19334() == class_5636.field_27886 && EquinePredicates.PLAYER_SEAPONY.test((class_1297)class_310.method_1551().field_1724)) {
            RenderSystem.setShaderFogStart((float)(RenderSystem.getShaderFogStart() - 30.0f));
            RenderSystem.setShaderFogEnd((float)(RenderSystem.getShaderFogEnd() + 190.0f));
        }
        if (camera.method_19334() == class_5636.field_27888 && EquinePredicates.PLAYER_SEAPONY.test((class_1297)class_310.method_1551().field_1724)) {
            RenderSystem.setShaderFogStart((float)-130.0f);
        }
    }

    public boolean beforeEntityRender(class_1297 entity, double x, double y, double z, float yaw, float tickDelta, class_4587 matrices, class_4597 vertices, int light) {
        LavaAffine affine;
        if (!this.recurseFrosting && entity instanceof class_1690 && entity instanceof LavaAffine && (affine = (LavaAffine)entity).isLavaAffine()) {
            class_2960 frostingTexture = Unicopia.id("textures/entity/" + class_1299.method_5890((class_1299)entity.method_5864()).method_12832() + "/frosting.png");
            if (class_310.method_1551().method_1478().method_14486(frostingTexture).isPresent()) {
                this.recurseFrosting = true;
                RenderLayerUtil.createUnionBuffer(c -> this.client.method_1561().method_3954(entity, x, y, z, yaw, tickDelta, matrices, c, light), vertices, texture -> RenderLayers.method_23580((class_2960)frostingTexture));
                this.recurseFrosting = false;
                return true;
            }
        }
        if (this.recurseFrosting) {
            return false;
        }
        return Equine.of(entity).filter(eq -> this.onEntityRender((Equine<?>)eq, x, y, z, yaw, tickDelta, matrices, vertices, light)).isPresent();
    }

    public void afterEntityRender(Equine<?> pony, class_4587 matrices, class_4597 vertices, int light) {
        Pony p;
        Creature creature;
        if (this.recurseFrosting) {
            return;
        }
        if (pony instanceof Creature && this.smittenEyesRenderer.isSmitten(creature = (Creature)pony)) {
            this.smittenEyesRenderer.render(creature, matrices, vertices, light, 0);
        }
        if (pony instanceof Pony && (p = (Pony)pony).getCompositeRace().includes(Race.SEAPONY) && pony.asEntity().method_5869() && MineLPDelegate.getInstance().getPlayerPonyRace((class_1657)p.asEntity()) != Race.SEAPONY) {
            for (ModelPartHooks.EnqueudHeadRender head : ModelPartHooks.stopCollecting()) {
                matrices.method_22903();
                head.transform(matrices, 1.0f);
                class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
                class_1921 layer = RenderLayers.getMagicColored();
                float scale = 0.9f;
                SphereModel.SPHERE.render(matrices, immediate.getBuffer(layer), light, 0, scale, DIVER_HELMET_COLOR);
                SphereModel.SPHERE.render(matrices, immediate.getBuffer(layer), light, 0, scale + 0.2f, DIVER_HELMET_COLOR);
                matrices.method_22909();
            }
        }
        if (pony instanceof ItemImpl || pony instanceof Living) {
            matrices.method_22909();
            if (pony instanceof Living && pony.getPhysics().isGravityNegative()) {
                this.flipAngles((class_1297)pony.asEntity());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onEntityRender(Equine<?> pony, double x, double y, double z, float yaw, float tickDelta, class_4587 matrices, class_4597 vertices, int light) {
        Creature creature;
        if (!this.recurseMinion && pony instanceof Creature && (creature = (Creature)pony).isMinion()) {
            try {
                this.recurseMinion = true;
                RenderLayerUtil.createUnionBuffer(c -> this.client.method_1561().method_3954(creature.asEntity(), x, y, z, yaw, tickDelta, matrices, c, light), vertices, texture -> RenderLayers.getMagicColored(texture, creature.isDiscorded() ? 0x33FF0000 : ColorHelper.getRainbowColor(creature.asEntity(), 25, 1.0f)));
                boolean bl = true;
                return bl;
            }
            catch (Throwable t) {
                Unicopia.LOGGER.error("Error whilst rendering minion", t);
            }
            finally {
                this.recurseMinion = false;
            }
        }
        if (pony instanceof ItemImpl) {
            matrices.method_22903();
            if (pony.getPhysics().isGravityNegative()) {
                matrices.method_22904(0.0, (double)(-((ItemImpl)pony).asEntity().method_17682()) * 1.1, 0.0);
            }
            return false;
        }
        if (pony instanceof Living) {
            Living living = (Living)pony;
            return this.onLivingRender(living, x, y, z, yaw, tickDelta, matrices, vertices, light);
        }
        return false;
    }

    private boolean onLivingRender(Living<?> pony, double x, double y, double z, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (pony.isBeingCarried()) {
            return true;
        }
        matrices.method_22903();
        Object owner = pony.asEntity();
        boolean negative = pony.getPhysics().isGravityNegative();
        matrices.method_22904(x, y + (double)(owner.method_17682() / 2.0f), z);
        if (pony instanceof Pony) {
            Pony p = (Pony)pony;
            float sidewaysRoll = p.getCamera().calculateRoll();
            if (p.getAcrobatics().isFloppy()) {
                matrices.method_22904(0.0, -0.5, 0.0);
                ((class_1657)p.asEntity()).method_5636(0.0f);
                ((class_1657)p.asEntity()).method_36456(0.0f);
                sidewaysRoll += 90.0f;
            }
            matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(sidewaysRoll));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            float forwardPitch = p.getInterpolator().interpolate("g_kdive", p.getMotion().isDiving() ? 80.0f : 0.0f, 15.0f);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(forwardPitch));
            if (p.getCompositeRace().includes(Race.SEAPONY) && pony.asEntity().method_5869() && MineLPDelegate.getInstance().getPlayerPonyRace((class_1657)p.asEntity()) != Race.SEAPONY) {
                ModelPartHooks.startCollecting();
            }
        } else {
            Creature creature;
            float roll = negative ? 180.0f : 0.0f;
            matrices.method_22907(class_7833.field_40718.rotationDegrees(roll));
            if (pony instanceof Creature && this.smittenEyesRenderer.isSmitten(creature = (Creature)pony)) {
                ModelPartHooks.startCollecting();
            }
        }
        matrices.method_22904(-x, -y - (double)(owner.method_17682() / 2.0f), -z);
        if (negative) {
            this.flipAngles((class_1297)owner);
        }
        return this.disguiseLookup.getAppearanceFor(pony).map(effect -> this.disguiseRenderer.render(pony, (Disguise)effect, x, y, z, tickDelta, matrices, vertexConsumers, light)).orElse(false);
    }

    private void flipAngles(class_1297 entity) {
        if (entity instanceof class_1657) {
            entity.field_5982 *= -1.0f;
            entity.method_36456(entity.method_36454() * -1.0f);
            entity.field_6004 *= -1.0f;
            entity.method_36457(entity.method_36455() * -1.0f);
        }
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            living.field_6283 = -living.field_6283;
            living.field_6220 = -living.field_6220;
            living.field_6241 = -living.field_6241;
            living.field_6259 = -living.field_6259;
        }
    }
}

