/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render.model;

import com.minelittlepony.unicopia.client.render.model.BakedModel;
import java.util.function.Consumer;
import net.minecraft.class_3532;
import org.joml.Vector4f;

public class SphereModel
extends BakedModel {
    public static final SphereModel SPHERE = new SphereModel(40.0, 40.0, Math.PI * 2);
    public static final SphereModel DISK = new SphereModel(40.0, 2.0, Math.PI);
    public static final SphereModel HEXAGON = new SphereModel(3.0, 2.0, Math.PI * 2);
    public static final SphereModel PRISM = new SphereModel(6.0, 6.0, Math.PI * 2);

    public SphereModel(double rings, double sectors, double azimuthRange) {
        double zenithIncrement = Math.PI / rings;
        double azimuthIncrement = Math.PI * 2 / sectors;
        SphereModel.compileVertices(azimuthRange, zenithIncrement, azimuthIncrement, this::addVertex);
    }

    static void compileVertices(double azimuthRange, double zenithIncrement, double azimuthIncrement, Consumer<Vector4f> collector) {
        Vector4f vector = new Vector4f();
        for (double zenith = 0.0; zenith < Math.PI; zenith += zenithIncrement) {
            for (double azimuth = 0.0; azimuth < azimuthRange; azimuth += azimuthIncrement) {
                collector.accept(SphereModel.convertToCartesianCoord(vector, 1.0, zenith, azimuth));
                collector.accept(SphereModel.convertToCartesianCoord(vector, 1.0, zenith + zenithIncrement, azimuth));
                collector.accept(SphereModel.convertToCartesianCoord(vector, 1.0, zenith + zenithIncrement, azimuth + azimuthIncrement));
                collector.accept(SphereModel.convertToCartesianCoord(vector, 1.0, zenith, azimuth + azimuthIncrement));
            }
        }
    }

    public static Vector4f convertToCartesianCoord(Vector4f output, double r, double theta, double phi) {
        float st = class_3532.method_15374((float)((float)theta));
        output.set((float)(r * (double)st * (double)class_3532.method_15362((float)((float)phi))), (float)(r * (double)st * (double)class_3532.method_15374((float)((float)phi))), (float)(r * (double)class_3532.method_15362((float)((float)theta))), 1.0f);
        return output;
    }
}

