/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render.spell;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.minelittlepony.common.util.Color;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.effect.PortalSpell;
import com.minelittlepony.unicopia.client.render.RenderLayers;
import com.minelittlepony.unicopia.client.render.model.SphereModel;
import com.minelittlepony.unicopia.client.render.shader.UShaders;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.mixin.client.MixinMinecraftClient;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1723;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_6367;
import net.minecraft.class_638;
import net.minecraft.class_758;
import net.minecraft.class_761;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;
import org.joml.Vector4f;

class PortalFrameBuffer
implements AutoCloseable {
    private static final LoadingCache<UUID, PortalFrameBuffer> CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).removalListener(n -> ((PortalFrameBuffer)n.getValue()).close()).build(CacheLoader.from(PortalFrameBuffer::new));
    private static int recursionCount;
    @Nullable
    private class_6367 framebuffer;
    @Nullable
    private class_761 renderer;
    @Nullable
    private class_638 world;
    private final class_4184 camera = new class_4184();
    private boolean closed;
    private final class_310 client = class_310.method_1551();
    private boolean pendingDraw;
    @Nullable
    private class_4604 frustum;

    @Nullable
    public static PortalFrameBuffer unpool(UUID id) {
        try {
            return (PortalFrameBuffer)CACHE.get((Object)id);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    PortalFrameBuffer(UUID id) {
    }

    public void draw(class_4587 matrices, class_4597 vertices) {
        matrices.method_22904(0.0, -0.001, 0.0);
        RenderSystem.assertOnRenderThread();
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GlStateManager._enableDepthTest();
        GlStateManager._disableCull();
        if (!this.closed && this.framebuffer != null) {
            class_289 tessellator = RenderSystem.renderThreadTesselator();
            RenderSystem.setShader(UShaders.RENDER_TYPE_PORTAL_SURFACE);
            RenderSystem._setShaderTexture((int)0, (int)this.framebuffer.method_30277());
            class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            SphereModel.DISK.render(matrices, (class_4588)buffer, 1, 2.0f, -1);
            class_286.method_43433((class_9801)buffer.method_60800());
            this.client.method_1531().method_22813(class_1723.field_21668);
        } else {
            class_243 skyColor = this.client.field_1687.method_23777(this.client.field_1773.method_19418().method_19326(), this.client.method_60646().method_60637(false));
            SphereModel.DISK.render(matrices, vertices.getBuffer(RenderLayers.getMagicShield()), 0, 0, 2.0f, Color.argbToHex((float)1.0f, (float)((float)skyColor.field_1352), (float)((float)skyColor.field_1351), (float)((float)skyColor.field_1350)));
        }
        GlStateManager._enableCull();
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._depthMask((boolean)true);
    }

    public void build(PortalSpell spell, Caster<?> caster, EntityReference.EntityValues<class_1297> target) {
        this.closed = false;
        long refreshRate = (Long)Unicopia.getConfig().fancyPortalRefreshRate.get();
        if (refreshRate > 0L && this.framebuffer != null && System.currentTimeMillis() % refreshRate != 0L) {
            return;
        }
        if (this.pendingDraw && recursionCount > Math.max(0, (Integer)Unicopia.getConfig().maxPortalRecursion.get())) {
            this.innerBuild(spell, caster, target);
            return;
        }
        if (this.pendingDraw) {
            return;
        }
        this.pendingDraw = true;
        if (recursionCount > 0) {
            this.innerBuild(spell, caster, target);
        } else {
            ((MixinMinecraftClient)this.client).getRenderTaskQueue().add(() -> this.innerBuild(spell, caster, target));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerBuild(PortalSpell spell, Caster<?> caster, EntityReference.EntityValues<class_1297> target) {
        class_310 class_3102 = this.client;
        synchronized (class_3102) {
            this.pendingDraw = false;
            if (recursionCount > 0) {
                return;
            }
            ++recursionCount;
            class_1297 globalCameraEntity = this.client.field_1719;
            try {
                if (this.closed || this.client.field_1761 == null) {
                    this.close();
                    return;
                }
                class_4184 camera = this.client.field_1773.method_19418();
                class_1297 cameraEntity = UEntities.CAST_SPELL.method_5883(caster.asWorld());
                class_243 pos = target.pos();
                Quaternionf orientationChange = spell.getOrientationChange();
                Matrix4f positionMatrix = spell.getPositionMatrix(caster, target.pos(), orientationChange, new Matrix4f());
                Vector4f transformedPos = positionMatrix.transform(new Vector4f((Vector3fc)pos.method_46409(), 1.0f));
                cameraEntity.method_5814((double)transformedPos.x, (double)(transformedPos.y + 0.5f), (double)transformedPos.z);
                cameraEntity.method_36457(class_3532.method_15363((float)(camera.method_19329() - spell.getTargetPitch() + spell.getPitch()), (float)-90.0f, (float)90.0f));
                cameraEntity.method_36456(class_3532.method_15393((float)(camera.method_19330() + spell.getYawDifference())));
                this.client.field_1719 = cameraEntity;
                this.drawWorld(cameraEntity, 400, 400);
            }
            finally {
                this.client.field_1719 = globalCameraEntity;
                --recursionCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawWorld(class_1297 cameraEntity, int width, int height) {
        class_1041 window = this.client.method_22683();
        int globalFramebufferWidth = window.method_4489();
        int globalFramebufferHeight = window.method_4506();
        width = globalFramebufferWidth;
        height = globalFramebufferHeight;
        Matrix4f proj = RenderSystem.getProjectionMatrix();
        try {
            this.client.method_1522().method_1240();
            if (this.framebuffer == null) {
                this.framebuffer = new class_6367(width, height, true, class_310.field_1703);
                this.framebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
                this.framebuffer.method_1230(class_310.field_1703);
            }
            window.method_35642(width);
            window.method_35643(height);
            RenderSystem.clear((int)16640, (boolean)class_310.field_1703);
            this.framebuffer.method_1235(true);
            class_758.method_23792();
            RenderSystem.enableCull();
            if (cameraEntity.method_37908() != this.world) {
                this.world = (class_638)cameraEntity.method_37908();
            }
            if (this.renderer == null) {
                this.renderer = new class_761(this.client, this.client.method_1561(), this.client.method_31975(), this.client.method_22940());
                this.renderer.method_3244(this.world);
                this.renderer.method_18145(class_4076.method_18675((int)((int)cameraEntity.method_23317())), class_4076.method_18675((int)((int)cameraEntity.method_23318())), class_4076.method_18675((int)((int)cameraEntity.method_23321())));
            }
            this.camera.method_19321((class_1922)this.world, cameraEntity, false, false, 1.0f);
            double fov = 120.0;
            Matrix4f projectionMatrix = this.client.field_1773.method_22973(fov);
            Matrix4f cameraTransform = new Matrix4f().rotation((Quaternionfc)this.camera.method_23767().conjugate(new Quaternionf()));
            this.client.field_1773.method_22709(projectionMatrix);
            this.renderer.method_32133(this.camera.method_19326(), cameraTransform, this.client.field_1773.method_22973(Math.max(fov, (double)((Integer)this.client.field_1690.method_41808().method_41753()).intValue())));
            this.renderer.method_22710(this.client.method_60646(), false, this.camera, this.client.field_1773, this.client.field_1773.method_22974(), cameraTransform, projectionMatrix);
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.clear((int)16384, (boolean)class_310.field_1703);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            this.framebuffer.method_1240();
        }
        finally {
            this.client.method_1522().method_1235(true);
            this.client.field_1773.method_22709(proj);
            this.client.method_31975().method_3551((class_1937)this.client.field_1687);
            window.method_35642(globalFramebufferWidth);
            window.method_35643(globalFramebufferHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        class_310 class_3102 = this.client;
        synchronized (class_3102) {
            this.closed = true;
            if (this.framebuffer != null) {
                class_6367 fb = this.framebuffer;
                this.framebuffer = null;
                fb.method_1238();
            }
            if (this.renderer != null) {
                this.renderer.method_34810().method_3619();
                this.renderer.close();
                this.renderer = null;
            }
        }
    }
}

