/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.command;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.PlacementControlSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.command.TraitsArgumentType;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2270;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_7079;
import net.minecraft.class_7157;

public class CastCommand {
    public static LiteralArgumentBuilder<class_2168> create(class_7157 registries) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cast").requires(s -> s.method_9259(2))).then(CastCommand.buildBranches(class_2170.method_9244((String)"spell", (ArgumentType)class_7079.method_41224(SpellType.REGISTRY_KEY)), c -> Optional.empty()))).then(class_2170.method_9244((String)"spell", (ArgumentType)class_7079.method_41224(SpellType.REGISTRY_KEY)).then(CastCommand.buildBranches(class_2170.method_9244((String)"traits", (ArgumentType)TraitsArgumentType.traits()), CastCommand::getTraits)));
    }

    private static ArgumentBuilder<class_2168, ?> buildBranches(ArgumentBuilder<class_2168, ?> builder, TraitsFunc traitsFunc) {
        return builder.then(class_2170.method_9247((String)"throw").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"rot", (ArgumentType)class_2270.method_9717()).executes(c -> CastCommand.thrown((CommandContext<class_2168>)c, traitsFunc, 1.5f))).then(class_2170.method_9244((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)10.0f)).executes(c -> CastCommand.thrown((CommandContext<class_2168>)c, traitsFunc, FloatArgumentType.getFloat((CommandContext)c, (String)"speed")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"place").executes(c -> CastCommand.placed((CommandContext<class_2168>)c, traitsFunc, Optional.empty(), ((class_2168)c.getSource()).method_9210()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"loc", (ArgumentType)class_2262.method_9698()).executes(c -> CastCommand.placed((CommandContext<class_2168>)c, traitsFunc, Optional.of(class_2262.method_48299((CommandContext)c, (String)"loc").method_46558()), ((class_2168)c.getSource()).method_9210()))).then(class_2170.method_9244((String)"rot", (ArgumentType)class_2270.method_9717()).executes(c -> CastCommand.placed((CommandContext<class_2168>)c, traitsFunc, Optional.of(class_2262.method_48299((CommandContext)c, (String)"loc").method_46558()), class_2270.method_9716((CommandContext)c, (String)"rot").method_9709((class_2168)c.getSource())))))).then(class_2170.method_9247((String)"apply").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(c -> CastCommand.apply((CommandContext<class_2168>)c, traitsFunc))));
    }

    private static Optional<SpellTraits> getTraits(CommandContext<class_2168> source) throws CommandSyntaxException {
        return Optional.of(TraitsArgumentType.getSpellTraits(source, "traits"));
    }

    private static CustomisedSpellType<?> getSpell(CommandContext<class_2168> source, TraitsFunc traits) throws CommandSyntaxException {
        SpellType<?> spellType = SpellType.fromArgument(source, "spell");
        return spellType.withTraits(traits.getTraits(source).orElse(spellType.getTraits()));
    }

    private static int thrown(CommandContext<class_2168> source, TraitsFunc traits, float speed) throws CommandSyntaxException {
        class_3222 player = ((class_2168)source.getSource()).method_9207();
        Object spell = CastCommand.getSpell(source, traits).create();
        if (spell != null) {
            spell.toThrowable().throwProjectile(Caster.of((class_1297)player).orElseThrow()).ifPresent(projectile -> {
                class_241 rotation = class_2270.method_9716((CommandContext)source, (String)"rot").method_9709((class_2168)source.getSource());
                projectile.method_24919((class_1297)player, rotation.field_1343, rotation.field_1342, 0.0f, speed, 1.0f);
            });
        }
        return 0;
    }

    private static int placed(CommandContext<class_2168> source, TraitsFunc traits, Optional<class_243> position, class_241 rotation) throws CommandSyntaxException {
        class_3222 player = ((class_2168)source.getSource()).method_9207();
        Object spellType = CastCommand.getSpell(source, traits).create();
        if (spellType == null) {
            return 0;
        }
        PlacementControlSpell spell = spellType.toPlaceable();
        Caster<?> caster = Caster.of((class_1297)player).orElseThrow();
        spell.setOrientation(caster, rotation.field_1343, rotation.field_1342);
        position.ifPresent(spell::setPosition);
        spell.apply(caster);
        return 0;
    }

    private static int apply(CommandContext<class_2168> source, TraitsFunc traits) throws CommandSyntaxException {
        CustomisedSpellType<?> spellType = CastCommand.getSpell(source, traits);
        class_2186.method_9317(source, (String)"targets").forEach(target -> Caster.of(target).ifPresent(caster -> spellType.apply((Caster<?>)caster, CastingMethod.INNATE)));
        return 0;
    }

    static interface TraitsFunc {
        public Optional<SpellTraits> getTraits(CommandContext<class_2168> var1) throws CommandSyntaxException;
    }
}

