/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.compat.tla;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.block.UBlocks;
import com.minelittlepony.unicopia.compat.tla.CloudShapingTlaRecipe;
import com.minelittlepony.unicopia.compat.tla.SpellbookTlaRecipe;
import com.minelittlepony.unicopia.compat.tla.StructureInteractionTlaRecipe;
import com.minelittlepony.unicopia.item.UItems;
import io.github.mattidragon.tlaapi.api.plugin.PluginContext;
import io.github.mattidragon.tlaapi.api.recipe.CategoryIcon;
import io.github.mattidragon.tlaapi.api.recipe.TlaCategory;
import io.github.mattidragon.tlaapi.api.recipe.TlaIngredient;
import io.github.mattidragon.tlaapi.api.recipe.TlaStack;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public record RecipeCategory(class_2960 id, CategoryIcon icon, TlaIngredient stations, int width, int height) implements TlaCategory
{
    static final Map<RecipeCategory, @Nullable BiConsumer<RecipeCategory, PluginContext>> REGISTRY = new HashMap<RecipeCategory, BiConsumer<RecipeCategory, PluginContext>>();
    static final RecipeCategory SPELL_BOOK = RecipeCategory.register("spellbook", (class_1935)UItems.SPELLBOOK, 150, 75, SpellbookTlaRecipe::generate);
    static final RecipeCategory CLOUD_SHAPING = RecipeCategory.register("cloud_shaping", (class_1935)UBlocks.SHAPING_BENCH, 76, 18, CloudShapingTlaRecipe::generate);
    static final RecipeCategory GROWING = RecipeCategory.register("growing", (class_1935)class_2246.field_10362, 130, 85, StructureInteractionTlaRecipe::generateFarmingRecipes);
    static final RecipeCategory ALTAR = RecipeCategory.register("altar", (class_1935)class_2246.field_22423, 130, 160, StructureInteractionTlaRecipe::generateAltarRecipes);

    static RecipeCategory register(String name, class_1935 item, int width, int height, @Nullable BiConsumer<RecipeCategory, PluginContext> recipeConstructor) {
        return RecipeCategory.register(new RecipeCategory(Unicopia.id(name), CategoryIcon.item((class_1935)item), TlaStack.of((class_1935)item).asIngredient(), width, height), recipeConstructor);
    }

    static RecipeCategory register(RecipeCategory category, @Nullable BiConsumer<RecipeCategory, PluginContext> recipeConstructor) {
        REGISTRY.put(category, recipeConstructor);
        return category;
    }

    static void bootstrap(PluginContext registry) {
        REGISTRY.forEach((category, recipeConstructor) -> {
            registry.addCategory((TlaCategory)category);
            registry.addWorkstation((TlaCategory)category, new TlaIngredient[]{category.stations()});
            try {
                if (recipeConstructor != null) {
                    recipeConstructor.accept(category, registry);
                }
            }
            catch (Throwable t) {
                Unicopia.LOGGER.fatal("Error occured whilst registering recipes for category " + String.valueOf(category.getId()), t);
            }
        });
    }

    public class_2960 getId() {
        return this.id;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    public int getDisplayWidth() {
        return this.width;
    }

    public CategoryIcon getIcon() {
        return this.icon;
    }

    public CategoryIcon getSimpleIcon() {
        return this.icon;
    }
}

