/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.compat.tla;

import com.google.common.base.Suppliers;
import com.minelittlepony.unicopia.ability.magic.spell.crafting.SpellDuplicatingRecipe;
import com.minelittlepony.unicopia.ability.magic.spell.crafting.SpellEnhancingRecipe;
import com.minelittlepony.unicopia.ability.magic.spell.crafting.SpellbookRecipe;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookScreen;
import com.minelittlepony.unicopia.compat.tla.Main;
import com.minelittlepony.unicopia.compat.tla.RecipeCategory;
import com.minelittlepony.unicopia.compat.tla.SpellDuplicatingTlaRecipe;
import com.minelittlepony.unicopia.compat.tla.SpellEnhancingTlaRecipe;
import com.minelittlepony.unicopia.compat.tla.TraitedTlaIngredient;
import com.minelittlepony.unicopia.container.inventory.HexagonalCraftingGrid;
import com.minelittlepony.unicopia.recipe.URecipes;
import io.github.mattidragon.tlaapi.api.gui.GuiBuilder;
import io.github.mattidragon.tlaapi.api.gui.TextureConfig;
import io.github.mattidragon.tlaapi.api.gui.TlaBounds;
import io.github.mattidragon.tlaapi.api.plugin.PluginContext;
import io.github.mattidragon.tlaapi.api.recipe.TlaIngredient;
import io.github.mattidragon.tlaapi.api.recipe.TlaRecipe;
import io.github.mattidragon.tlaapi.api.recipe.TlaStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

class SpellbookTlaRecipe
implements TlaRecipe,
SpellbookRecipe.CraftingTreeBuilder {
    private final class_8786<SpellbookRecipe> recipe;
    protected final List<TraitedTlaIngredient> inputs = new ArrayList<TraitedTlaIngredient>();
    private final List<TlaStack> outputs = new ArrayList<TlaStack>();
    private final Supplier<List<TlaIngredient>> ingredients;

    static void generate(RecipeCategory category, PluginContext context) {
        context.addGenerator(client -> client.field_1687.method_8433().method_30027(URecipes.SPELLBOOK).stream().flatMap(recipe -> {
            if (recipe.comp_1933() instanceof SpellDuplicatingRecipe) {
                return Stream.of(new SpellDuplicatingTlaRecipe((class_8786<SpellbookRecipe>)recipe));
            }
            if (recipe.comp_1933() instanceof SpellEnhancingRecipe) {
                return Trait.all().stream().map(trait -> new SpellEnhancingTlaRecipe((class_8786<SpellbookRecipe>)recipe, (Trait)trait));
            }
            return Stream.of(new SpellbookTlaRecipe((class_8786<SpellbookRecipe>)recipe));
        }).toList());
    }

    public SpellbookTlaRecipe(class_8786<SpellbookRecipe> recipe) {
        this.recipe = recipe;
        this.ingredients = Suppliers.memoize(() -> this.inputs.stream().map(TraitedTlaIngredient::ingredient).toList());
        ((SpellbookRecipe)recipe.comp_1933()).buildCraftingTree(this);
    }

    public RecipeCategory getCategory() {
        return RecipeCategory.SPELL_BOOK;
    }

    @Nullable
    public class_2960 getId() {
        return this.recipe.comp_1932();
    }

    public List<TlaIngredient> getInputs() {
        return this.ingredients.get();
    }

    public List<TlaStack> getOutputs() {
        return this.outputs;
    }

    public List<TlaIngredient> getCatalysts() {
        return List.of();
    }

    public void buildGui(GuiBuilder builder) {
        TlaBounds bounds = builder.getBounds();
        builder.addTexture(TextureConfig.builder().texture(SpellbookScreen.TEXTURE).size(bounds.width(), bounds.height()).uv(50, 50).regionSize(128, 128).textureSize(512, 256).build(), 0, 0);
        builder.addTexture(Main.EMPTY_ARROW, 85, 30);
        ArrayList<HexagonalCraftingGrid.Slot> grid = new ArrayList<HexagonalCraftingGrid.Slot>();
        ArrayList<HexagonalCraftingGrid.Slot> gem = new ArrayList<HexagonalCraftingGrid.Slot>();
        HexagonalCraftingGrid.create(-34, -5, 3, grid, gem);
        int currentInput = 1;
        for (int i = 0; i < grid.size(); ++i) {
            HexagonalCraftingGrid.Slot slot = (HexagonalCraftingGrid.Slot)grid.get(i);
            if (currentInput < this.inputs.size() && slot.weight() == 1.0f) {
                this.inputs.get(currentInput++).buildGui(slot, builder);
                continue;
            }
            if (slot.weight() != 1.0f) continue;
            this.inputs.get(0).buildGui(TlaIngredient.EMPTY, slot, builder);
        }
        this.inputs.get(0).buildGui((HexagonalCraftingGrid.Slot)gem.get(0), builder);
        builder.addSlot(this.getOutput(), 120, 25).makeLarge().markOutput();
    }

    protected TlaIngredient getOutput() {
        return TlaIngredient.ofStacks(this.outputs);
    }

    @Override
    public void input(class_1799 ... stacks) {
        this.inputs.add(TraitedTlaIngredient.of(TlaIngredient.ofStacks(Arrays.stream(stacks).map(TlaStack::of).toList())));
    }

    @Override
    public void input(Trait ... traits) {
        this.inputs.add(TraitedTlaIngredient.of(List.of(traits), 1.0f));
    }

    @Override
    public void input(Trait trait, float value) {
        this.inputs.add(TraitedTlaIngredient.of(trait, value));
    }

    @Override
    public void result(class_1799 ... stack) {
        this.outputs.addAll(Arrays.stream(stack).map(TlaStack::of).toList());
    }
}

