/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.compat.trinkets;

import com.minelittlepony.unicopia.compat.trinkets.SlotKey;
import com.minelittlepony.unicopia.compat.trinkets.TrinketsDelegateImpl;
import com.minelittlepony.unicopia.container.SpellbookScreenHandler;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public interface TrinketsDelegate {
    public static final SlotKey MAIN_GLOVE = SlotKey.of("hand", "glove");
    public static final SlotKey SECONDARY_GLOVE = SlotKey.of("offhand", "glove");
    public static final SlotKey NECKLACE = SlotKey.of("chest", "necklace");
    public static final SlotKey FACE = SlotKey.of("head", "face");
    public static final Set<SlotKey> ALL = new TreeSet<SlotKey>(List.of(MAIN_GLOVE, SECONDARY_GLOVE, NECKLACE, FACE));
    public static final TrinketsDelegate EMPTY = new TrinketsDelegate(){};

    public static TrinketsDelegate getInstance(@Nullable class_1309 entity) {
        if (!TrinketsDelegate.hasTrinkets() || entity != null && !(entity instanceof class_1657)) {
            return EMPTY;
        }
        return TrinketsDelegateImpl.INSTANCE;
    }

    public static boolean hasTrinkets() {
        return FabricLoader.getInstance().isModLoaded("trinkets");
    }

    default public void bootstrap() {
    }

    default public boolean equipStack(class_1309 entity, class_1799 stack) {
        class_1304 eq = entity.method_32326(stack);
        if (!entity.method_6118(eq).method_7960()) {
            return false;
        }
        entity.method_5673(eq, stack.method_7971(1));
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            mob.method_5946(eq, 2.0f);
            mob.method_5971();
        }
        return true;
    }

    default public Stream<EquippedStack> getEquipped(class_1309 entity, SlotKey slot, class_6862<class_1792> tag) {
        return this.getEquipped(entity, slot, (class_1799 stack) -> stack.method_31573(tag));
    }

    default public Stream<EquippedStack> getEquipped(class_1309 entity, SlotKey slot) {
        return this.getEquipped(entity, slot, (Predicate<class_1799>)null);
    }

    default public Stream<EquippedStack> getEquipped(class_1309 entity, SlotKey slot, @Nullable Predicate<class_1799> predicate) {
        if (slot == FACE && (predicate == null || predicate.test(entity.method_6118(class_1304.field_6169)))) {
            return Stream.of(new EquippedStack(entity, class_1304.field_6169));
        }
        if (!(slot != NECKLACE && slot != MAIN_GLOVE || predicate != null && !predicate.test(entity.method_6118(class_1304.field_6174)))) {
            return Stream.of(new EquippedStack(entity, class_1304.field_6174));
        }
        if (slot == SECONDARY_GLOVE && (predicate == null || predicate.test(entity.method_6118(class_1304.field_6171)))) {
            return Stream.of(new EquippedStack(entity, class_1304.field_6171));
        }
        return Stream.empty();
    }

    default public void registerTrinket(class_1792 item) {
    }

    default public Optional<class_1735> createSlot(SpellbookScreenHandler handler, class_1309 entity, SlotKey slotId, int i, int x, int y) {
        return Optional.empty();
    }

    default public boolean isTrinketSlot(class_1735 slot) {
        return false;
    }

    public record EquippedStack(class_1799 stack, Runnable sendUpdate, Consumer<class_1799> updater, Consumer<class_1792> breakStatusSender) {
        public static final EquippedStack EMPTY = new EquippedStack(class_1799.field_8037, () -> {}, s -> {}, l -> {});

        EquippedStack(class_1309 entity, class_1304 slot) {
            this(entity.method_6118(slot), () -> {}, s -> entity.method_5673(slot, s), item -> entity.method_20235(item, slot));
        }

        public void set(class_1799 stack) {
            this.updater.accept(stack);
        }
    }
}

