/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.container;

import com.minelittlepony.unicopia.ability.magic.spell.crafting.SpellbookRecipe;
import com.minelittlepony.unicopia.compat.trinkets.TrinketsDelegate;
import com.minelittlepony.unicopia.container.SpellbookState;
import com.minelittlepony.unicopia.container.UScreenHandlers;
import com.minelittlepony.unicopia.container.inventory.HexagonalCraftingGrid;
import com.minelittlepony.unicopia.container.inventory.IngredientSlot;
import com.minelittlepony.unicopia.container.inventory.InputSlot;
import com.minelittlepony.unicopia.container.inventory.InventorySlot;
import com.minelittlepony.unicopia.container.inventory.OutputSlot;
import com.minelittlepony.unicopia.container.inventory.SlotType;
import com.minelittlepony.unicopia.container.inventory.SpellSlot;
import com.minelittlepony.unicopia.container.inventory.SpellbookInventory;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.recipe.URecipes;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_5151;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9331;
import net.minecraft.class_9695;
import net.minecraft.class_9701;
import org.jetbrains.annotations.Nullable;

public class SpellbookScreenHandler
extends class_1703 {
    private static final class_2960[] EMPTY_ARMOR_SLOT_TEXTURES = new class_2960[]{class_1723.field_21672, class_1723.field_21671, class_1723.field_21670, class_1723.field_21669};
    private final int MAX_INGREDIENTS;
    public final int GEM_SLOT_INDEX;
    private final int HOTBAR_START;
    private final int HOTBAR_END;
    private final SpellbookInventory input;
    public InputSlot gemSlot;
    public OutputSlot outputSlot;
    private final class_1731 result = new class_1731();
    private final class_1661 inventory;
    private final class_3914 context;
    private final SpellbookState state;
    @Nullable
    public UUID entityId;

    protected SpellbookScreenHandler(int syncId, class_1661 inv, SpellbookState state) {
        this(syncId, inv, class_3914.field_17304, state, null);
    }

    public SpellbookScreenHandler(int syncId, class_1661 inv, class_3914 context, SpellbookState state, UUID entityId) {
        super(UScreenHandlers.SPELL_BOOK, syncId);
        this.entityId = entityId;
        this.state = state;
        this.inventory = inv;
        this.context = context;
        ArrayList<HexagonalCraftingGrid.Slot> grid = new ArrayList<HexagonalCraftingGrid.Slot>();
        ArrayList<HexagonalCraftingGrid.Slot> gemPos = new ArrayList<HexagonalCraftingGrid.Slot>();
        HexagonalCraftingGrid.create(34, 65, 3, grid, gemPos);
        this.GEM_SLOT_INDEX = this.MAX_INGREDIENTS = grid.size();
        this.HOTBAR_START = this.GEM_SLOT_INDEX + 1;
        this.HOTBAR_END = this.HOTBAR_START + 9;
        this.input = new SpellbookInventory(this, this.MAX_INGREDIENTS + 1, 1);
        for (int i = 0; i < this.MAX_INGREDIENTS; ++i) {
            HexagonalCraftingGrid.Slot pos = (HexagonalCraftingGrid.Slot)grid.get(i);
            this.method_7621(new IngredientSlot(this, (class_1263)this.input, i, pos));
        }
        this.gemSlot = new InputSlot(this, (class_1263)this.input, this.MAX_INGREDIENTS, (HexagonalCraftingGrid.Slot)gemPos.get(0));
        this.method_7621(this.gemSlot);
        int slotSpacing = 18;
        int halfSpacing = 9;
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)this.inventory, i, 121 + i * 18, 195));
        }
        int inventoryX = 225;
        int inventoryY = 45;
        for (int i = 0; i < 27; ++i) {
            int x = i % 4;
            int y = i / 4;
            this.method_7621(new InventorySlot(this, (class_1263)this.inventory, i + 9, 225 + x * 18, 45 + y * 18));
        }
        int armorX = 330;
        int armorY = 63;
        int equipmentY = 72;
        int leftHandX = 312;
        int rightHandX = 348;
        for (int i = 0; i < 4; ++i) {
            final class_1304 eq = class_1304.values()[5 - i];
            this.method_7621(new InventorySlot(this, this, (class_1263)this.inventory, 40 - i - 1, 330, 63 + i * 18){

                public int method_7675() {
                    return 1;
                }

                public boolean method_7680(class_1799 stack) {
                    class_5151 equipment = class_5151.method_48957((class_1799)stack);
                    return equipment != null && eq == equipment.method_7685();
                }

                public boolean method_7674(class_1657 playerEntity) {
                    class_1799 stack = this.method_7677();
                    if (!stack.method_7960() && !playerEntity.method_7337() && class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51656)) {
                        return false;
                    }
                    return super.method_7674(playerEntity);
                }

                public Pair<class_2960, class_2960> method_7679() {
                    return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_ARMOR_SLOT_TEXTURES[eq.method_5927()]);
                }
            });
        }
        this.method_7621(new InventorySlot(this, this, (class_1263)this.inventory, 40, 348, 90){

            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)class_1723.field_21673);
            }
        });
        TrinketsDelegate.getInstance((class_1309)inv.field_7546).createSlot(this, (class_1309)inv.field_7546, TrinketsDelegate.FACE, 0, 348, 153).ifPresent(x$0 -> this.method_7621((class_1735)x$0));
        TrinketsDelegate.getInstance((class_1309)inv.field_7546).createSlot(this, (class_1309)inv.field_7546, TrinketsDelegate.NECKLACE, 0, 312, 90).ifPresent(x$0 -> this.method_7621((class_1735)x$0));
        TrinketsDelegate.getInstance((class_1309)inv.field_7546).createSlot(this, (class_1309)inv.field_7546, TrinketsDelegate.MAIN_GLOVE, 0, 312, 72).ifPresent(x$0 -> this.method_7621((class_1735)x$0));
        TrinketsDelegate.getInstance((class_1309)inv.field_7546).createSlot(this, (class_1309)inv.field_7546, TrinketsDelegate.SECONDARY_GLOVE, 0, 348, 72).ifPresent(x$0 -> this.method_7621((class_1735)x$0));
        this.outputSlot = new OutputSlot(this, this.inventory.field_7546, this.input, (class_1263)this.result, 0, (HexagonalCraftingGrid.Slot)gemPos.get(0));
        this.method_7621((class_1735)this.outputSlot);
        this.method_7621(new SpellSlot(this, Pony.of(this.inventory.field_7546), class_1268.field_5808, (class_1263)this.inventory, 0, 312, 54));
        this.method_7621(new SpellSlot(this, Pony.of(this.inventory.field_7546), class_1268.field_5810, (class_1263)this.inventory, 0, 348, 54));
        this.method_7609((class_1263)this.input);
    }

    public SpellbookState getSpellbookState() {
        return this.state;
    }

    public boolean canShowSlots(SlotType type) {
        class_2960 pageId = this.state.getCurrentPageId().orElse(null);
        boolean isCraftingPage = SpellbookState.CRAFTING_ID.equals((Object)pageId);
        return switch (type) {
            default -> throw new MatchException(null, null);
            case SlotType.INVENTORY -> {
                if (isCraftingPage) {
                    if (this.state.getState(pageId).getOffset() == 0) {
                        yield true;
                    }
                    yield false;
                }
                yield SpellbookState.PROFILE_ID.equals((Object)pageId);
            }
            case SlotType.CRAFTING -> isCraftingPage;
        };
    }

    public int getOutputSlotId() {
        return this.outputSlot.field_7874;
    }

    public boolean method_7597(class_1657 player) {
        return player.method_5805();
    }

    public void method_7609(class_1263 inventory) {
        super.method_7609(inventory);
        this.context.method_17393((world, pos) -> {
            if (!world.field_9236 && !this.gemSlot.method_7677().method_7960()) {
                Comparator<class_8786> comparator = Comparator.comparing(e -> ((SpellbookRecipe)e.comp_1933()).getPriority());
                SpellbookRecipe.Input input = this.input.createInput();
                class_1799 resultStack = input.hasIngredients() ? world.method_8503().method_3772().method_17877(URecipes.SPELLBOOK, (class_9695)input, world).stream().sorted(comparator).findFirst().filter(recipe -> this.result.method_7665(world, (class_3222)this.inventory.field_7546, recipe)).map(recipe -> ((SpellbookRecipe)recipe.comp_1933()).method_8116(input, (class_7225.class_7874)world.method_30349())).orElseGet(input::getFallbackStack) : class_1799.field_8037;
                this.outputSlot.method_53512(resultStack);
                this.method_34245(this.outputSlot.field_7874, resultStack);
                ((class_3222)this.inventory.field_7546).field_13987.method_14364((class_2596)new class_2653(this.field_7763, this.method_37422(), this.outputSlot.field_7874, this.outputSlot.method_7677()));
            }
        });
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot != null && slot.method_7680(stack) && slot.method_7682();
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1735 sourceSlot = (class_1735)this.field_7761.get(index);
        if (sourceSlot == null || !sourceSlot.method_7681() || sourceSlot instanceof SpellSlot) {
            return class_1799.field_8037;
        }
        class_1799 transferredStack = sourceSlot.method_7677();
        class_1799 stack = transferredStack.method_7972();
        if (sourceSlot instanceof OutputSlot) {
            OutputSlot result = (OutputSlot)sourceSlot;
            result.method_7667(player, stack);
        }
        if (index >= this.HOTBAR_START && !(sourceSlot instanceof OutputSlot) && !(sourceSlot instanceof InputSlot)) {
            if (this.canShowSlots(SlotType.CRAFTING)) {
                if (!this.gemSlot.method_7681() && this.gemSlot.method_7680(stack) && this.method_7616(transferredStack, this.GEM_SLOT_INDEX, this.GEM_SLOT_INDEX + 1, false)) {
                    this.method_7609((class_1263)this.input);
                    return class_1799.field_8037;
                }
                if (this.method_7616(transferredStack, 0, this.GEM_SLOT_INDEX, false)) {
                    sourceSlot.method_7670(transferredStack, stack);
                    this.method_7609((class_1263)this.input);
                    return class_1799.field_8037;
                }
            }
            if (index < this.HOTBAR_END) {
                if (this.canShowSlots(SlotType.INVENTORY)) {
                    if (this.method_7616(transferredStack, this.HOTBAR_END + 27, this.HOTBAR_END + 27 + 4, false)) {
                        sourceSlot.method_7670(transferredStack, stack);
                        this.method_7609((class_1263)this.input);
                        return class_1799.field_8037;
                    }
                    if (this.method_7616(transferredStack, this.HOTBAR_END, this.HOTBAR_END + 27, false)) {
                        sourceSlot.method_7670(transferredStack, stack);
                        this.method_7609((class_1263)this.input);
                        return class_1799.field_8037;
                    }
                }
            } else if (this.method_7616(transferredStack, this.HOTBAR_START, this.HOTBAR_END, true)) {
                sourceSlot.method_7670(transferredStack, stack);
                this.method_7609((class_1263)this.input);
                return class_1799.field_8037;
            }
        } else {
            if (this.method_7616(transferredStack, this.HOTBAR_START, this.HOTBAR_END, true)) {
                sourceSlot.method_7670(transferredStack, stack);
                this.method_7609((class_1263)this.input);
                return class_1799.field_8037;
            }
            if (this.canShowSlots(SlotType.INVENTORY)) {
                if (this.method_7616(transferredStack, this.HOTBAR_END + 27, this.HOTBAR_END + 27 + 4, false)) {
                    sourceSlot.method_7670(transferredStack, stack);
                    this.method_7609((class_1263)this.input);
                    return class_1799.field_8037;
                }
                if (this.method_7616(transferredStack, this.HOTBAR_END, this.HOTBAR_END + 27, false)) {
                    sourceSlot.method_7670(transferredStack, stack);
                    this.method_7609((class_1263)this.input);
                    return class_1799.field_8037;
                }
            }
        }
        if (transferredStack.method_7947() == stack.method_7947()) {
            return class_1799.field_8037;
        }
        sourceSlot.method_7667(player, transferredStack);
        return stack;
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        class_1735 class_17352;
        if (slotIndex >= 0 && slotIndex < this.field_7761.size() && (class_17352 = this.method_7611(slotIndex)) instanceof SpellSlot) {
            SpellSlot slot = (SpellSlot)class_17352;
            class_1799 cursorStack = this.method_34255();
            if (actionType == class_1713.field_7790 && cursorStack.method_31574(UItems.GEMSTONE) && cursorStack.method_7947() == 1) {
                slot.swapSpells(cursorStack);
            }
        } else {
            super.method_7593(slotIndex, button, actionType, player);
        }
    }

    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean fromLast) {
        class_1799 current;
        class_1735 slot;
        int i;
        boolean success = false;
        int n = i = fromLast ? endIndex - 1 : startIndex;
        while (i >= startIndex && i < endIndex) {
            int available;
            slot = this.method_7611(i);
            current = slot.method_7677();
            if (!current.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)current) && (available = Math.min(Math.min(current.method_7914(), slot.method_7676(stack)) - current.method_7947(), stack.method_7947())) > 0) {
                current.method_7933(available);
                stack.method_7934(available);
                slot.method_7668();
                success = true;
            }
            i += fromLast ? -1 : 1;
        }
        int n2 = i = fromLast ? endIndex - 1 : startIndex;
        while (i >= startIndex && i < endIndex) {
            slot = this.method_7611(i);
            current = slot.method_7677();
            if (current.method_7960() && slot.method_7680(stack)) {
                if (stack.method_7947() > slot.method_7676(stack)) {
                    slot.method_53512(stack.method_7971(slot.method_7676(stack)));
                } else {
                    slot.method_53512(stack.method_7971(stack.method_7947()));
                }
                slot.method_7668();
                success = true;
                break;
            }
            i += fromLast ? -1 : 1;
        }
        return success;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, (class_1263)this.input));
    }
}

