/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.container;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.network.datasync.Synchronizable;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class SpellbookState
extends Synchronizable<SpellbookState> {
    public static final Codec<SpellbookState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("current_page").forGetter(i -> i.currentPageId), (App)Codec.unboundedMap((Codec)class_2960.field_25139, PageState.CODEC).fieldOf("states").forGetter(i -> i.states)).apply((Applicative)instance, SpellbookState::new));
    public static final class_9139<class_9129, SpellbookState> PACKET_CODEC = class_9139.method_56435((class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), SpellbookState::getCurrentPageId, (class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_2960.field_48267, PageState.PACKET_CODEC), p -> p.states, SpellbookState::new);
    public static final class_2960 CRAFTING_ID = Unicopia.id("crafting");
    public static final class_2960 PROFILE_ID = Unicopia.id("profile");
    public static final class_2960 TRAIT_DEX_ID = Unicopia.id("traits");
    private Optional<class_2960> currentPageId = Optional.empty();
    private boolean dirty;
    private final Map<class_2960, PageState> states = new HashMap<class_2960, PageState>();

    public SpellbookState() {
    }

    private SpellbookState(Optional<class_2960> currentPageId, Map<class_2960, PageState> states) {
        this.currentPageId = currentPageId;
        states.forEach((id, state) -> {
            this.getState((class_2960)id).offset = state.offset;
        });
    }

    public boolean isDirty() {
        boolean isDirty = this.dirty;
        this.dirty = false;
        return isDirty;
    }

    public Optional<class_2960> getCurrentPageId() {
        return this.currentPageId;
    }

    public void setCurrentPageId(class_2960 pageId) {
        this.currentPageId = Optional.ofNullable(pageId);
        this.synchronize();
    }

    public PageState getState(class_2960 pageId) {
        return this.states.computeIfAbsent(pageId, i -> new PageState(page -> this.synchronize()));
    }

    @Override
    public void copyFrom(SpellbookState state) {
        this.currentPageId = state.currentPageId;
        state.states.forEach((id, page) -> this.getState((class_2960)id).copyFrom((PageState)page));
        this.dirty = true;
    }

    public SpellbookState createCopy() {
        SpellbookState copy = new SpellbookState();
        copy.currentPageId = this.currentPageId;
        this.states.forEach((id, state) -> {
            copy.getState((class_2960)id).offset = state.offset;
        });
        return copy;
    }

    public static class PageState
    extends Synchronizable<PageState> {
        public static final Codec<PageState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("offset").forGetter(PageState::getOffset)).apply((Applicative)instance, PageState::new));
        public static final class_9139<ByteBuf, PageState> PACKET_CODEC = class_9135.field_49675.method_56432(PageState::new, PageState::getOffset);
        private int offset;

        public PageState() {
        }

        PageState(Consumer<PageState> synchronizer) {
            this.setSynchronizer(synchronizer);
        }

        public PageState(int offset) {
            this.offset = offset;
        }

        @Override
        public void copyFrom(PageState other) {
            this.offset = other.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
            this.synchronize();
        }

        public int getOffset() {
            return this.offset;
        }

        public void swap(int incr, int max) {
            this.setOffset(class_3532.method_15340((int)(this.getOffset() + incr), (int)0, (int)(max - 1)));
        }
    }
}

