/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.datagen.providers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4915;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4944;

public final class ModelOverrides {
    private final class_4942 model;
    private final List<Override> overrides = new ArrayList<Override>();

    public static ModelOverrides of(class_4942 model) {
        return new ModelOverrides(model);
    }

    private ModelOverrides(class_4942 model) {
        this.model = model;
    }

    public <T> ModelOverrides addUniform(String key, Iterable<T> values, Function<T, Float> idFunc, Function<T, class_2960> childModelSupplier) {
        for (T t : values) {
            this.addOverride(childModelSupplier.apply(t), key, idFunc.apply(t).floatValue());
        }
        return this;
    }

    public ModelOverrides addUniform(String key, int from, int to, class_2960 model) {
        float step = 1.0f / (float)to;
        for (int index = from; index <= to; ++index) {
            this.addOverride(model.method_48331("_" + index), key, (float)index * step);
        }
        return this;
    }

    public ModelOverrides addUniform(String key, float from, float to, float step, ModelVariantSupplier childModelSupplier) {
        int index = 0;
        for (float value = from; value <= to; value += step) {
            int capture = index++;
            float capture2 = value;
            this.addOverride(key, value, generator -> childModelSupplier.upload(capture, capture2));
        }
        return this;
    }

    public ModelOverrides addOverride(class_2960 modelId, String key, float value) {
        return this.addOverride(modelId, class_4944.method_25895((class_2960)modelId), key, value);
    }

    public ModelOverrides addOverride(class_2960 modelId, class_4944 textures, String key, float value) {
        return this.addOverride(key, value, generator -> this.model.method_25852(modelId, textures, generator.field_22844));
    }

    public ModelOverrides addOverride(String key, float value, Function<class_4915, class_2960> generator) {
        return this.addOverride(Map.of(key, Float.valueOf(value)), generator);
    }

    public ModelOverrides addOverride(Map<String, Float> predicate, Function<class_4915, class_2960> generator) {
        this.overrides.add(new Override(predicate, generator));
        return this;
    }

    public class_2960 upload(class_1792 item, class_4915 generator) {
        return this.upload(item, "", generator);
    }

    public class_2960 upload(class_1792 item, String suffex, class_4915 generator) {
        return this.upload(class_4941.method_25840((class_1792)item), class_4944.method_25895((class_2960)class_4941.method_25841((class_1792)item, (String)suffex)), generator);
    }

    public class_2960 upload(class_2960 id, class_4944 textures, class_4915 generator) {
        List<class_3545> overrides = this.overrides.stream().map(override -> new class_3545((Object)override.model().apply(generator), override.predicate())).toList();
        return this.model.method_25852(id, textures, (a, jsonSupplier) -> generator.field_22844.accept(a, () -> this.lambda$upload$6((Supplier)jsonSupplier, overrides)));
    }

    private JsonObject writeOverride(class_2960 model, Map<String, Float> predicate, JsonObject json) {
        json.addProperty("model", model.toString());
        json.add("predicate", (JsonElement)class_156.method_654((Object)new JsonObject(), output -> predicate.forEach((arg_0, arg_1) -> ((JsonObject)output).addProperty(arg_0, arg_1))));
        return json;
    }

    private /* synthetic */ JsonElement lambda$upload$6(Supplier jsonSupplier, List overrides) {
        return (JsonElement)class_156.method_654((Object)((JsonElement)jsonSupplier.get()), json -> json.getAsJsonObject().add("overrides", (JsonElement)class_156.method_654((Object)new JsonArray(), array -> overrides.forEach(override -> array.add((JsonElement)this.writeOverride((class_2960)override.method_15442(), (Map)override.method_15441(), new JsonObject()))))));
    }

    public static interface ModelVariantSupplier {
        public class_2960 upload(int var1, float var2);
    }

    private record Override(Map<String, Float> predicate, Function<class_4915, class_2960> model) {
    }
}

