/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.diet;

import com.minelittlepony.unicopia.diet.Effect;
import com.minelittlepony.unicopia.diet.FoodAttributes;
import com.minelittlepony.unicopia.diet.FoodGroupEffects;
import com.minelittlepony.unicopia.diet.FoodGroupKey;
import com.minelittlepony.unicopia.diet.PonyDiets;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.component.TransientComponentMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public record DietProfile(float defaultMultiplier, float foragingMultiplier, List<Multiplier> multipliers, List<FoodGroupEffects> effects, Optional<FoodGroupEffects> defaultEffect) {
    public static final DietProfile EMPTY = new DietProfile(1.0f, 1.0f, List.of(), List.of(), Optional.empty());
    public static final Codec<DietProfile> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("default_multiplier").forGetter(DietProfile::defaultMultiplier), (App)Codec.FLOAT.fieldOf("foraging_multiplier").forGetter(DietProfile::foragingMultiplier), (App)Codec.list(Multiplier.CODEC).fieldOf("multipliers").forGetter(DietProfile::multipliers), (App)Codec.list(FoodGroupEffects.createCodec(FoodGroupKey.CODEC)).fieldOf("effects").forGetter(DietProfile::effects), (App)FoodGroupEffects.createCodec(FoodGroupKey.CODEC).optionalFieldOf("default_effect").forGetter(DietProfile::defaultEffect)).apply((Applicative)instance, DietProfile::new));
    public static final class_9139<class_9129, DietProfile> PACKET_CODEC = class_9139.method_56906((class_9139)class_9135.field_48552, DietProfile::defaultMultiplier, (class_9139)class_9135.field_48552, DietProfile::foragingMultiplier, (class_9139)Multiplier.PACKET_CODEC.method_56433(class_9135.method_56363()), DietProfile::multipliers, (class_9139)FoodGroupEffects.createPacketCodec(FoodGroupKey.PACKET_CODEC).method_56433(class_9135.method_56363()), DietProfile::effects, (class_9139)class_9135.method_56382(FoodGroupEffects.createPacketCodec(FoodGroupKey.PACKET_CODEC)), DietProfile::defaultEffect, DietProfile::new);

    public void validate(Consumer<String> issues, Predicate<class_2960> foodGroupExists) {
        this.multipliers.stream().flatMap(i -> i.tags().stream()).forEach(key -> {
            if (!foodGroupExists.test(key.id())) {
                issues.accept("Multiplier referenced unknown food group: " + String.valueOf(key.id()));
            }
        });
        this.effects.stream().flatMap(i -> i.tags().stream()).forEach(key -> {
            if (!foodGroupExists.test(key.id())) {
                issues.accept("Override defined for unknown food group: " + String.valueOf(key.id()));
            }
        });
        this.defaultEffect.stream().flatMap(i -> i.tags().stream()).forEach(key -> {
            if (!foodGroupExists.test(key.id())) {
                issues.accept("Default override defined for unknown food group: " + String.valueOf(key.id()));
            }
        });
    }

    public Optional<Multiplier> findMultiplier(class_1799 stack) {
        return this.multipliers.stream().filter(m -> m.test(stack)).findFirst();
    }

    public Optional<Effect> findEffect(class_1799 stack) {
        return this.effects.stream().filter(m -> m.test(stack)).findFirst().or(this::defaultEffect).map(Effect.class::cast);
    }

    static boolean isForaged(class_1799 stack) {
        return stack.method_57353().method_57829(class_9334.field_50075) == null;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean hasFoodAttributes(class_1799 stack, TransientComponentMap components, boolean original) {
        if (this.isEmpty()) {
            return original;
        }
        return !this.isInedible(stack) && (original || this.getFoodAttributeForNonEdibleFood(stack, components).isPresent());
    }

    @Nullable
    public class_4174 getAdjustedFoodComponent(class_1799 stack, TransientComponentMap components, @Nullable class_4174 food) {
        if (this.isEmpty()) {
            return food;
        }
        if (food != null && (food.comp_2491() > 0 || food.comp_2492() > 0.0f)) {
            return this.applyFoodQualityRatio(stack, food);
        }
        return this.getFoodAttributeForNonEdibleFood(stack, components).map(FoodAttributes::food).orElse(food);
    }

    @Nullable
    private class_4174 applyFoodQualityRatio(class_1799 stack, class_4174 food) {
        int baseline;
        Pair<Float, Float> ratios = this.getRatios(stack);
        if (DietProfile.isInedible(ratios)) {
            return null;
        }
        float hunger = (float)food.comp_2491() * ((Float)ratios.getFirst()).floatValue();
        return new class_4174(Math.max(1, hunger - (float)(baseline = (int)hunger) >= 0.5f ? baseline + 1 : baseline), food.comp_2492() * ((Float)ratios.getSecond()).floatValue(), food.comp_2493(), food.comp_2494(), food.comp_2794(), food.comp_2495());
    }

    public boolean isInedible(class_1799 stack) {
        return DietProfile.isInedible(this.getRatios(stack));
    }

    public static boolean isInedible(Pair<Float, Float> ratios) {
        return ((Float)ratios.getFirst()).floatValue() <= 0.01f && ((Float)ratios.getSecond()).floatValue() <= 0.01f;
    }

    private Pair<Float, Float> getRatios(class_1799 stack) {
        Optional<Multiplier> multiplier = this.findMultiplier(stack);
        float baseMultiplier = DietProfile.isForaged(stack) ? this.foragingMultiplier() : this.defaultMultiplier();
        float hungerMultiplier = multiplier.map(Multiplier::hunger).orElse(Float.valueOf(baseMultiplier)).floatValue();
        float saturationMultiplier = multiplier.map(Multiplier::saturation).orElse(Float.valueOf(baseMultiplier)).floatValue();
        return Pair.of((Object)Float.valueOf(hungerMultiplier), (Object)Float.valueOf(saturationMultiplier));
    }

    public void appendTooltip(class_1799 stack, @Nullable Pony pony, Consumer<class_2561> tooltip, class_1836 context) {
        float baseMultiplier;
        if (this.isEmpty()) {
            return;
        }
        class_4174 food = (class_4174)stack.method_57824(class_9334.field_50075);
        Pair<Float, Float> ratios = this.getRatios(stack);
        if (food == null || DietProfile.isInedible(ratios)) {
            return;
        }
        tooltip.accept((class_2561)class_2561.method_43471((String)"unicopia.diet.information").method_27692(class_124.field_1064));
        this.findEffect(stack).orElseGet(() -> PonyDiets.getInstance().getEffects(stack)).appendTooltip(stack, tooltip, context);
        float f = baseMultiplier = DietProfile.isForaged(stack) ? this.foragingMultiplier() : this.defaultMultiplier();
        if (context.method_8035()) {
            class_4174 nonAdjustedFood = this.getNonAdjustedFoodComponent(stack, pony).orElse(food);
            tooltip.accept((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"unicopia.diet.base_multiplier", (Object[])new Object[]{Float.valueOf(baseMultiplier)}).method_27692(class_124.field_1063)));
            tooltip.accept((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"unicopia.diet.hunger.detailed", (Object[])new Object[]{food.comp_2491(), nonAdjustedFood.comp_2491(), (int)(((Float)ratios.getFirst()).floatValue() * 100.0f)})).method_27692(class_124.field_1063));
            tooltip.accept((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"unicopia.diet.saturation.detailed", (Object[])new Object[]{Float.valueOf(food.comp_2492()), Float.valueOf(nonAdjustedFood.comp_2492()), (int)(((Float)ratios.getSecond()).floatValue() * 100.0f)})).method_27692(class_124.field_1063));
        } else {
            tooltip.accept((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"unicopia.diet.hunger", (Object[])new Object[]{(int)(((Float)ratios.getFirst()).floatValue() * 100.0f)})).method_27692(class_124.field_1063));
            tooltip.accept((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"unicopia.diet.saturation", (Object[])new Object[]{(int)(((Float)ratios.getSecond()).floatValue() * 100.0f)})).method_27692(class_124.field_1063));
        }
    }

    private Optional<class_4174> getNonAdjustedFoodComponent(class_1799 stack, @Nullable Pony pony) {
        class_4174 food = (class_4174)stack.method_57353().method_57829(class_9334.field_50075);
        if (food != null) {
            return Optional.ofNullable(food);
        }
        if (pony != null && pony.getObservedSpecies().hasIronGut()) {
            return this.findEffect(stack).flatMap(Effect::foodAttributes).or(() -> PonyDiets.getInstance().getEffects(stack).foodAttributes()).map(FoodAttributes::food);
        }
        return Optional.empty();
    }

    private Optional<FoodAttributes> getFoodAttributeForNonEdibleFood(class_1799 stack, TransientComponentMap components) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        if (components.getCarrier().flatMap(Pony::of).filter(pony -> pony.getObservedSpecies().hasIronGut()).isEmpty()) {
            return Optional.empty();
        }
        return this.findEffect(stack).flatMap(Effect::foodAttributes).or(() -> PonyDiets.getInstance().getEffects(stack).foodAttributes());
    }

    public record Multiplier(Set<FoodGroupKey> tags, float hunger, float saturation) implements Predicate<class_1799>
    {
        public static final Codec<Set<FoodGroupKey>> TAGS_CODEC = FoodGroupKey.CODEC.listOf().xmap(l -> l.stream().distinct().collect(Collectors.toSet()), set -> new ArrayList(set));
        public static final Codec<Multiplier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TAGS_CODEC.fieldOf("tags").forGetter(Multiplier::tags), (App)Codec.FLOAT.fieldOf("hunger").forGetter(Multiplier::hunger), (App)Codec.FLOAT.fieldOf("saturation").forGetter(Multiplier::saturation)).apply((Applicative)instance, Multiplier::new));
        public static final class_9139<class_9129, Multiplier> PACKET_CODEC = class_9139.method_56436((class_9139)FoodGroupKey.PACKET_CODEC.method_56433(class_9135.method_56374(HashSet::new)), Multiplier::tags, (class_9139)class_9135.field_48552, Multiplier::hunger, (class_9139)class_9135.field_48552, Multiplier::saturation, Multiplier::new);

        @Override
        public boolean test(class_1799 stack) {
            return this.tags.stream().anyMatch(tag -> tag.contains(stack));
        }

        public static final class Builder {
            private Set<FoodGroupKey> tags = new HashSet<FoodGroupKey>();
            private float hunger = 1.0f;
            private float saturation = 1.0f;

            public Builder tag(class_2960 tag) {
                this.tags.add(FoodGroupKey.LOOKUP.apply(tag));
                return this;
            }

            public Builder hunger(float hunger) {
                this.hunger = hunger;
                return this;
            }

            public Builder saturation(float saturation) {
                this.saturation = saturation;
                return this;
            }

            public Multiplier build() {
                return new Multiplier(this.tags, this.hunger, this.saturation);
            }
        }
    }
}

