/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.Levelled;
import com.minelittlepony.unicopia.network.track.TrackableObject;
import com.minelittlepony.unicopia.util.Untyped;
import com.minelittlepony.unicopia.util.serialization.CodecUtils;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class EntityReference<T extends class_1297>
implements NbtSerialisable,
TrackableObject<EntityReference<T>> {
    public static final Codec<EntityReference<?>> CODEC = EntityValues.CODEC.xmap(r -> new EntityReference(r), r -> r.reference);
    public static final Codec<List<EntityReference<?>>> LIST_CODEC = CODEC.listOf();
    @Nullable
    private EntityValues<T> reference;
    private WeakReference<T> directReference = new WeakReference<Object>(null);
    private boolean dirty = true;

    public static <T extends class_1297> Codec<List<EntityReference<T>>> codec() {
        return (Codec)Untyped.cast(CODEC);
    }

    public static <T extends class_1297> Codec<List<EntityReference<T>>> listCodec() {
        return (Codec)Untyped.cast(LIST_CODEC);
    }

    public EntityReference() {
    }

    public EntityReference(T entity) {
        this.set(entity);
    }

    public EntityReference(class_2487 nbt, class_7225.class_7874 lookup) {
        this.fromNBT(nbt, lookup);
    }

    private EntityReference(EntityValues<T> reference) {
        this.reference = reference;
    }

    public void copyFrom(EntityReference<? extends T> other) {
        this.reference = other.reference;
        this.directReference = new WeakReference<class_1297>((class_1297)other.directReference.get());
        this.dirty = true;
    }

    public boolean set(@Nullable T entity) {
        this.directReference = new WeakReference<T>(entity);
        this.reference = entity == null ? null : new EntityValues((class_1297)entity);
        this.dirty = true;
        return entity != null;
    }

    public Optional<EntityValues<T>> getTarget() {
        class_1297 value = (class_1297)this.directReference.get();
        if (value != null) {
            this.reference = new EntityValues(value);
        }
        return Optional.ofNullable(this.reference);
    }

    public boolean isSet() {
        return this.reference != null;
    }

    public boolean referenceEquals(class_1297 entity) {
        return entity != null && this.referenceEquals(entity.method_5667());
    }

    public boolean referenceEquals(UUID uuid) {
        return (this.reference == null ? class_156.field_25140 : this.reference.uuid()).equals(uuid);
    }

    public boolean referenceEquals(@Nullable EntityReference<?> other) {
        EntityValues<T> st = this.reference;
        EntityValues<T> ot = other == null ? null : other.reference;
        return st == ot || st != null && ot != null && Objects.equals(st.uuid(), ot.uuid());
    }

    public void ifPresent(class_1937 world, Consumer<T> consumer) {
        this.getOrEmpty(world).ifPresent(consumer);
    }

    @Nullable
    public T get(class_1937 world) {
        class_1297 t = (class_1297)this.directReference.get();
        if (t == null && this.reference != null) {
            t = this.reference.resolve(world).orElse(null);
            this.directReference = new WeakReference<class_1297>(t);
        }
        return (T)t;
    }

    public Optional<T> getOrEmpty(class_1937 world) {
        return Optional.ofNullable(this.get(world));
    }

    @Override
    public void toNBT(class_2487 tag, class_7225.class_7874 lookup) {
        this.getTarget().ifPresent(ref -> EntityValues.CODEC.encodeStart((DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), ref).result().ifPresent(nbt -> tag.method_10543((class_2487)nbt)));
    }

    @Override
    public void fromNBT(class_2487 tag, class_7225.class_7874 lookup) {
        class_1297 value;
        this.reference = NbtSerialisable.decode(EntityValues.CODEC, (class_2520)tag, lookup).orElse(null);
        this.dirty = true;
        if (this.reference != null && (value = (class_1297)this.directReference.get()) != null) {
            this.reference = new EntityValues(value);
        }
    }

    public int hashCode() {
        return this.getTarget().map(EntityValues::uuid).orElse(class_156.field_25140).hashCode();
    }

    @Override
    public TrackableObject.Status getStatus() {
        if (this.dirty) {
            this.dirty = false;
            return TrackableObject.Status.UPDATED;
        }
        return TrackableObject.Status.DEFAULT;
    }

    @Override
    public class_2487 writeTrackedNbt(class_7225.class_7874 lookup) {
        return this.getTarget().flatMap(ref -> EntityValues.CODEC.encodeStart((DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), ref).result()).map(class_2487.class::cast).orElseGet(class_2487::new);
    }

    @Override
    public void readTrackedNbt(class_2487 compound, class_7225.class_7874 lookup) {
        this.fromNBT(compound, lookup);
    }

    @Override
    public void copyTo(EntityReference<T> destination) {
        destination.reference = this.reference;
        destination.directReference = this.directReference;
    }

    @Override
    public void discard(boolean immediate) {
        this.set(null);
    }

    public record EntityValues<T extends class_1297>(UUID uuid, class_243 pos, int clientId, boolean isPlayer, boolean isDead, Levelled.LevelStore level, Levelled.LevelStore corruption) {
        public static final Codec<EntityValues<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_40825.fieldOf("uuid").forGetter(EntityValues::uuid), (App)CodecUtils.VECTOR.fieldOf("pos").forGetter(EntityValues::pos), (App)Codec.INT.fieldOf("clientId").forGetter(EntityValues::clientId), (App)Codec.BOOL.fieldOf("isPlayer").forGetter(EntityValues::isPlayer), (App)Codec.BOOL.fieldOf("isDead").forGetter(EntityValues::isDead), (App)Levelled.CODEC.fieldOf("level").forGetter(EntityValues::level), (App)Levelled.CODEC.fieldOf("corruption").forGetter(EntityValues::corruption)).apply((Applicative)instance, EntityValues::new));

        public EntityValues(class_1297 entity) {
            this(entity.method_5667(), entity.method_19538(), entity.method_5628(), entity instanceof class_1657, !entity.method_5805(), Caster.of(entity).map(Levelled::getLevel).map(Levelled::copyOf).orElse(Levelled.ZERO), Caster.of(entity).map(Levelled::getCorruption).map(Levelled::copyOf).orElse(Levelled.ZERO));
        }

        public Optional<T> resolve(class_1937 world) {
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                return Optional.ofNullable(serverWorld.method_14190(this.uuid));
            }
            class_1297 target = world.method_8469(this.clientId());
            if (target == null || !target.method_5667().equals(this.uuid)) {
                return Optional.empty();
            }
            return Optional.of(target);
        }
    }
}

