/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.behaviour;

import com.minelittlepony.unicopia.FlightType;
import com.minelittlepony.unicopia.Owned;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.behaviour.EntityAppearance;
import com.minelittlepony.unicopia.entity.behaviour.EntityBehaviour;
import com.minelittlepony.unicopia.entity.duck.LivingEntityDuck;
import com.minelittlepony.unicopia.entity.duck.RotatedView;
import com.minelittlepony.unicopia.entity.player.PlayerDimensions;
import com.minelittlepony.unicopia.entity.player.Pony;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2940;
import net.minecraft.class_4048;
import org.jetbrains.annotations.Nullable;

public interface Disguise
extends FlightType.Provider,
PlayerDimensions.Provider {
    public EntityAppearance getDisguise();

    public boolean isDead();

    default public Optional<EntityAppearance> getAppearance() {
        return Optional.ofNullable(this.getDisguise());
    }

    @Override
    default public FlightType getFlightType() {
        return this.getAppearance().map(EntityAppearance::getFlightType).orElse(FlightType.UNSET);
    }

    @Override
    default public Optional<class_4048> getTargetDimensions(Pony player) {
        return this.getAppearance().flatMap(d -> d.getTargetDimensions(player));
    }

    default public boolean isOf(@Nullable class_1297 entity) {
        return this.getDisguise().isOf(entity);
    }

    default public Disguise setDisguise(@Nullable class_1297 entity) {
        if (entity == this.getDisguise().getAppearance()) {
            entity = null;
        }
        this.getDisguise().setAppearance(entity);
        return this;
    }

    default public boolean update(Caster<?> caster, boolean tick) {
        if (!(caster instanceof Living)) {
            return false;
        }
        Living source = (Living)caster;
        Object owner = source.asEntity();
        if (owner == null) {
            return true;
        }
        class_1297 entity = this.getDisguise().getOrCreate(source);
        if (entity == null) {
            owner.method_5648(false);
            if (source instanceof Pony) {
                ((Pony)source).setInvisible(false);
            }
            owner.method_18382();
            return false;
        }
        entity.field_5960 = true;
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            mob.method_5977(true);
        }
        entity.method_5648(false);
        entity.method_5875(true);
        EntityBehaviour<class_1297> behaviour = EntityBehaviour.forEntity(entity);
        behaviour.copyBaseAttributes((class_1309)owner, entity);
        if (tick && !this.getDisguise().skipsUpdate()) {
            ((RotatedView)entity.method_37908()).setMirrorEntityStatuses(entity.method_37908().field_9236);
            if (entity.method_37908().field_9236) {
                entity.method_5773();
            } else {
                entity.method_5773();
            }
            ((RotatedView)entity.method_37908()).setMirrorEntityStatuses(false);
        }
        if (!(owner instanceof class_1657) && !((LivingEntityDuck)owner).isJumping()) {
            owner.method_5762(0.0, -0.09, 0.0);
        }
        behaviour.update(source, entity, this);
        if (source instanceof Pony) {
            Pony player = (Pony)source;
            source.asEntity().method_5648(true);
            player.setInvisible(true);
            if (entity instanceof Owned.Mutable) {
                ((Owned.Mutable)entity).setMaster(player);
            }
            if (entity instanceof class_1657) {
                entity.method_5841().method_12778(PlayerAccess.getModelBitFlag(), (Object)((Byte)owner.method_5841().method_12789(PlayerAccess.getModelBitFlag())));
            }
        }
        return !this.isDead() && !source.asEntity().method_29504();
    }

    public static abstract class PlayerAccess
    extends class_1657 {
        public PlayerAccess() {
            super(null, null, 0.0f, null);
        }

        public static class_2940<Byte> getModelBitFlag() {
            return field_7518;
        }
    }
}

