/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.behaviour;

import com.minelittlepony.unicopia.FlightType;
import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.Owned;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.compat.pehkui.PehkUtil;
import com.minelittlepony.unicopia.entity.behaviour.Disguise;
import com.minelittlepony.unicopia.entity.behaviour.EntityBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.Guest;
import com.minelittlepony.unicopia.entity.collision.EntityCollisions;
import com.minelittlepony.unicopia.entity.mob.ButterflyEntity;
import com.minelittlepony.unicopia.entity.mob.SombraEntity;
import com.minelittlepony.unicopia.entity.mob.UEntityAttributes;
import com.minelittlepony.unicopia.entity.player.PlayerDimensions;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.network.track.TrackableObject;
import com.minelittlepony.unicopia.projectile.ProjectileUtil;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1307;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1421;
import net.minecraft.class_1432;
import net.minecraft.class_1510;
import net.minecraft.class_1530;
import net.minecraft.class_1540;
import net.minecraft.class_1606;
import net.minecraft.class_1628;
import net.minecraft.class_1634;
import net.minecraft.class_1657;
import net.minecraft.class_1678;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2631;
import net.minecraft.class_265;
import net.minecraft.class_3726;
import net.minecraft.class_4048;
import net.minecraft.class_7225;
import net.minecraft.class_7298;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAppearance
implements NbtSerialisable,
PlayerDimensions.Provider,
FlightType.Provider,
EntityCollisions.ComplexCollidable,
TrackableObject<EntityAppearance> {
    @NotNull
    private transient String entityId = "";
    @Nullable
    private transient class_1297 entity;
    @Nullable
    private transient class_2586 blockEntity;
    private transient List<Attachment> attachments = new ArrayList<Attachment>();
    private Optional<class_4048> dimensions = Optional.empty();
    @Nullable
    private transient class_2487 tag;
    @Nullable
    private class_2487 entityNbt;
    private boolean dirty;

    @Nullable
    public class_1297 getAppearance() {
        return this.entity;
    }

    @Nullable
    public class_2586 getBlockEntity() {
        return this.blockEntity;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setBlockEntity(@Nullable class_2586 blockEntity) {
        if (this.blockEntity != null) {
            this.blockEntity.method_11012();
        }
        this.blockEntity = blockEntity;
    }

    public void attachExtraEntity(class_243 offset, class_1297 entity) {
        this.attachments.add(new Attachment(offset, entity));
    }

    public void setAppearance(@Nullable class_1297 entity) {
        this.remove();
        this.entityNbt = entity == null ? null : EntityAppearance.encodeEntityToNBT(entity);
        this.entityId = this.entityNbt == null ? "" : this.entityNbt.method_10558("id");
        this.markDirty();
    }

    public boolean isPresent() {
        return this.entity != null;
    }

    public boolean isOf(@Nullable class_1297 entity) {
        return this.isPresent() && entity != null && EntityBehaviour.forEntity(this.entity).isEqual(this.entity, entity);
    }

    public class_2487 getOrCreateTag() {
        if (this.tag == null) {
            this.tag = new class_2487();
        }
        return this.tag;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public void remove() {
        this.attachments.clear();
        if (this.entity != null) {
            EntityBehaviour.forEntity(this.entity).onDestroy(this.entity);
            this.entity = null;
        }
        if (this.blockEntity != null) {
            try {
                this.blockEntity.method_11012();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.blockEntity = null;
        }
    }

    private synchronized void createPlayer(class_2487 nbt, GameProfile profile, Caster<?> source) {
        this.remove();
        this.entity = InteractionManager.getInstance().createPlayer((class_1297)source.asEntity(), profile);
        this.entity.method_5665(source.asEntity().method_5477());
        ((class_1657)this.entity).method_5651(nbt.method_10562("playerNbt"));
        if (nbt.method_10573("playerVisibleParts", 1)) {
            this.entity.method_5841().method_12778(Disguise.PlayerAccess.getModelBitFlag(), (Object)nbt.method_10571("playerVisibleParts"));
        }
        this.entity.method_5826(UUID.randomUUID());
        this.entity.method_5646();
        this.onEntityLoaded(source);
    }

    public class_1297 getOrCreate(Caster<?> source) {
        if (this.entity == null && this.entityNbt != null) {
            class_2487 nbt = this.entityNbt;
            this.entity = null;
            this.entityNbt = null;
            this.attachments.clear();
            if ("player".equals(this.entityId)) {
                this.createPlayer(nbt, new GameProfile(nbt.method_25928("playerId") ? nbt.method_25926("playerId") : UUID.randomUUID(), nbt.method_10558("playerName")), source);
                class_2631.method_52580((String)nbt.method_10558("playerName")).thenAccept(profile -> profile.ifPresent(p -> this.createPlayer(nbt, (GameProfile)p, source)));
            } else {
                if (source.isClient()) {
                    this.entity = class_1299.method_17684((class_2487)nbt).map(type -> type.method_5883(source.asWorld())).orElse(null);
                    if (this.entity != null) {
                        try {
                            this.entity.method_5651(nbt);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.entity = EntityBehaviour.forEntity(this.entity).onCreate(this.entity, this, true);
                    }
                } else {
                    this.entity = class_1299.method_17842((class_2487)nbt, (class_1937)source.asWorld(), e -> EntityBehaviour.forEntity(e).onCreate((class_1297)e, this, true));
                }
                this.onEntityLoaded(source);
            }
        }
        return this.entity;
    }

    public void onImpact(Caster<?> pony, float distance, float damageMultiplier, class_1282 cause) {
        EntityBehaviour.forEntity(this.entity).onImpact(pony, this.entity, distance, damageMultiplier, cause);
    }

    private void onEntityLoaded(Caster<?> source) {
        source.asEntity().method_18382();
        if (this.entity == null) {
            return;
        }
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            class_1309 l = (class_1309)class_12972;
            l.method_5996(UEntityAttributes.ENTITY_GRAVITY_MODIFIER).method_6203();
        }
        if ((class_12972 = this.entity) instanceof Guest) {
            Guest guest = (Guest)class_12972;
            guest.setHost(source);
        }
        if (source.isClient()) {
            source.asWorld().method_8649(this.entity);
        } else {
            this.entity.method_5838(source.asEntity().method_5628());
        }
    }

    @Override
    public FlightType getFlightType() {
        if (!this.isPresent()) {
            return FlightType.UNSET;
        }
        if (this.entity == null) {
            return FlightType.NONE;
        }
        if (this.entity instanceof Owned) {
            Pony iplayer = Pony.of((class_1657)((Owned)this.entity).getMaster());
            return iplayer == null ? FlightType.NONE : iplayer.getSpecies().flightType();
        }
        if (this.entity instanceof class_1307 || this.entity instanceof class_1421 || this.entity instanceof class_1510 || this.entity instanceof class_1634 || this.entity instanceof class_7298 || this.entity instanceof class_1420 || this.entity instanceof ButterflyEntity || this.entity instanceof class_1678 || this.entity instanceof class_1432 || this.entity instanceof SombraEntity || ProjectileUtil.isFlyingProjectile(this.entity)) {
            return FlightType.INSECTOID;
        }
        return FlightType.NONE;
    }

    public float getHeight() {
        if (this.entity != null) {
            if (this.entity instanceof class_1540) {
                return 0.9f;
            }
            return PehkUtil.ignoreScaleFor(this.entity, class_1297::method_17682).floatValue() - 0.1f;
        }
        return -1.0f;
    }

    public Optional<Float> getDistance(Pony player) {
        return PehkUtil.ignoreScaleFor(this.entity, e -> EntityBehaviour.forEntity(e).getCameraDistance((class_1297)e, player));
    }

    @Override
    public Optional<class_4048> getTargetDimensions(Pony player) {
        this.dimensions = PehkUtil.ignoreScaleFor(this.entity, e -> EntityBehaviour.forEntity(e).getDimensions((class_1297)e, this.dimensions));
        return this.dimensions;
    }

    public boolean skipsUpdate() {
        return this.entity instanceof class_1540 || this.entity instanceof class_1530 || this.entity instanceof class_1657 || this.entity instanceof class_1530;
    }

    public boolean isAxisAligned() {
        return EntityAppearance.isAxisAligned(this.entity);
    }

    public boolean canClimbWalls() {
        return this.entity instanceof class_1628;
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10582("entityId", this.entityId);
        if (this.entityNbt != null) {
            compound.method_10566("entity", (class_2520)this.entityNbt);
        } else if (this.entity != null) {
            compound.method_10566("entity", (class_2520)EntityAppearance.encodeEntityToNBT(this.entity));
        }
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        String oldPlayerName;
        String newId = compound.method_10558("entityId");
        String newPlayerName = null;
        if (compound.method_10573("entity", 10) && compound.method_10562("entity").method_10573("playerName", 8)) {
            newPlayerName = compound.method_10562("entity").method_10558("playerName");
        }
        String string = oldPlayerName = this.entity != null && this.entity instanceof class_1657 ? ((class_1657)this.entity).method_7334().getName() : null;
        if (!Objects.equals(newId, this.entityId) || !Objects.equals(newPlayerName, oldPlayerName)) {
            this.entityNbt = null;
            this.remove();
        }
        if (compound.method_10573("entity", 10)) {
            this.entityId = newId;
            this.entityNbt = compound.method_10562("entity");
            if (this.entity != null) {
                try {
                    this.entity.method_5651(this.entityNbt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.attachments.clear();
                this.entity = EntityBehaviour.forEntity(this.entity).onCreate(this.entity, this, false);
            }
        }
    }

    public static boolean isAxisAligned(@Nullable class_1297 entity) {
        return entity instanceof class_1606 || entity instanceof class_1530 || entity instanceof class_1540;
    }

    private static class_2487 encodeEntityToNBT(class_1297 entity) {
        class_2487 entityNbt = new class_2487();
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            GameProfile profile = player.method_7334();
            entityNbt.method_10582("id", "player");
            if (profile.getId() != null) {
                entityNbt.method_25927("playerId", profile.getId());
            }
            entityNbt.method_10582("playerName", profile.getName());
            entityNbt.method_10567("playerVisibleParts", ((Byte)player.method_5841().method_12789(Disguise.PlayerAccess.getModelBitFlag())).byteValue());
            return NbtSerialisable.subTag("playerNbt", entityNbt, playerNbt -> {
                player.method_5647(playerNbt);
                playerNbt.method_10551("unicopia_caster");
                Pony pony = Pony.of(player);
                if (pony != null) {
                    NbtSerialisable.subTag("unicopia_caster", playerNbt, comp -> pony.toSyncronisedNbt((class_2487)comp, (class_7225.class_7874)((class_1657)pony.asEntity()).method_56673()));
                }
            });
        }
        entity.method_5786(entityNbt);
        entityNbt.method_10551("unicopia_caster");
        return entityNbt;
    }

    @Override
    public void getCollissionShapes(class_3726 context, Consumer<class_265> output) {
        EntityCollisions.getCollissionShapes(this.getAppearance(), context, output);
        this.getAttachments().forEach(e -> EntityCollisions.getCollissionShapes(e.entity(), context, output));
    }

    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public TrackableObject.Status getStatus() {
        if (this.dirty) {
            this.dirty = false;
            return TrackableObject.Status.UPDATED;
        }
        return TrackableObject.Status.DEFAULT;
    }

    @Override
    public void readTrackedNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        this.fromNBT(nbt, lookup);
    }

    @Override
    public class_2487 writeTrackedNbt(class_7225.class_7874 lookup) {
        return this.toNBT(lookup);
    }

    @Override
    public void discard(boolean immediate) {
        this.setAppearance(null);
        this.dirty = false;
    }

    @Override
    public void copyTo(EntityAppearance destination) {
        destination.entityId = this.entityId;
        destination.entity = this.entity;
        destination.blockEntity = this.blockEntity;
        destination.attachments.addAll(this.attachments);
        destination.dimensions = this.dimensions;
        destination.tag = this.tag == null ? null : this.tag.method_10553();
        destination.entityNbt = this.entityNbt == null ? null : this.entityNbt.method_10553();
    }

    public record Attachment(class_243 offset, class_1297 entity) {
    }
}

