/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.effect;

import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.entity.Equine;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.player.MagicReserves;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.util.ExplosionUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4081;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class RaceChangeStatusEffect
extends class_1291 {
    public static final int STAGE_DURATION = 200;
    public static final int MAX_DURATION = Stage.VALUES.length * 200 + 1;
    private static final Map<Race, class_6880<class_1291>> REGISTRY = new HashMap<Race, class_6880<class_1291>>();
    public static final class_6880<class_1291> EARTH = RaceChangeStatusEffect.register(8941327, Race.EARTH);
    public static final class_6880<class_1291> UNICORN = RaceChangeStatusEffect.register(0x88FFFF, Race.UNICORN);
    public static final class_6880<class_1291> PEGASUS = RaceChangeStatusEffect.register(49407, Race.PEGASUS);
    public static final class_6880<class_1291> BAT = RaceChangeStatusEffect.register(1388307, Race.BAT);
    public static final class_6880<class_1291> CHANGELING = RaceChangeStatusEffect.register(0xFFFF00, Race.CHANGELING);
    public static final class_6880<class_1291> KIRIN = RaceChangeStatusEffect.register(0xFF8800, Race.KIRIN);
    public static final class_6880<class_1291> HIPPOGRIFF = RaceChangeStatusEffect.register(14700407, Race.HIPPOGRIFF);
    private final Race race;

    @Nullable
    public static class_6880<class_1291> forRace(Race race) {
        return REGISTRY.get(race);
    }

    public static class_6880<class_1291> register(int color, Race race) {
        class_2960 id = race.getId();
        class_6880.class_6883 reference = class_2378.method_47985((class_2378)class_7923.field_41174, (class_2960)id.method_45134(p -> "change_race_" + id.method_12832()), (Object)((Object)new RaceChangeStatusEffect(color, race)));
        REGISTRY.put(race, (class_6880<class_1291>)reference);
        return reference;
    }

    private RaceChangeStatusEffect(int color, Race race) {
        super(class_4081.field_18273, color);
        this.race = race;
    }

    public Race getSpecies() {
        return this.race;
    }

    private void resetTicks(class_1309 entity) {
        Pony.of((class_1297)entity).ifPresent(pony -> pony.setTicksmetamorphising(0));
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean method_5572(class_1309 entity, int amplifier) {
        MagicReserves magic;
        Pony pony;
        class_1657 player;
        int ticks;
        Stage stage;
        class_1293 state = entity.method_6112(RaceChangeStatusEffect.forRace(this.race));
        if (state == null || entity.method_29504()) {
            this.resetTicks(entity);
            return false;
        }
        Equine eq = Equine.of(entity).orElse(null);
        if (eq == null) {
            return false;
        }
        int metaTicks = 0;
        if (eq instanceof Pony) {
            Pony pony2 = (Pony)eq;
            metaTicks = pony2.getTicksMetamorphising() + 1;
            pony2.setTicksmetamorphising(metaTicks);
        }
        if ((stage = Stage.forDuration((ticks = Math.max(0, MAX_DURATION - state.method_5584())) / 200)) == Stage.INITIAL) {
            return true;
        }
        int progression = ticks % (stage.ordinal() * 200);
        if (eq.getSpecies() == this.race || !this.race.isPermitted(entity instanceof class_1657 ? (player = (class_1657)entity) : null)) {
            if (progression != 0) return false;
            if (!(entity instanceof class_1657)) return false;
            class_1657 player2 = (class_1657)entity;
            if (stage != Stage.CRAWLING) return false;
            player2.method_7353(Stage.INITIAL.getMessage(this.race), true);
            return false;
        }
        if (progression == 0 && stage != Stage.DEATH && entity instanceof class_1657) {
            player = (class_1657)entity;
            player.method_7353(stage.getMessage(this.race), true);
        }
        if (eq instanceof Pony) {
            pony = (Pony)eq;
            magic = pony.getMagicalReserves();
            pony.setRespawnRace(this.race);
            magic.getExertion().add(5.0f);
            if (magic.getEnergy().get() < 1.0f) {
                magic.getEnergy().add(1.1f);
                entity.method_5783(USounds.BLOCK_CHITIN_AMBIENCE, 0.1f, 2.0f);
            }
            magic.getExhaustion().add(3.0f);
            if (state.method_5581()) {
                pony.spawnParticles((class_2394)class_2398.field_11220, 1);
            }
        }
        if (stage != Stage.DEATH) return true;
        if (eq instanceof Caster) {
            ((Caster)((Object)eq)).getSpellSlot().clear();
        }
        if (eq instanceof Pony) {
            pony = (Pony)eq;
            if (metaTicks > 200) {
                magic = pony.getMagicalReserves();
                magic.getEnergy().set(0.6f);
                magic.getExhaustion().set(0.0f);
                magic.getExertion().set(0.0f);
                if (((class_1657)pony.asEntity()).method_7337() || entity.method_37908().method_8407().method_5461() < 2 || entity.method_37908().method_8401().method_152()) {
                    if (!((class_1657)pony.asEntity()).method_7337()) {
                        float f;
                        if (entity.method_37908().method_8401().method_152()) {
                            f = 0.75f;
                        } else {
                            switch (entity.method_37908().method_8407()) {
                                case field_5801: {
                                    f = 0.125f;
                                    break;
                                }
                                case field_5805: {
                                    f = 0.25f;
                                    break;
                                }
                                default: {
                                    f = 0.5f;
                                }
                            }
                        }
                        float cost = f;
                        entity.method_6033(Math.max(1.0f, entity.method_6032() * cost));
                        class_1702 hunger = ((class_1657)pony.asEntity()).method_7344();
                        int food = hunger.method_7586();
                        ((class_1657)pony.asEntity()).method_7344().method_7580(Math.max(Math.min(1, food), (int)((float)food * cost)));
                    }
                    pony.setSpecies(this.race);
                } else if (!((class_1657)pony.asEntity()).method_7337() && !entity.method_5643((class_1282)Living.living(entity).damageOf(UDamageTypes.TRIBE_SWAP), Float.MAX_VALUE)) {
                    entity.method_6033(0.0f);
                    pony.setRespawnRace(Race.UNSET);
                    pony.setSpecies(this.race);
                }
                entity.method_37908().method_46407((class_1297)entity, null, ExplosionUtil.NON_DESTRUCTIVE, entity.method_19538(), 5.0f, true, class_1937.class_7867.field_40890);
                return false;
            }
        }
        eq.setSpecies(this.race);
        entity.method_37908().method_46407((class_1297)entity, null, ExplosionUtil.NON_DESTRUCTIVE, entity.method_19538(), 5.0f, true, class_1937.class_7867.field_40890);
        return false;
    }

    public void method_5564(@Nullable class_1297 source, @Nullable class_1297 attacker, class_1309 target, int amplifier, double proximity) {
        this.method_5572(target, amplifier);
    }

    public boolean method_5552(int duration, int amplifier) {
        return duration > 0;
    }

    static enum Stage {
        INITIAL,
        CRAWLING,
        DETERMINATION,
        RESURECTION,
        DEATH;

        static Stage[] VALUES;

        public static Stage forDuration(int duration) {
            return VALUES[duration % VALUES.length];
        }

        public String getTranslationKey() {
            return String.format("unicopia.effect.tribe.stage.%s", this.name().toLowerCase());
        }

        public class_2561 getMessage(Race race) {
            return class_2561.method_43469((String)this.getTranslationKey(), (Object[])new Object[]{race.getDisplayName()});
        }

        static {
            VALUES = Stage.values();
        }
    }
}

