/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.mob;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.advancement.UCriteria;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.collision.MultiBox;
import com.minelittlepony.unicopia.entity.mob.FlyingVehicleEntity;
import com.minelittlepony.unicopia.item.BasketItem;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.item.component.BalloonDesignComponent;
import com.minelittlepony.unicopia.item.component.UDataComponentTypes;
import com.minelittlepony.unicopia.server.world.WeatherConditions;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import com.minelittlepony.unicopia.util.serialization.PacketCodecUtils;
import com.terraformersmc.terraform.boat.api.TerraformBoatType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3866;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class AirBalloonEntity
extends FlyingVehicleEntity {
    private static final class_2940<Boolean> ASCENDING = class_2945.method_12791(AirBalloonEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> BOOSTING = class_2945.method_12791(AirBalloonEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> INFLATION = class_2945.method_12791(AirBalloonEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<String> BASKET_TYPE = class_2945.method_12791(AirBalloonEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Integer> BALLOON_DESIGN = class_2945.method_12791(AirBalloonEntity.class, (class_2941)class_2943.field_13327);
    private static final int BASKET_GRID_SIZE = 2;
    private static final int TOP_GRID_SIZE = 4;
    public static final byte STATUS_BURNER_INTERACT = 105;
    private static final Predicate<class_1297> RIDER_PREDICATE = class_1301.field_6155.and(e -> {
        if (!(e instanceof class_1657)) return true;
        class_1657 p = (class_1657)e;
        if (!p.method_31549().field_7479) return true;
        return false;
    });
    private boolean prevBoosting;
    private int prevInflation;
    private class_243 manualVelocity = class_243.field_1353;
    private int maxFuel = 10000;
    private int activeFuel;
    private List<class_1799> fuelItems = new ArrayList<class_1799>();
    private final Animatable[] sandbags = (Animatable[])IntStream.range(0, 5).mapToObj(x$0 -> new Animatable(x$0)).toArray(Animatable[]::new);
    private final Animatable burner = new Animatable(5);
    private double prevXDelta;
    private double xDelta;
    private double prevZDelta;
    private double zDelta;

    public AirBalloonEntity(class_1299<? extends AirBalloonEntity> type, class_1937 world) {
        super(type, world);
        this.field_23807 = true;
        this.method_5971();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ASCENDING, (Object)false);
        builder.method_56912(BOOSTING, (Object)0);
        builder.method_56912(INFLATION, (Object)0);
        builder.method_56912(BASKET_TYPE, (Object)BasketType.DEFAULT.id().toString());
        builder.method_56912(BALLOON_DESIGN, (Object)0);
    }

    @Override
    protected int getSeatCount() {
        return 20;
    }

    @Override
    protected class_243 getSeatPosition(int seatIndex) {
        double y = 0.2;
        double alignment = -0.5;
        int gridSize = 2;
        if (seatIndex >= 4) {
            seatIndex -= 4;
            y = 11.125;
            alignment = -1.75;
            gridSize = 4;
        }
        return new class_243(alignment + (double)(seatIndex % gridSize), y, alignment + (double)(seatIndex / gridSize));
    }

    public BasketType getBasketType() {
        return BasketType.of((String)this.field_6011.method_12789(BASKET_TYPE));
    }

    public void setBasketType(BasketType type) {
        this.field_6011.method_12778(BASKET_TYPE, (Object)type.id().toString());
    }

    public BalloonDesign getDesign() {
        return BalloonDesign.getType((Integer)this.field_6011.method_12789(BALLOON_DESIGN));
    }

    public void setDesign(BalloonDesign design) {
        this.field_6011.method_12778(BALLOON_DESIGN, (Object)design.ordinal());
    }

    public Animatable getSandbag(int index) {
        return this.sandbags[class_3532.method_15340((int)index, (int)0, (int)(this.sandbags.length - 1))];
    }

    public Animatable getBurner() {
        return this.burner;
    }

    public boolean hasBalloon() {
        return this.getDesign() != BalloonDesign.NONE;
    }

    public boolean hasBurner() {
        return this.method_5877() != null && !this.method_5998(class_1268.field_5808).method_7960();
    }

    public float getInflation(float tickDelta) {
        return (float)class_3532.method_48781((float)tickDelta, (int)this.prevInflation, (int)this.getInflation()) / (float)this.getMaxInflation();
    }

    private void setInflation(int inflation) {
        this.field_6011.method_12778(INFLATION, (Object)class_3532.method_15340((int)inflation, (int)0, (int)this.getMaxInflation()));
    }

    private int getInflation() {
        return (Integer)this.field_6011.method_12789(INFLATION);
    }

    protected int getMaxInflation() {
        return 100;
    }

    public boolean isAscending() {
        return this.hasBalloon() && (Boolean)this.field_6011.method_12789(ASCENDING) != false;
    }

    public void setAscending(boolean ascending) {
        this.field_6011.method_12778(ASCENDING, (Object)ascending);
    }

    public int getBoostTicks() {
        return (Integer)this.field_6011.method_12789(BOOSTING);
    }

    protected void setBoostTicks(int ticks) {
        this.field_6011.method_12778(BOOSTING, (Object)ticks);
    }

    private boolean isAirworthy() {
        return this.hasBalloon() && this.hasBurner() && this.getInflation() >= this.getMaxInflation();
    }

    public float getXVelocity(float tickDelta) {
        return (float)class_3532.method_16436((double)tickDelta, (double)this.prevXDelta, (double)this.xDelta);
    }

    public float getZVelocity(float tickDelta) {
        return (float)class_3532.method_16436((double)tickDelta, (double)this.prevZDelta, (double)this.zDelta);
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_40057;
    }

    public void method_5773() {
        class_243 pos;
        class_243 leashPost;
        boolean boosting;
        int inflation;
        this.method_5855(this.method_5748());
        int boostTicks = this.getBoostTicks();
        this.prevInflation = inflation = this.getInflation();
        if (boostTicks > 0) {
            --boostTicks;
            if (inflation < this.getMaxInflation()) {
                --boostTicks;
            }
            this.setBoostTicks(boostTicks);
        }
        boolean bl = boosting = boostTicks > 0;
        if (this.hasBurner() && this.isAscending()) {
            if (inflation < this.getMaxInflation()) {
                ++inflation;
                if (boosting) {
                    ++inflation;
                }
                this.setInflation(inflation);
            }
            if (this.activeFuel <= 0 && !this.fuelItems.isEmpty()) {
                this.activeFuel = class_3866.method_11196().getOrDefault(this.fuelItems.remove(0).method_7909(), 0);
            }
            if (this.activeFuel > -6 && this.field_6012 % 2 == 0) {
                this.activeFuel -= boosting ? 50 : 1;
                if (this.activeFuel <= -6) {
                    this.setBoostTicks(0);
                    this.setAscending(false);
                }
            }
        } else if (inflation < this.getMaxInflation() && inflation > 0) {
            this.setInflation(--inflation);
        }
        if (this.isAirworthy()) {
            this.method_5762(0.0, this.isAscending() && inflation >= this.getMaxInflation() ? 0.005 : -0.013, 0.0);
            this.method_60491(this.manualVelocity.method_1021(this.method_18798().field_1351 > (double)0.01f ? 0.1 : 0.01));
        }
        this.manualVelocity = this.manualVelocity.method_1021(0.9);
        if (!(this.hasBalloon() && this.isAscending() || !this.method_5869())) {
            this.method_18799(this.method_18798().method_18805(0.9, 0.4, 0.9).method_1031(0.0, 0.02, 0.0));
        }
        class_5819 rng = this.method_37908().field_9229;
        if (this.method_37908().method_8608()) {
            if (this.hasBurner() && this.isAscending()) {
                class_243 burnerPos = this.method_19538().method_1031(0.0, 3.0, 0.0);
                for (int i = 0; i < (boosting ? 6 : 1); ++i) {
                    this.method_37908().method_8406((class_2394)(this.activeFuel <= 0 ? class_2398.field_11251 : (this.method_5998(class_1268.field_5808).method_31574(class_1802.field_22016) ? class_2398.field_22246 : class_2398.field_11240)), rng.method_43385(burnerPos.field_1352, 0.25), rng.method_43385(burnerPos.field_1351, 1.0), rng.method_43385(burnerPos.field_1350, 0.25), 0.0, boosting ? 0.1 : 0.0, 0.0);
                }
            }
        } else if (inflation >= this.getMaxInflation()) {
            if (this.hasBurner() && this.isAscending()) {
                this.method_60491(WeatherConditions.getAirflow(this.method_24515(), this.method_37908()).method_1021(0.2));
                this.method_18799(this.method_18798().method_18805(0.3, 1.0, 0.3));
            }
            if (boosting) {
                this.method_5762(0.0, 0.02, 0.0);
            }
        }
        if (boosting && !this.prevBoosting) {
            this.method_5783(USounds.ENTITY_HOT_AIR_BALLOON_BOOST, 1.0f, 1.0f);
        }
        if (this.isAscending() && this.field_6012 % 15 + rng.method_43048(5) == 0) {
            this.method_5783(USounds.ENTITY_HOT_AIR_BALLOON_BURNER_FIRE, 0.2f, 1.0f);
            this.method_37908().method_33596(null, (class_6880)class_5712.field_28157, this.method_24515());
        }
        if (this.method_60953() && (leashPost = this.method_60952().method_19538()).method_1022(pos = this.method_19538()) >= 5.0) {
            class_243 newVel = leashPost.method_1020(pos).method_1021(0.01);
            if (this.isAirworthy()) {
                this.method_18799(newVel.method_1027() < 1.0E-4 ? class_243.field_1353 : newVel);
            } else {
                this.method_18799(this.method_18798().method_1021(0.9).method_1019(newVel));
            }
        }
        this.prevBoosting = boosting;
        if (this.method_20802() > 0) {
            this.method_20803(1);
        }
        for (Animatable bag : this.sandbags) {
            bag.tick();
        }
        this.burner.tick();
        super.method_5773();
        this.prevXDelta = this.xDelta;
        this.prevZDelta = this.zDelta;
        this.xDelta = this.method_23317() - this.field_6014;
        this.zDelta = this.method_23321() - this.field_5969;
    }

    public class_1269 method_5664(class_1657 player, class_243 relativePositionOffset, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.hasBalloon() && this.hasBurner()) {
            if (this.getBurnerBoundingBox().method_1014(0.7).method_1006(this.method_19538().method_1019(relativePositionOffset))) {
                if (stack.method_31574(class_1802.field_8884)) {
                    this.setAscending(!this.isAscending());
                    if (this.isAscending()) {
                        this.method_5783(USounds.ENTITY_HOT_AIR_BALLOON_BOOST, 1.0f, 1.0f);
                    }
                    stack.method_7970(1, (class_1309)player, AirBalloonEntity.method_56079((class_1268)hand));
                    this.method_5783(USounds.Vanilla.field_15145, 1.0f, 1.0f);
                    if (!player.method_21751()) {
                        this.method_37908().method_33596((class_1297)player, (class_6880)class_5712.field_28725, this.method_24515());
                    }
                    this.burner.setPulling();
                    return class_1269.field_5812;
                }
                if (stack.method_7960() && this.isAscending()) {
                    this.setBoostTicks(50);
                    this.method_5783(USounds.ENTITY_HOT_AIR_BALLOON_BOOST, 1.0f, 1.0f);
                    this.burner.setPulling();
                    if (!player.method_21751()) {
                        this.method_37908().method_33596((class_1297)player, (class_6880)class_5712.field_28725, this.method_24515());
                    }
                    return class_1269.field_5812;
                }
            }
            if (this.getInflation(1.0f) >= 1.0f) {
                int xPush = (int)Math.signum(relativePositionOffset.field_1352);
                int zPush = (int)Math.signum(relativePositionOffset.field_1350);
                class_243 absHitPos = this.method_19538().method_1019(relativePositionOffset);
                if (stack.method_7960() && MultiBox.unbox(this.method_5829()).method_1009(0.5, 1.0, 0.5).method_989((double)(2 * xPush), 3.0, (double)(2 * zPush)).method_1006(absHitPos)) {
                    if (!this.method_37908().field_9236) {
                        this.manualVelocity = this.manualVelocity.method_1031(1.7 * (double)xPush, 0.0, 1.7 * (double)zPush);
                    }
                    this.method_37908().method_43128(null, this.method_23317() + relativePositionOffset.method_10216(), this.method_23318() + relativePositionOffset.method_10214(), this.method_23321() + relativePositionOffset.method_10215(), USounds.Vanilla.field_15062, this.method_5634(), 1.0f, 1.0f);
                    if (!player.method_21751()) {
                        this.method_37908().method_33596((class_1297)player, (class_6880)class_5712.field_28725, this.method_24515());
                    }
                    int sandbagId = class_3532.method_15340((int)(-xPush), (int)0, (int)1) + class_3532.method_15340((int)(-zPush), (int)0, (int)1) * 2;
                    player.method_43496((class_2561)class_2561.method_43470((String)("" + sandbagId)));
                    this.getSandbag(sandbagId).setPulling();
                    return class_1269.field_5812;
                }
                if (stack.method_7960()) {
                    if (MultiBox.unbox(this.method_5829()).method_1009(0.5, 1.0, 0.5).method_1006(absHitPos)) {
                        return player.method_5804((class_1297)this) ? class_1269.field_5812 : class_1269.field_5814;
                    }
                    class_238 balloonBox = this.getBalloonBoundingBox();
                    if (balloonBox.method_1014(0.5).method_35575(balloonBox.field_1325 - 0.25).method_1006(absHitPos)) {
                        return player.method_5804((class_1297)this) ? class_1269.field_5812 : class_1269.field_5814;
                    }
                }
            }
        }
        return class_1269.field_5811;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        int fuel;
        class_1799 stack = player.method_5998(hand);
        if (stack.method_57826(UDataComponentTypes.BALLOON_DESIGN) && !this.hasBalloon()) {
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            this.method_5783((class_3414)USounds.ENTITY_HOT_AIR_BALLOON_EQUIP_CANOPY.comp_349(), 1.0f, 1.0f);
            if (!player.method_21751()) {
                this.method_37908().method_33596((class_1297)player, (class_6880)class_5712.field_28739, this.method_24515());
            }
            this.setDesign(BalloonDesign.of(this.method_37908(), stack));
            if (this.hasBurner() && this.hasBalloon()) {
                UCriteria.CONSTRUCT_BALLOON.trigger((class_1297)player);
            }
            return class_1269.field_5812;
        }
        if (stack.method_31573(ConventionalItemTags.SHEAR_TOOLS) && this.hasBalloon()) {
            stack.method_7970(1, (class_1309)player, AirBalloonEntity.method_56079((class_1268)hand));
            this.method_5775(BalloonDesignComponent.set(UItems.GIANT_BALLOON.method_7854(), new BalloonDesignComponent(this.getDesign(), true)));
            this.setDesign(BalloonDesign.NONE);
            this.method_5783((class_3414)USounds.ENTITY_HOT_AIR_BALLOON_EQUIP_CANOPY.comp_349(), 1.0f, 1.0f);
            if (!player.method_21751()) {
                this.method_37908().method_33596((class_1297)player, (class_6880)class_5712.field_28739, this.method_24515());
            }
            return class_1269.field_5812;
        }
        if ((stack.method_31574(class_1802.field_16539) || stack.method_31574(class_1802.field_22016)) && !this.hasBurner()) {
            this.method_6122(class_1268.field_5808, stack.method_46651(1));
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            this.method_5783(USounds.ENTITY_HOT_AIR_BALLOON_EQUIP_BURNER, 0.2f, 1.0f);
            if (!player.method_21751()) {
                this.method_37908().method_33596((class_1297)player, (class_6880)class_5712.field_28739, this.method_24515());
            }
            if (this.hasBurner() && this.hasBalloon()) {
                UCriteria.CONSTRUCT_BALLOON.trigger((class_1297)player);
            }
            return class_1269.field_5812;
        }
        if (this.hasBurner() && (fuel = class_3866.method_11196().getOrDefault(stack.method_7909(), 0).intValue()) > 0) {
            if (this.fuelItems.size() < 64) {
                this.fuelItems.add(stack.method_60504(1, (class_1309)player));
                this.burner.setPulling();
                this.method_5783(USounds.Vanilla.field_14815, 1.0f, 1.0f);
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    protected void method_16078() {
        this.method_5775(this.method_31480());
        if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            class_1799 lantern = this.method_5998(class_1268.field_5808);
            this.method_6122(class_1268.field_5808, class_1799.field_8037);
            this.method_5775(lantern);
            if (this.hasBalloon()) {
                this.method_5775(BalloonDesignComponent.set(UItems.GIANT_BALLOON.method_7854(), new BalloonDesignComponent(this.getDesign(), true)));
                this.setDesign(BalloonDesign.NONE);
            }
            this.fuelItems.forEach(arg_0 -> ((AirBalloonEntity)this).method_5775(arg_0));
            this.fuelItems.clear();
        }
    }

    public class_1799 method_31480() {
        return this.asItem().method_7854();
    }

    public class_1792 asItem() {
        return Objects.requireNonNull(BasketItem.REGISTRY.get(this.getBasketType()));
    }

    public void method_5697(class_1297 entity) {
        if (entity instanceof AirBalloonEntity) {
            super.method_5697(entity);
        }
    }

    public void method_6087(class_1297 entity) {
        if (entity instanceof AirBalloonEntity) {
            super.method_6087(entity);
        }
    }

    @Override
    public class_3414 getWalkedOnSound(double y) {
        if (y >= this.getBalloonBoundingBox().field_1322) {
            return USounds.ENTITY_HOT_AIR_BALLOON_STEP;
        }
        return USounds.ENTITY_HOT_AIR_BALLOON_BASKET_STEP;
    }

    @Override
    public boolean collidesWithClouds() {
        return this.isAirworthy() && !this.isAscending();
    }

    @Override
    public float getCloudWalkingStrength() {
        return this.isAirworthy() ? 2.0f : 0.0f;
    }

    public void method_6091(class_243 movementInput) {
        if (!this.isAirworthy()) {
            super.method_6091(movementInput);
        } else {
            float speed = 0.02f;
            float momentum = 0.91f;
            if (this.method_5787()) {
                if (this.method_5799() || this.method_5771()) {
                    this.method_5724(0.02f, movementInput);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                    this.method_18799(this.method_18798().method_1021(this.method_5799() ? 0.8 : 0.5));
                } else {
                    float slipperyness = (this.method_24828() ? this.method_37908().method_8320(this.method_23314()).method_26204().method_9499() : 1.0f) * 0.91f;
                    float drag = this.method_24828() ? 0.1f * (0.16277137f / (slipperyness * slipperyness * slipperyness)) : 0.02f;
                    this.method_5724(drag, movementInput);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                    this.method_18799(this.method_18798().method_1021((double)slipperyness));
                }
            }
            this.method_29242(false);
        }
        if (this.isAirworthy()) {
            Map<class_238, List<class_1297>> collidingEntities = this.getCollidingEntities(this.getBoundingBoxes().stream());
            for (Map.Entry<class_238, List<class_1297>> passengers : collidingEntities.entrySet()) {
                for (class_1297 passenger : passengers.getValue()) {
                    Living<class_1297> living = Living.living(passenger);
                    if (living == null) continue;
                    living.getTransportation().setVehicle(this);
                }
            }
        }
    }

    protected class_238 method_33332() {
        List<class_238> boxes = this.getBoundingBoxes();
        class_238 box = super.method_33332();
        if (this.hasBalloon() && this.getInflation(1.0f) > 0.999f) {
            double horScale = -0.5;
            boxes.add(box.method_1009(horScale, 1.0, horScale).method_989(2.0, 3.0, 2.0));
            boxes.add(box.method_1009(horScale, 1.0, horScale).method_989(-2.0, 3.0, 2.0));
            boxes.add(box.method_1009(horScale, 1.0, horScale).method_989(2.0, 3.0, -2.0));
            boxes.add(box.method_1009(horScale, 1.0, horScale).method_989(-2.0, 3.0, -2.0));
        }
        if (this.hasBurner()) {
            boxes.add(this.getBurnerBoundingBox());
        }
        return MultiBox.of(box, boxes);
    }

    public class_238 method_5830() {
        if (this.hasBalloon()) {
            return this.getBalloonBoundingBox().method_35575(this.method_23318());
        }
        return this.getInteriorBoundingBox();
    }

    protected class_238 getInteriorBoundingBox() {
        class_238 box = MultiBox.unbox(this.method_5829());
        return box.method_35575(box.field_1322 - 0.5).method_35580(0.15, 0.0, 0.15);
    }

    protected class_238 getBalloonBoundingBox() {
        float inflation = this.getInflation(1.0f);
        return MultiBox.unbox(this.method_5829()).method_989(0.125, 7.3 * (double)inflation, 0.125).method_1009(2.25, 3.7 * (double)inflation, 2.25);
    }

    protected class_238 getBurnerBoundingBox() {
        float inflation = this.getInflation(1.0f);
        float horScale = -0.9f;
        return MultiBox.unbox(this.method_5829()).method_989(0.0, (double)(2.6f * inflation + 0.4f), 0.0).method_1009((double)horScale, 0.4, (double)horScale);
    }

    @Override
    public List<class_238> getGravityZoneBoxes() {
        class_238 balloon = this.getBalloonBoundingBox().method_1014(0.001);
        class_238 interior = this.getInteriorBoundingBox().method_1014(0.001);
        if (this.hasBalloon() && this.getInflation(1.0f) > 0.999f) {
            return List.of(interior.method_35578(balloon.field_1322).method_35575(interior.field_1325), balloon.method_35578(balloon.field_1325 + 0.5).method_35575(balloon.field_1325));
        }
        return List.of(interior.method_35578(balloon.field_1322).method_35575(interior.field_1325));
    }

    @Override
    public List<class_238> getBoundingBoxes() {
        float yaw;
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        class_238 box = this.getInteriorBoundingBox();
        class_238 mainBox = MultiBox.unbox(this.method_5829());
        boxes.add(box);
        double wallheight = box.field_1325 + 0.72;
        double wallThickness = 0.3;
        double halfDoorWidth = 0.5;
        if (!this.getBasketType().isOf(class_1690.class_1692.field_40161)) {
            boxes.add(new class_238(mainBox.field_1323, mainBox.field_1322, mainBox.field_1321, mainBox.field_1323 + wallThickness + halfDoorWidth, wallheight, box.field_1321 + wallThickness));
            boxes.add(new class_238(mainBox.field_1320 - wallThickness - halfDoorWidth, mainBox.field_1322, mainBox.field_1321, mainBox.field_1320, wallheight, box.field_1321 + wallThickness));
            boxes.add(new class_238(mainBox.field_1323, mainBox.field_1322, box.field_1324 - wallThickness, mainBox.field_1320, wallheight, mainBox.field_1324));
            boxes.add(new class_238(box.field_1320 - wallThickness, mainBox.field_1322, mainBox.field_1321, mainBox.field_1320, wallheight, mainBox.field_1324));
            boxes.add(new class_238(mainBox.field_1323, mainBox.field_1322, mainBox.field_1321, box.field_1323 + wallThickness, wallheight, mainBox.field_1324));
        }
        if (this.hasBalloon() && this.getInflation(1.0f) >= 1.0f) {
            class_238 balloonBox = this.getBalloonBoundingBox();
            boxes.add(balloonBox.method_35575(balloonBox.field_1325 - 0.5));
            boxes.add(balloonBox.method_35577(balloonBox.field_1323 + 0.5));
            boxes.add(balloonBox.method_35574(balloonBox.field_1320 - 0.5));
            boxes.add(balloonBox.method_35579(balloonBox.field_1321 + 0.5));
            boxes.add(balloonBox.method_35576(balloonBox.field_1324 - 0.5));
            boxes.add(balloonBox.method_35577(balloonBox.field_1323 + 2.0).method_35578(balloonBox.field_1322 + 0.2));
            boxes.add(balloonBox.method_35574(balloonBox.field_1320 - 2.0).method_35578(balloonBox.field_1322 + 0.2));
            boxes.add(balloonBox.method_35579(balloonBox.field_1321 + 2.0).method_35578(balloonBox.field_1322 + 0.2));
            boxes.add(balloonBox.method_35576(balloonBox.field_1324 - 2.0).method_35578(balloonBox.field_1322 + 0.2));
        }
        if ((yaw = (180.0f - this.method_5735().method_10144()) * ((float)Math.PI / 180)) != 0.0f) {
            class_243 center = this.method_19538();
            for (int i = 0; i < boxes.size(); ++i) {
                class_238 b = (class_238)boxes.get(i);
                class_243 min = new class_243(b.field_1323, b.field_1322, b.field_1321).method_1020(center).method_1024(yaw).method_1019(center);
                class_243 max = new class_243(b.field_1320, b.field_1325, b.field_1324).method_1020(center).method_1024(yaw).method_1019(center);
                boxes.set(i, new class_238(min.field_1352, min.field_1351, min.field_1350, max.field_1352, max.field_1351, max.field_1350));
            }
        }
        return boxes;
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        class_243 oldPos = this.method_19538();
        List<class_238> boundingBoxes = this.getGravityZoneBoxes();
        super.method_5784(movementType, movement);
        if (movementType == class_1313.field_6308) {
            class_243 actualMovement = this.method_19538().method_1020(oldPos);
            Map<class_238, List<class_1297>> collidingEntities = this.getCollidingEntities(boundingBoxes.stream().map(box -> box.method_18804(actualMovement)));
            for (Map.Entry<class_238, List<class_1297>> passengers : collidingEntities.entrySet()) {
                for (class_1297 passenger : passengers.getValue()) {
                    this.movePassenger(passenger, actualMovement);
                }
            }
        }
    }

    private void movePassenger(class_1297 passenger, class_243 movement) {
        if (!class_1301.field_6155.test(passenger)) {
            return;
        }
        Living<class_1297> living = Living.living(passenger);
        if (living != null) {
            if (living.getPhysics().isGravityNegative()) {
                movement = movement.method_18805(1.0, -1.0, 1.0);
            }
            living.getTransportation().setVehicle(this);
        }
        ArrayList shapes = new ArrayList();
        this.getCollissionShapes(class_3726.method_16195((class_1297)passenger), shapes::add);
        movement = class_1297.method_20736((class_1297)passenger, (class_243)movement, (class_238)passenger.method_5829(), (class_1937)this.method_37908(), shapes);
        passenger.method_33574(passenger.method_19538().method_1019(movement));
        passenger.method_43391(passenger.method_23317(), passenger.method_23318(), passenger.method_23321());
    }

    @Override
    public Map<class_238, List<class_1297>> getCollidingEntities(Stream<class_238> boundingBoxes) {
        return boundingBoxes.collect(Collectors.toMap(Function.identity(), box -> this.method_37908().method_8333((class_1297)this, box.method_1014(0.001).method_18804(this.method_18798().method_1021(1.0)), RIDER_PREDICATE).stream().distinct().toList()));
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setBasketType(BasketType.of(compound.method_10558("basket")));
        this.setDesign(BalloonDesign.getType(compound.method_10558("design")));
        this.setAscending(compound.method_10577("burnerActive"));
        this.setBoostTicks(compound.method_10550("boostTicks"));
        this.prevInflation = compound.method_10550("inflationAmount");
        this.setInflation(this.prevInflation);
        this.activeFuel = class_3532.method_15340((int)compound.method_10550("fuel"), (int)0, (int)this.maxFuel);
        this.fuelItems = compound.method_10573("fuelItems", 9) ? compound.method_10554("fuelItems", 10).stream().map(item -> class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)((class_2487)item))).limit(64L).collect(Collectors.toList()) : new ArrayList<class_1799>();
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("design", this.getDesign().method_15434());
        compound.method_10582("basket", this.getBasketType().id().toString());
        compound.method_10556("burnerActive", this.isAscending());
        compound.method_10569("boostTicks", this.getBoostTicks());
        compound.method_10569("inflationAmount", this.getInflation());
        compound.method_10569("fuel", this.activeFuel);
        class_2499 fuelItemsNbt = new class_2499();
        this.fuelItems.forEach(item -> fuelItemsNbt.add((Object)NbtSerialisable.encode(class_1799.field_49266, item, (class_7225.class_7874)this.method_56673())));
        compound.method_10566("fuelItems", (class_2520)fuelItemsNbt);
    }

    public void method_5711(byte status) {
        if (status >= 100 && status < 100 + this.sandbags.length) {
            this.getSandbag(status % this.sandbags.length).setPulling();
        } else if (status != 105) {
            super.method_5711(status);
        }
    }

    static boolean isBetween(double value, double min, double max) {
        return value >= min && value <= max;
    }

    public class Animatable {
        private final int id;
        private int pullTicks;
        private int prevPullTicks;
        private boolean pulling;

        public Animatable(int id) {
            this.id = id;
        }

        public void setPulling() {
            if (!AirBalloonEntity.this.method_37908().field_9236) {
                AirBalloonEntity.this.method_37908().method_8421((class_1297)AirBalloonEntity.this, (byte)(100 + this.id));
            }
            this.pulling = true;
        }

        public float getPullProgress(float tickDelta) {
            return class_3532.method_16439((float)tickDelta, (float)this.prevPullTicks, (float)this.pullTicks) / 6.0f;
        }

        public void tick() {
            this.prevPullTicks = this.pullTicks;
            if (this.pulling && this.pullTicks < 6) {
                ++this.pullTicks;
            } else {
                this.pulling = false;
                if (this.pullTicks > 0) {
                    --this.pullTicks;
                }
            }
        }
    }

    public record BasketType(class_2960 id, @Nullable class_1690.class_1692 boatType) {
        private static final Map<class_2960, BasketType> REGISTRY = new HashMap<class_2960, BasketType>();
        public static final BasketType DEFAULT = BasketType.of(class_1690.class_1692.field_7727);

        public boolean isOf(class_1690.class_1692 boatType) {
            return this.boatType == boatType;
        }

        public static BasketType of(String name) {
            class_2960 id;
            class_2960 class_29602 = id = name == null || name.isEmpty() ? null : class_2960.method_12829((String)name);
            if (id == null) {
                return BasketType.of(class_1690.class_1692.field_7727);
            }
            return REGISTRY.get(id);
        }

        public static BasketType of(class_1690.class_1692 boatType) {
            return REGISTRY.computeIfAbsent(class_2960.method_60654((String)boatType.method_15434()), id -> new BasketType((class_2960)id, boatType));
        }

        public static BasketType of(class_5321<TerraformBoatType> id) {
            return REGISTRY.computeIfAbsent(id.method_29177(), i -> new BasketType((class_2960)i, null));
        }

        static {
            Arrays.stream(class_1690.class_1692.values()).forEach(BasketType::of);
        }
    }

    public static enum BalloonDesign implements class_3542
    {
        NONE,
        LUNA,
        DAWN,
        EQUALITY,
        STORM,
        TALE;

        public static final BalloonDesign[] VALUES;
        public static final class_3542.class_7292<BalloonDesign> CODEC;
        public static final class_9139<ByteBuf, BalloonDesign> PACKET_CODEC;
        private final String name = this.name().toLowerCase(Locale.ROOT);

        public String method_15434() {
            return this.name;
        }

        public static BalloonDesign of(class_1937 world, class_1799 stack) {
            BalloonDesign design = BalloonDesignComponent.get(stack).design();
            if (design == NONE) {
                return VALUES[1 + world.method_8409().method_43048(VALUES.length - 1)];
            }
            return design;
        }

        public static BalloonDesign getType(int type) {
            return VALUES[Math.abs(type) % VALUES.length];
        }

        public static BalloonDesign getType(String name) {
            return (BalloonDesign)CODEC.method_47920(name, (Enum)LUNA);
        }

        static {
            VALUES = BalloonDesign.values();
            CODEC = class_3542.method_28140(BalloonDesign::values);
            PACKET_CODEC = PacketCodecUtils.ofEnum(BalloonDesign.class);
        }
    }
}

