/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.mob;

import com.minelittlepony.unicopia.Affinity;
import com.minelittlepony.unicopia.WeaklyOwned;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.Levelled;
import com.minelittlepony.unicopia.ability.magic.SpellInventory;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.SpellSlots;
import com.minelittlepony.unicopia.ability.magic.spell.PlacementControlSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.entity.EntityPhysics;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.MagicImmune;
import com.minelittlepony.unicopia.entity.Physics;
import com.minelittlepony.unicopia.entity.mob.LightEmittingEntity;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.network.track.Trackable;
import com.minelittlepony.unicopia.server.world.Ether;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_7225;

public class CastSpellEntity
extends LightEmittingEntity
implements Caster<CastSpellEntity>,
WeaklyOwned.Mutable<class_1309>,
MagicImmune {
    private static final class_2940<Integer> LEVEL = class_2945.method_12791(CastSpellEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MAX_LEVEL = class_2945.method_12791(CastSpellEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> CORRUPTION = class_2945.method_12791(CastSpellEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MAX_CORRUPTION = class_2945.method_12791(CastSpellEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DEAD = class_2945.method_12791(CastSpellEntity.class, (class_2941)class_2943.field_13323);
    private final EntityPhysics<CastSpellEntity> physics = new EntityPhysics<CastSpellEntity>(this);
    private final SpellInventory spells = SpellSlots.ofSingle(this);
    private final EntityReference<class_1309> owner = new EntityReference();
    private final Levelled.LevelStore level = Levelled.of(() -> (Integer)this.field_6011.method_12789(LEVEL), l -> this.field_6011.method_12778(LEVEL, (Object)l), () -> (Integer)this.field_6011.method_12789(MAX_LEVEL));
    private final Levelled.LevelStore corruption = Levelled.of(() -> (Integer)this.field_6011.method_12789(CORRUPTION), l -> this.field_6011.method_12778(CORRUPTION, (Object)l), () -> (Integer)this.field_6011.method_12789(MAX_CORRUPTION));
    private UUID controllingEntityUuid;
    private UUID controllingSpellUuid;
    private int prevAge;
    private int prevDeathTicks;
    private int deathTicks;

    public CastSpellEntity(class_1937 world, Caster<?> caster, PlacementControlSpell control) {
        this(UEntities.CAST_SPELL, world);
        this.controllingEntityUuid = caster.asEntity().method_5667();
        this.controllingSpellUuid = control.getUuid();
        this.setCaster(caster);
        Spell spell = control.getDelegate();
        if (spell instanceof PlacementControlSpell.PlacementDelegate) {
            PlacementControlSpell.PlacementDelegate delegate = (PlacementControlSpell.PlacementDelegate)((Object)spell);
            delegate.onPlaced(caster, control);
        }
        this.spells.getSlots().put(Spell.copy(control.getDelegate(), (class_7225.class_7874)world.method_30349()));
    }

    public CastSpellEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.field_5985 = true;
        Trackable.of(this).getDataTrackers().getPrimaryTracker().startTracking(this.owner);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(LEVEL, (Object)0);
        builder.method_56912(CORRUPTION, (Object)0);
        builder.method_56912(MAX_LEVEL, (Object)1);
        builder.method_56912(MAX_CORRUPTION, (Object)1);
        builder.method_56912(DEAD, (Object)false);
    }

    public void method_5641(double x, double y, double z, float yaw, float pitch) {
        super.method_5641(x, y, z, yaw, pitch);
        this.spells.getSlots().stream(SpellPredicate.IS_ORIENTED).forEach(spell -> spell.setOrientation(this, pitch, yaw));
    }

    private boolean checkConnection() {
        return Ether.get(this.method_37908()).get(SpellType.PLACE_CONTROL_SPELL, this.controllingEntityUuid, this.controllingSpellUuid) != null;
    }

    public float getAge(float tickDelta) {
        return class_3532.method_48781((float)tickDelta, (int)this.prevAge, (int)this.field_6012);
    }

    public float getScale(float tickDelta) {
        float add = class_3532.method_15363((float)(this.getAge(tickDelta) / 25.0f), (float)0.0f, (float)1.0f);
        float subtract = class_3532.method_15363((float)((float)class_3532.method_48781((float)tickDelta, (int)this.prevDeathTicks, (int)this.deathTicks) / 20.0f), (float)0.0f, (float)1.0f);
        return class_3532.method_15363((float)(add - subtract), (float)0.0f, (float)1.0f);
    }

    @Override
    public int getLightLevel() {
        return 11;
    }

    public class_2561 method_5477() {
        class_1297 master = this.getMaster();
        if (master != null) {
            return class_2561.method_43469((String)"entity.unicopia.cast_spell.by", (Object[])new Object[]{master.method_5477()});
        }
        return super.method_5477();
    }

    public void method_5670() {
        this.prevAge = this.field_6012++;
        super.method_5670();
        if (!this.isClient()) {
            if (!this.checkConnection()) {
                this.method_5768();
            }
            this.spells.getSlots().get().ifPresent(spell -> Ether.get(this.method_37908()).getOrCreate(spell, this));
        } else if (this.isDead()) {
            this.spells.getSlots().clear();
        }
        this.prevDeathTicks = this.deathTicks;
        if (!this.spells.tick(Situation.GROUND) && this.deathTicks++ > 40) {
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public void method_5768() {
        this.setDead(true);
    }

    public boolean isDead() {
        return (Boolean)this.field_6011.method_12789(DEAD);
    }

    public void setDead(boolean dead) {
        this.field_6011.method_12778(DEAD, (Object)dead);
        if (dead) {
            this.spells.getSlots().clear();
        }
    }

    public class_4048 method_18377(class_4050 pose) {
        return super.method_18377(pose).method_18383(this.getScale(1.0f));
    }

    @Override
    public EntityReference<class_1309> getMasterReference() {
        return this.owner;
    }

    @Override
    public CastSpellEntity asEntity() {
        return this;
    }

    public void setCaster(Caster<?> caster) {
        this.field_6011.method_12778(LEVEL, (Object)caster.getLevel().get());
        this.field_6011.method_12778(MAX_LEVEL, (Object)caster.getLevel().getMax());
        this.field_6011.method_12778(CORRUPTION, (Object)caster.getCorruption().get());
        this.field_6011.method_12778(MAX_CORRUPTION, (Object)caster.getCorruption().getMax());
        this.setMaster(caster);
    }

    @Override
    public Levelled.LevelStore getLevel() {
        return this.level;
    }

    @Override
    public Levelled.LevelStore getCorruption() {
        return this.corruption;
    }

    @Override
    public Affinity getAffinity() {
        return this.getSpellSlot().get().map(Spell::getAffinity).orElse(Affinity.NEUTRAL);
    }

    @Override
    public Physics getPhysics() {
        return this.physics;
    }

    @Override
    public SpellSlots getSpellSlot() {
        return this.spells.getSlots();
    }

    public boolean method_5863() {
        return false;
    }

    @Override
    public boolean subtractEnergyCost(double amount) {
        if (this.getMaster() == null) {
            return true;
        }
        return Caster.of(this.getMaster()).filter(c -> c.subtractEnergyCost(amount)).isPresent();
    }

    protected void method_5652(class_2487 tag) {
        tag.method_10566("level", NbtSerialisable.encode(Levelled.CODEC, this.level, (class_7225.class_7874)this.method_56673()));
        tag.method_10566("corruption", NbtSerialisable.encode(Levelled.CODEC, this.corruption, (class_7225.class_7874)this.method_56673()));
        if (this.controllingEntityUuid != null) {
            tag.method_25927("owningEntity", this.controllingEntityUuid);
        }
        if (this.controllingSpellUuid != null) {
            tag.method_25927("owningSpell", this.controllingSpellUuid);
        }
        this.spells.getSlots().toNBT(tag, (class_7225.class_7874)this.method_56673());
        tag.method_10569("age", this.field_6012);
        tag.method_10569("prevAge", this.prevAge);
        tag.method_10556("dead", this.isDead());
        tag.method_10566("owner", (class_2520)this.owner.toNBT((class_7225.class_7874)this.method_56673()));
    }

    protected void method_5749(class_2487 tag) {
        Levelled.LevelStore level = NbtSerialisable.decode(Levelled.CODEC, tag.method_10580("level"), (class_7225.class_7874)this.method_56673()).orElse(Levelled.ZERO);
        this.field_6011.method_12778(MAX_LEVEL, (Object)level.getMax());
        this.field_6011.method_12778(LEVEL, (Object)level.get());
        Levelled.LevelStore corruption = NbtSerialisable.decode(Levelled.CODEC, tag.method_10580("corruption"), (class_7225.class_7874)this.method_56673()).orElse(Levelled.ZERO);
        this.field_6011.method_12778(MAX_CORRUPTION, (Object)corruption.getMax());
        this.field_6011.method_12778(CORRUPTION, (Object)corruption.get());
        this.controllingEntityUuid = tag.method_25928("owningEntity") ? tag.method_25926("owningEntity") : null;
        this.controllingSpellUuid = tag.method_25928("owningSpell") ? tag.method_25926("owningSpell") : null;
        this.spells.getSlots().fromNBT(tag, (class_7225.class_7874)this.method_56673());
        this.field_6012 = tag.method_10550("age");
        this.prevAge = tag.method_10550("prevAge");
        this.setDead(tag.method_10577("dead"));
        if (tag.method_10545("owner")) {
            this.owner.fromNBT(tag.method_10562("owner"), (class_7225.class_7874)this.method_56673());
        }
    }
}

