/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.mob;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.entity.mob.StationaryObjectEntity;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.server.world.Altar;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public class FloatingArtefactEntity
extends StationaryObjectEntity {
    private static final class_2940<class_1799> ITEM = class_2945.method_12791(FloatingArtefactEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Byte> STATE = class_2945.method_12791(FloatingArtefactEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Float> TARGET_ROTATION_SPEED = class_2945.method_12791(FloatingArtefactEntity.class, (class_2941)class_2943.field_13320);
    private static final int REGEN_GAP_TICKS = 5;
    private static final int REGEN_PAUSE_TICKS = 200;
    public static final int INFINITE_BOOST_DURATION = -1;
    private float bobAmount;
    private float prevRotationSpeed;
    private float rotationSpeed;
    private float prevRotation;
    private float rotation;
    private int boostDuration;
    private int ticksUntilRegen;
    public final float positionSeed;
    private Optional<Altar> altar = Optional.empty();

    public FloatingArtefactEntity(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
        this.positionSeed = (float)(Math.random() * Math.PI * 2.0);
    }

    protected class_2561 method_23315() {
        return this.getStack().method_7964();
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ITEM, (Object)class_1799.field_8037);
        builder.method_56912(STATE, (Object)0);
        builder.method_56912(TARGET_ROTATION_SPEED, (Object)Float.valueOf(1.0f));
    }

    public void setAltar(Altar altar) {
        this.altar = Optional.of(altar);
    }

    public class_1799 getStack() {
        return (class_1799)this.field_6011.method_12789(ITEM);
    }

    public void setStack(class_1799 stack) {
        this.field_6011.method_12778(ITEM, (Object)stack);
    }

    public State getState() {
        return State.valueOf(((Byte)this.field_6011.method_12789(STATE)).byteValue());
    }

    public void setState(State state) {
        this.field_6011.method_12778(STATE, (Object)((byte)state.ordinal()));
    }

    public void setRotationSpeed(float spin, int duration) {
        this.field_6011.method_12778(TARGET_ROTATION_SPEED, (Object)Float.valueOf(Math.max(spin, 0.0f)));
        this.boostDuration = duration;
    }

    public float getRotationSpeed() {
        return ((Float)this.field_6011.method_12789(TARGET_ROTATION_SPEED)).floatValue();
    }

    public float getRotationSpeed(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.prevRotationSpeed, (float)this.rotationSpeed);
    }

    @Override
    public float getMaxHealth() {
        return 20.0f;
    }

    public void method_5773() {
        float targetRotationSpeed;
        class_243 pos = class_243.method_24955((class_2382)this.method_24515());
        this.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
        super.method_5773();
        class_1799 stack = this.getStack();
        if (stack.method_7960()) {
            this.setStack(UItems.EMPTY_JAR.method_7854());
        }
        if (this.method_37908().field_9236) {
            this.bobAmount += 1.0f;
        }
        if (this.rotationSpeed != (targetRotationSpeed = this.getRotationSpeed())) {
            float difference = targetRotationSpeed - this.rotationSpeed;
            this.rotationSpeed = Math.abs(difference) < 0.02f ? targetRotationSpeed : this.rotationSpeed + difference * (difference > 0.0f ? 0.5f : 0.1f);
        } else if (this.boostDuration > 0 && --this.boostDuration <= 0) {
            this.setRotationSpeed(1.0f, 0);
        }
        this.rotation %= 360.0f;
        this.prevRotation = this.rotation;
        this.rotation += this.rotationSpeed;
        if (stack.method_7909() instanceof Artifact) {
            ((Artifact)stack.method_7909()).onArtifactTick(this);
        }
        if (this.getHealth() < this.getMaxHealth() && --this.ticksUntilRegen <= 0) {
            this.setHealth(this.getHealth() + 1.0f);
            this.ticksUntilRegen = 5;
        }
        if (this.method_37908().method_8510() % 80L == 0L) {
            State state = this.getState();
            this.method_5783(USounds.ENTITY_ARTEFACT_AMBIENT, state.getVolume(), state.getPitch());
        }
    }

    public float getVerticalOffset(float tickDelta) {
        return class_3532.method_15374((float)((this.bobAmount + tickDelta) / 10.0f + this.positionSeed)) * 0.025f + 0.05f;
    }

    public float getRotation(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.prevRotation, (float)this.rotation) % 360.0f;
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setStack(class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)compound.method_10562("Item")));
        this.setState(State.valueOf(compound.method_10550("State")));
        this.setRotationSpeed(compound.method_10583("spin"), compound.method_10550("spinDuration"));
        this.ticksUntilRegen = compound.method_10550("regen");
        this.altar = NbtSerialisable.decode(Altar.CODEC, compound.method_10580("altar"), (class_7225.class_7874)this.method_56673());
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        class_1799 stack = this.getStack();
        if (!stack.method_7960()) {
            compound.method_10566("Item", NbtSerialisable.encode(class_1799.field_24671, stack, (class_7225.class_7874)this.method_56673()));
        }
        compound.method_10569("State", this.getState().ordinal());
        compound.method_10548("spin", this.getRotationSpeed());
        compound.method_10569("spinDuration", this.boostDuration);
        compound.method_10569("regen", this.ticksUntilRegen);
        this.altar.ifPresent(altar -> compound.method_10566("altar", NbtSerialisable.encode(Altar.CODEC, altar, (class_7225.class_7874)this.method_56673())));
    }

    @Override
    public boolean method_5643(class_1282 source, float damage) {
        if (this.method_37908().field_9236 || this.method_5655()) {
            return false;
        }
        if (this.method_5679(source) || !this.getStack().method_58407(source)) {
            return false;
        }
        this.ticksUntilRegen = 200;
        if (source.method_5530()) {
            damage = this.getHealth();
        }
        return super.method_5643(source, damage);
    }

    @Override
    protected void onKilled(class_1282 source) {
        class_1799 stack = this.getStack();
        if (!(!this.altar.isEmpty() || stack.method_7909() instanceof Artifact && ((Artifact)stack.method_7909()).onArtifactDestroyed(this) == class_1269.field_5812 || source.method_5530())) {
            this.method_5775(stack);
        }
    }

    @Override
    protected void onHurt() {
        this.method_5783(USounds.ITEM_ICARUS_WINGS_WARN, 1.0f, 1.0f);
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        this.altar.ifPresent(altar -> altar.tearDown(this, this.method_37908()));
    }

    public static enum State {
        INITIALISING,
        RUNNING,
        SHUTTING_DOWN;

        static final State[] VALUES;

        public float getVolume() {
            return this == SHUTTING_DOWN ? 1.0f : 0.2f;
        }

        public float getPitch() {
            return this == INITIALISING ? 1.0f : (this == RUNNING ? 2.0f : 0.5f);
        }

        static State valueOf(int state) {
            return state <= 0 || state >= VALUES.length ? INITIALISING : VALUES[state];
        }

        static {
            VALUES = State.values();
        }
    }

    public static interface Artifact {
        public void onArtifactTick(FloatingArtefactEntity var1);

        public class_1269 onArtifactDestroyed(FloatingArtefactEntity var1);
    }
}

