/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.mob;

import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.client.render.VirtualBlockRenderView;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.item.enchantment.EnchantmentUtil;
import com.minelittlepony.unicopia.mixin.MixinBlockEntity;
import com.minelittlepony.unicopia.util.InventoryUtil;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_39;
import net.minecraft.class_3908;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class MimicEntity
extends class_1314 {
    static final byte OPEN_MOUTH = -56;
    static final byte CLOSE_MOUTH = -55;
    static final class_2940<class_2487> CHEST_DATA = class_2945.method_12791(MimicEntity.class, (class_2941)class_2943.field_13318);
    static final class_2940<Boolean> MOUTH_OPEN = class_2945.method_12791(MimicEntity.class, (class_2941)class_2943.field_13323);
    @Nullable
    private class_2595 chestData;
    private int openTicks;
    private final Set<class_1657> observingPlayers = new HashSet<class_1657>();
    private final VirtualBlockRenderView renderView = new VirtualBlockRenderView(){

        @Override
        public class_1920 proxy() {
            return MimicEntity.this.method_37908();
        }

        @Override
        public class_2586 method_8321(class_2338 pos) {
            if (pos.equals((Object)MimicEntity.this.method_24515())) {
                return MimicEntity.this.chestData;
            }
            return VirtualBlockRenderView.super.method_8321(pos);
        }

        @Override
        public class_2680 method_8320(class_2338 pos) {
            if (pos.equals((Object)MimicEntity.this.method_24515()) && MimicEntity.this.chestData != null && MimicEntity.this.chestData.method_11010() != null) {
                return MimicEntity.this.chestData.method_11010();
            }
            return VirtualBlockRenderView.super.method_8320(pos);
        }
    };

    static void bootstrap() {
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            MimicGeneratable generatable;
            MimicEntity mimic;
            if (blockEntity instanceof MimicGeneratable && (mimic = (generatable = (MimicGeneratable)blockEntity).triggerMimic(player)) != null) {
                player.method_7324((class_1297)mimic);
                return false;
            }
            return true;
        });
    }

    public static boolean shouldConvert(class_1937 world, class_2338 pos, class_1657 player, class_5321<class_52> lootTable) {
        class_2595 be;
        class_2586 class_25862;
        if (!(MimicEntity.shouldGenerateMimic(lootTable) && world.method_8320(pos).method_26164(UTags.Blocks.MIMIC_CHESTS) && (class_25862 = world.method_8321(pos)) instanceof class_2595 && (be = (class_2595)class_25862).method_11010().method_28500((class_2769)class_2281.field_10770).orElse(class_2745.field_12569) == class_2745.field_12569)) {
            return false;
        }
        int difficulty = world.method_8407().ordinal() - 1;
        float threshold = 0.35f * ((float)EnchantmentUtil.getLuck(0, (class_1309)player) / 20.0f + 0.5f);
        return difficulty > 0 && world.field_9229.method_43057() < (float)difficulty / 3.0f * threshold;
    }

    @Nullable
    public static MimicEntity spawnFromChest(class_1937 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof class_2595)) {
            return null;
        }
        class_2595 be = (class_2595)class_25862;
        world.method_8544(pos);
        world.method_8438(be.method_11017().method_24182((class_1922)world, pos));
        world.method_8650(pos, true);
        MimicEntity mimic = (MimicEntity)UEntities.MIMIC.method_5883(world);
        class_2680 state = be.method_11010();
        class_2350 facing = state.method_28500((class_2769)class_2281.field_10768).orElse(null);
        float yaw = facing.method_10144();
        be.method_31664(be.method_11010().method_26204().method_9564());
        mimic.method_5641((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, yaw, 0.0f);
        mimic.method_5847(yaw);
        mimic.method_5636(yaw);
        mimic.method_36456(yaw);
        mimic.setChest(be);
        world.method_8649((class_1297)mimic);
        return mimic;
    }

    public static boolean shouldGenerateMimic(@Nullable class_5321<class_52> lootTable) {
        return lootTable != null && lootTable.method_29177().method_12832().indexOf("village") == -1 && lootTable.method_29177().method_12832().indexOf("bastion") == -1 && lootTable.method_29177().method_12832().indexOf("underwater") == -1 && lootTable.method_29177().method_12832().indexOf("shipwreck") == -1 && !class_39.field_850.equals(lootTable);
    }

    MimicEntity(class_1299<? extends MimicEntity> type, class_1937 world) {
        super(type, world);
        this.field_5985 = true;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(CHEST_DATA, (Object)new class_2487());
        builder.method_56912(MOUTH_OPEN, (Object)false);
    }

    public boolean method_30948() {
        return this.method_5805();
    }

    @Nullable
    public class_1799 method_31480() {
        class_1792 item = this.chestData.method_11010().method_26204().method_8389();
        return item == class_1802.field_8162 ? null : item.method_7854();
    }

    protected void method_5959() {
        this.field_6201.method_6277(2, (class_1352)new AttackGoal(this, 0.6f, false));
    }

    public void setChest(class_2281 chest) {
        class_2586 class_25862 = chest.method_10123(this.method_24515(), chest.method_9564());
        if (class_25862 instanceof class_2595) {
            class_2595 be = (class_2595)class_25862;
            this.setChest(be);
            be.method_54867(class_39.field_472, this.method_37908().method_8409().method_43055());
            if (!this.method_37908().field_9236) {
                this.field_6011.method_12778(CHEST_DATA, (Object)this.writeChestData(this.chestData));
            }
        }
    }

    public void setChest(@Nullable class_2595 chestData) {
        this.chestData = chestData;
        if (chestData != null) {
            ((MimicGeneratable)chestData).setAllowMimics(false);
            chestData.method_31662(this.method_37908());
        }
        if (!this.method_37908().field_9236) {
            this.field_6011.method_12778(CHEST_DATA, (Object)(chestData == null ? new class_2487() : this.writeChestData(chestData)));
        }
    }

    public class_1920 getBlockRenderView() {
        return this.renderView;
    }

    @Nullable
    public class_2595 getChestData() {
        return this.chestData;
    }

    public boolean isMouthOpen() {
        return (Boolean)this.field_6011.method_12789(MOUTH_OPEN);
    }

    public void setMouthOpen(boolean mouthOpen) {
        if (mouthOpen == this.isMouthOpen()) {
            return;
        }
        this.method_5783(mouthOpen ? class_3417.field_14982 : class_3417.field_14823, 0.5f, 1.0f);
        this.field_6011.method_12778(MOUTH_OPEN, (Object)mouthOpen);
        if (this.chestData != null) {
            this.chestData.method_11004(1, mouthOpen ? 1 : 0);
        }
    }

    public void playChompAnimation() {
        this.openTicks = 5;
        this.setMouthOpen(true);
    }

    public float getPeekAmount() {
        return class_3532.method_15363((float)((float)this.method_18798().method_1027() * 50.0f), (float)0.0f, (float)1.0f);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.field_6012 < 12 || this.method_5968() == null && this.field_6273 < this.field_6012 - 30) {
                class_2338 pos = this.method_24515();
                this.method_5814((double)pos.method_10263() + 0.5, this.method_23318(), (double)pos.method_10260() + 0.5);
                this.method_5636(class_3532.method_15375((float)(this.method_43078() / 90.0f)) * 90);
                this.method_36456(class_3532.method_15375((float)(this.method_36454() / 90.0f)) * 90);
                this.method_5847(class_3532.method_15375((float)(this.method_5791() / 90.0f)) * 90);
                if (this.method_6032() < this.method_6063() && this.method_37908().field_9229.method_43048(20) == 0) {
                    this.method_6025(1.0f);
                } else if (this.field_6012 % 150 == 0 && this.chestData != null && !this.isMouthOpen() && this.method_37908().method_18460((class_1297)this, 15.0) == null) {
                    this.method_37908().method_8501(this.method_24515(), (class_2680)this.chestData.method_11010().method_47968((class_2769)class_2281.field_10768, (Comparable)this.method_5735()));
                    class_2586 class_25862 = this.method_37908().method_8321(this.method_24515());
                    if (class_25862 instanceof class_2595) {
                        class_2595 be = (class_2595)class_25862;
                        InventoryUtil.copyInto((class_1263)this.chestData, be);
                        ((MimicGeneratable)be).setMimic(true);
                        this.method_31472();
                    }
                }
            }
            if (!this.observingPlayers.isEmpty()) {
                this.setMouthOpen(true);
            }
        }
        if (this.chestData == null) {
            this.setChest((class_2281)class_2246.field_10034);
        }
        if (this.method_37908().field_9236) {
            ((MixinBlockEntity)this.chestData).setPos(this.method_24515());
            class_2595.method_31670((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_2680)this.chestData.method_11010(), (class_2595)this.chestData);
        }
        if (this.openTicks > 0 && --this.openTicks <= 0) {
            this.setMouthOpen(false);
        }
        if (this.method_5968() != null && this.openTicks <= 0 && this.field_6012 % 20 == 0) {
            this.playChompAnimation();
        }
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.method_5968() == null && this.chestData != null) {
            player.method_17355(new class_3908(){

                public class_2561 method_5476() {
                    return MimicEntity.this.chestData.method_5476();
                }

                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return MimicEntity.this.createScreenHandler(syncId, inv, player);
                }
            });
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_1703 createScreenHandler(int syncId, class_1661 inv, class_1657 player) {
        return class_1707.method_19245((int)syncId, (class_1661)inv, (class_1263)new MimicInventory(this.chestData, player));
    }

    public void method_19540(boolean attacking) {
        super.method_19540(attacking);
        if (attacking) {
            this.playChompAnimation();
        }
    }

    protected void method_6013(class_1282 source) {
        this.playChompAnimation();
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 l = (class_1309)class_12972;
            this.method_5980(l);
        }
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (CHEST_DATA.equals(data) && this.method_37908().field_9236) {
            this.setChest(this.readChestData((class_2487)this.field_6011.method_12789(CHEST_DATA)));
        } else if (MOUTH_OPEN.equals(data) && this.chestData != null) {
            this.chestData.method_11004(1, this.isMouthOpen() ? 1 : 0);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setChest(nbt.method_10573("chest", 10) ? this.readChestData(nbt.method_10562("chest")) : null);
    }

    @Nullable
    private class_2595 readChestData(class_2487 nbt) {
        class_2680 state = (class_2680)((Pair)class_2680.field_24734.decode((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("state")).result().get()).getFirst();
        class_2586 class_25862 = class_2586.method_11005((class_2338)this.method_24515(), (class_2680)state, (class_2487)nbt.method_10562("data"), (class_7225.class_7874)this.method_56673());
        if (class_25862 instanceof class_2595) {
            class_2595 data = (class_2595)class_25862;
            data.method_31662(this.method_37908());
            ((MimicGeneratable)data).setAllowMimics(false);
            return data;
        }
        return null;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.chestData != null) {
            nbt.method_10566("chest", (class_2520)this.writeChestData(this.chestData));
        }
    }

    @Nullable
    private class_2487 writeChestData(class_2595 chestData) {
        class_2487 chest = new class_2487();
        chest.method_10566("data", (class_2520)chestData.method_38243((class_7225.class_7874)this.method_56673()));
        chest.method_10566("state", (class_2520)class_2680.field_24734.encode((Object)chestData.method_11010(), (DynamicOps)class_2509.field_11560, (Object)new class_2487()).result().get());
        return chest;
    }

    protected void method_16077(class_1282 damageSource, boolean causedByPlayer) {
        if (this.chestData != null) {
            class_1264.method_5452((class_1937)this.method_37908(), (class_1297)this, (class_1263)this.chestData);
            class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)this.method_23318(), (double)this.method_23321(), (class_1799)this.chestData.method_11010().method_26204().method_8389().method_7854());
        }
    }

    public class AttackGoal
    extends class_1366 {
        private int ticks;

        public AttackGoal(class_1314 mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
        }

        public void method_6269() {
            super.method_6269();
            this.ticks = 0;
        }

        public void method_6270() {
            super.method_6270();
            MimicEntity.this.method_19540(false);
        }

        public void method_6268() {
            super.method_6268();
            MimicEntity.this.method_19540(++this.ticks >= 5 && this.method_28348() < this.method_28349() / 2);
        }
    }

    public static interface MimicGeneratable {
        public void setAllowMimics(boolean var1);

        public void setMimic(boolean var1);

        public void readMimicAttributes(class_2487 var1);

        public void writeMimicAttributes(class_2487 var1);

        public void configureMimic(@Nullable class_1657 var1);

        @Nullable
        public MimicEntity triggerMimic(@Nullable class_1657 var1);
    }

    private final class MimicInventory
    implements class_1263 {
        private final class_2595 chestData;
        private final class_1657 player;

        public MimicInventory(class_2595 chestData, class_1657 player) {
            this.chestData = chestData;
            this.player = player;
        }

        public void method_5435(class_1657 player) {
            MimicEntity.this.observingPlayers.add(player);
            MimicEntity.this.setMouthOpen(true);
        }

        public void method_5432(class_1657 player) {
            MimicEntity.this.observingPlayers.remove(player);
            MimicEntity.this.setMouthOpen(!MimicEntity.this.observingPlayers.isEmpty());
        }

        public void method_5448() {
            this.chestData.method_5448();
        }

        public int method_5439() {
            return this.chestData.method_5439();
        }

        public boolean method_5442() {
            return this.chestData.method_5442();
        }

        public class_1799 method_5438(int slot) {
            return this.chestData.method_5438(slot);
        }

        public class_1799 method_5434(int slot, int amount) {
            class_1799 stack = this.chestData.method_5434(slot, amount);
            if (!stack.method_7960()) {
                this.method_5431();
            }
            return stack;
        }

        public class_1799 method_5441(int slot) {
            class_1799 stack = this.chestData.method_5441(slot);
            if (!stack.method_7960()) {
                this.method_5431();
            }
            return stack;
        }

        public void method_5447(int slot, class_1799 stack) {
            class_1799 oldStack = this.method_5438(slot);
            if (!class_1799.method_7973((class_1799)stack, (class_1799)oldStack)) {
                this.chestData.method_5447(slot, class_1799.field_8037);
                MimicEntity.this.method_5775(stack);
                this.method_5431();
            }
        }

        public void method_5431() {
            MimicEntity.this.observingPlayers.clear();
            MimicEntity.this.playChompAnimation();
            MimicEntity.this.method_5980((class_1309)this.player);
            class_1657 class_16572 = this.player;
            if (class_16572 instanceof class_3222) {
                class_3222 spe = (class_3222)class_16572;
                spe.method_7346();
            }
        }

        public boolean method_5443(class_1657 player) {
            return true;
        }
    }
}

