/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.mob;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.ability.magic.spell.crafting.AltarRecipe;
import com.minelittlepony.unicopia.ability.magic.spell.crafting.AltarRecipeMatch;
import com.minelittlepony.unicopia.container.SpellbookScreenHandler;
import com.minelittlepony.unicopia.container.SpellbookState;
import com.minelittlepony.unicopia.entity.MagicImmune;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.item.component.UDataComponentTypes;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgSpellbookStateChanged;
import com.minelittlepony.unicopia.recipe.URecipes;
import com.minelittlepony.unicopia.server.world.Altar;
import com.minelittlepony.unicopia.util.MeteorlogicalUtil;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_7225;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class SpellbookEntity
extends class_1308
implements MagicImmune {
    private static final class_2940<Byte> LOCKED = class_2945.method_12791(SpellbookEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> ALTERED = class_2945.method_12791(SpellbookEntity.class, (class_2941)class_2943.field_13323);
    private static final byte ALTAR_BEAMS_START = 61;
    private static final byte ALTAR_BEAMS_END = 62;
    private static final int TICKS_TO_SLEEP = 600;
    private int activeTicks = 600;
    private boolean prevDaytime;
    private SpellbookState state = new SpellbookState();
    private Optional<Altar> altar = Optional.empty();
    private boolean hasBeams;
    private int beamsActive;
    @Nullable
    private AltarRecipeMatch activeRecipe;

    public SpellbookEntity(class_1299<SpellbookEntity> type, class_1937 world) {
        super(type, world);
        this.method_5971();
        this.setAltered(world.field_9229.method_43048(3) == 0);
        this.state.setCurrentPageId(SpellbookState.CRAFTING_ID);
        if (!world.field_9236) {
            this.state.setSynchronizer(state -> this.method_37908().method_18456().forEach(player -> {
                if (player instanceof class_3222) {
                    class_3222 recipient = (class_3222)player;
                    class_1703 patt0$temp = player.field_7512;
                    if (patt0$temp instanceof SpellbookScreenHandler) {
                        SpellbookScreenHandler book = (SpellbookScreenHandler)patt0$temp;
                        if (this.method_5667().equals(book.entityId)) {
                            Channel.SERVER_SPELLBOOK_UPDATE.sendToPlayer(MsgSpellbookStateChanged.create(book, state), recipient);
                        }
                    }
                }
            }));
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LOCKED, (Object)1);
        builder.method_56912(ALTERED, (Object)false);
    }

    public SpellbookState getSpellbookState() {
        return this.state;
    }

    public void setSpellbookState(SpellbookState state) {
        state.copySyncronizer(this.state);
        this.state = state;
    }

    public class_1799 method_31480() {
        class_1799 stack = UItems.SPELLBOOK.method_7854();
        stack.method_57379(UDataComponentTypes.SPELLBOOK_STATE, (Object)this.state.createCopy());
        return stack;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5862() {
        return false;
    }

    public void setAltar(Altar altar) {
        this.altar = Optional.of(altar);
    }

    public Optional<Altar> getAltar() {
        return this.altar;
    }

    public boolean hasBeams() {
        return this.hasBeams && this.altar.isPresent();
    }

    public boolean isAltered() {
        return (Boolean)this.field_6011.method_12789(ALTERED);
    }

    public void setAltered(boolean altered) {
        this.field_6011.method_12778(ALTERED, (Object)altered);
    }

    protected void setForcedState(TriState state) {
        this.field_6011.method_12778(LOCKED, (Object)((byte)state.ordinal()));
    }

    public void clearForcedState() {
        this.setForcedState(TriState.DEFAULT);
        this.activeTicks = 0;
    }

    private TriState getForcedState() {
        if (this.activeTicks <= 0) {
            this.setForcedState(TriState.DEFAULT);
        }
        return TriState.values()[Math.abs(((Byte)this.field_6011.method_12789(LOCKED)).byteValue()) % 3];
    }

    public boolean isOpen() {
        return this.getForcedState().orElse(!this.shouldBeSleeping());
    }

    public void keepAwake() {
        this.activeTicks = 100;
    }

    public void method_5773() {
        boolean daytime;
        boolean open = this.isOpen();
        super.method_5773();
        if (open && this.method_5799()) {
            this.method_5762(0.0, 0.01, 0.0);
            this.keepAwake();
        }
        if (this.activeTicks > 0) {
            --this.activeTicks;
        }
        if (this.method_37908().field_9236 && open) {
            for (int offX = -2; offX <= 1; ++offX) {
                for (int offZ = -2; offZ <= 1; ++offZ) {
                    if (offX > -1 && offX < 1 && offZ == -1) {
                        offZ = 1;
                    }
                    if (this.field_5974.method_43048(320) != 0) continue;
                    for (int offY = 0; offY <= 1; ++offY) {
                        this.method_37908().method_8406((class_2394)class_2398.field_11215, this.method_23317(), this.method_23318(), this.method_23321(), (double)((float)offX / 2.0f + this.field_5974.method_43057()), (double)((float)offY / 2.0f - this.field_5974.method_43057() + 0.5f), (double)((float)offZ / 2.0f + this.field_5974.method_43057()));
                    }
                }
            }
        }
        this.method_37908().method_8333((class_1297)this, this.method_5829().method_1014(2.0), EquinePredicates.PLAYER_UNICORN.and(e -> e instanceof class_1657)).stream().findFirst().ifPresent(player -> {
            this.keepAwake();
            if (open) {
                class_243 diff = player.method_19538().method_1020(this.method_19538());
                double yaw = Math.atan2(diff.field_1350, diff.field_1352) * 180.0 / Math.PI - 90.0;
                this.method_5847((float)yaw);
                this.method_5636((float)yaw);
            }
        });
        boolean bl = daytime = MeteorlogicalUtil.getSkyAngle(this.method_37908()) < 1.0f;
        if (daytime != this.prevDaytime) {
            this.prevDaytime = daytime;
            if (daytime != this.getForcedState().orElse(daytime)) {
                this.clearForcedState();
            }
        }
        if (!this.method_37908().field_9236 && this.field_6012 % 15 == 0) {
            if (this.altar.isEmpty()) {
                this.altar = Altar.locateAltar(this.method_37908(), this.method_24515()).map(altar -> {
                    altar.generateDecorations(this.method_37908());
                    return altar;
                });
            }
            this.altar = this.altar.filter(altar -> {
                if (!altar.isValid(this.method_37908())) {
                    altar.tearDown(null, this.method_37908());
                    return false;
                }
                this.tickAltarCrafting((Altar)altar);
                class_243 origin = altar.origin().method_46558();
                altar.pillars().forEach(pillar -> this.tickAltarPillar(origin, (class_2338)pillar));
                return true;
            });
        }
    }

    public void setBeamTicks(int ticks) {
        this.method_37908().method_8421((class_1297)this, ticks > 0 ? (byte)61 : 62);
        this.beamsActive = ticks;
    }

    private void tickAltarCrafting(Altar altar) {
        if (this.activeRecipe == null || this.activeRecipe.isRemoved()) {
            AltarRecipe.Input entities = new AltarRecipe.Input(this.method_37908().method_8390(class_1542.class, class_238.method_30048((class_243)altar.origin().method_46558(), (double)2.0, (double)2.0, (double)2.0), class_1301.field_6154));
            this.activeRecipe = this.method_37908().method_8433().method_8132(URecipes.ALTAR, (class_9695)entities, this.method_37908()).map(recipe -> ((AltarRecipe)recipe.comp_1933()).toMatch(entities, (class_7225.class_7874)this.method_37908().method_30349())).orElse(null);
            if (this.activeRecipe != null) {
                this.setBeamTicks(5);
            }
        }
        if (this.beamsActive <= 0) {
            return;
        }
        if (--this.beamsActive > 0) {
            this.method_5783(USounds.Vanilla.field_14880, 1.5f, 0.5f);
            return;
        }
        this.setBeamTicks(0);
        if (this.activeRecipe == null) {
            return;
        }
        this.activeRecipe.craft(this.method_37908());
        this.activeRecipe = null;
        this.method_37908().method_8437((class_1297)this, (double)altar.origin().method_10263(), (double)altar.origin().method_10264(), (double)altar.origin().method_10260(), 0.0f, class_1937.class_7867.field_40888);
    }

    private void tickAltarPillar(class_243 origin, class_2338 pillar) {
        class_243 center = pillar.method_46558().method_1031(this.field_5974.method_43385(0.5, 0.2), this.field_5974.method_43385(0.5, 0.2), this.field_5974.method_43385(0.5, 0.2));
        ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_22246, center.field_1352 - 0.5, center.field_1351 + 0.5, center.field_1350 - 0.5, 0, 0.5, 0.5, 0.5, 0.0);
        if (this.field_5974.method_43048(12) != 0) {
            return;
        }
        class_243 vel = center.method_1020(origin).method_1029();
        ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_22246, center.field_1352 - 0.5, center.field_1351 + 0.5, center.field_1350 - 0.5, 0, vel.field_1352, vel.field_1351, vel.field_1350, -0.2);
        if (this.field_5974.method_43048(2000) == 0) {
            if (this.method_37908().method_8320(pillar).method_27852(class_2246.field_22423)) {
                pillar = pillar.method_10074();
            }
            this.method_37908().method_8501(pillar, class_2246.field_22423.method_9564());
        }
    }

    private boolean shouldBeSleeping() {
        return MeteorlogicalUtil.getSkyAngle(this.method_37908()) > 1.0f && this.activeTicks <= 0;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.method_37908().field_9236) {
            this.method_5650(class_1297.class_5529.field_26998);
            class_2498 sound = class_2498.field_11547;
            this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), sound.method_10595(), class_3419.field_15245, sound.method_10597(), sound.method_10599(), true);
            if (this.method_37908().method_8450().method_8355(class_1928.field_19392)) {
                this.method_5699(this.method_31480(), 1.0f);
            }
        }
        return false;
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        this.altar.ifPresent(altar -> altar.tearDown((class_1297)this, this.method_37908()));
    }

    public class_1269 method_5664(class_1657 player, class_243 vec, class_1268 hand) {
        if (player.method_5715()) {
            this.setForcedState(TriState.of((!this.isOpen() ? 1 : 0) != 0));
            this.keepAwake();
            player.method_5783(USounds.Vanilla.field_17481, 2.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (this.isOpen()) {
            this.keepAwake();
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory<SpellbookState>(){

                public class_2561 method_5476() {
                    return SpellbookEntity.this.method_5476();
                }

                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return new SpellbookScreenHandler(syncId, inv, class_3914.method_17392((class_1937)SpellbookEntity.this.method_37908(), (class_2338)SpellbookEntity.this.method_24515()), SpellbookEntity.this.state, SpellbookEntity.this.method_5667());
                }

                public SpellbookState getScreenOpeningData(class_3222 player) {
                    return SpellbookEntity.this.state;
                }
            });
            player.method_5783(USounds.Vanilla.field_17481, 2.0f, 1.0f);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_5659(class_1927 explosion) {
        return true;
    }

    public boolean method_5679(class_1282 damageSource) {
        return super.method_5679(damageSource) || damageSource.method_48789(UTags.DamageTypes.SPELLBOOK_IMMUNE_TO);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.prevDaytime = compound.method_10577("prevDaytime");
        this.activeTicks = compound.method_10550("activeTicks");
        this.setAltered(compound.method_10577("altered"));
        this.setForcedState(compound.method_10545("locked") ? TriState.of((boolean)compound.method_10577("locked")) : TriState.DEFAULT);
        this.setSpellbookState(NbtSerialisable.decode(SpellbookState.CODEC, (class_2520)compound.method_10562("spellbookState"), (class_7225.class_7874)this.method_56673()).orElse(new SpellbookState()));
        this.altar = NbtSerialisable.decode(Altar.CODEC, compound.method_10580("altar"), (class_7225.class_7874)this.method_56673());
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("activeTicks", this.activeTicks);
        compound.method_10556("prevDaytime", this.prevDaytime);
        compound.method_10556("altered", this.isAltered());
        compound.method_10566("spellbookState", NbtSerialisable.encode(SpellbookState.CODEC, this.state, (class_7225.class_7874)this.method_56673()));
        this.getForcedState().map(t -> {
            compound.method_10556("locked", t);
            return null;
        });
        this.altar.ifPresent(altar -> compound.method_10566("altar", NbtSerialisable.encode(Altar.CODEC, altar, (class_7225.class_7874)this.method_56673())));
    }

    public void method_5711(byte status) {
        switch (status) {
            case 61: {
                this.altar = Altar.locateAltar(this.method_37908(), this.method_24515());
                this.hasBeams = this.altar.isPresent();
                break;
            }
            case 62: {
                this.altar = Optional.empty();
                this.hasBeams = false;
            }
            default: {
                super.method_5711(status);
            }
        }
    }
}

