/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.mob;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.block.UBlocks;
import com.minelittlepony.unicopia.entity.mob.IgnominiousBulbEntity;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.util.shape.Shape;
import com.minelittlepony.unicopia.util.shape.Sphere;
import java.util.Comparator;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1530;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public class TentacleEntity
extends class_1530 {
    static final byte ATTACK_STATUS = 54;
    static final int MAX_GROWTH = 25;
    private static final class_2940<Integer> GROWTH = class_2945.method_12791(TentacleEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MOTION_OFFSET = class_2945.method_12791(TentacleEntity.class, (class_2941)class_2943.field_13327);
    @Nullable
    private class_238 visibilityBox;
    private int prevGrowth;
    private int attackingTicks;
    private float prevAttackingTicks;
    private int ticksActive;
    private int prevMotionOffset;
    public int hurtTime;
    @Nullable
    private class_1309 target;
    private final Comparator<class_1309> targetSorting = Comparator.comparing(arg_0 -> ((TentacleEntity)this).method_5739(arg_0));
    @Nullable
    private IgnominiousBulbEntity bulb;

    public TentacleEntity(class_1299<? extends TentacleEntity> type, class_1937 world) {
        super(type, world);
    }

    public TentacleEntity(class_1937 world, class_2338 pos) {
        super(UEntities.TENTACLE, world, pos);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(GROWTH, (Object)0);
        builder.method_56912(MOTION_OFFSET, (Object)0);
    }

    public void setBulb(IgnominiousBulbEntity bulb) {
        this.bulb = bulb;
    }

    public void attack(class_2338 pos) {
        class_243 offset = pos.method_46558().method_1020(this.method_24515().method_46558());
        double dX = offset.field_1352;
        double dY = offset.field_1351;
        double dZ = offset.field_1350;
        double radius = Math.sqrt(dX * dX + dZ * dZ);
        this.method_36457(class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)dY, (double)radius) * 57.2957763671875)))));
        this.method_36456(class_3532.method_15393((float)((float)(class_3532.method_15349((double)dZ, (double)dX) * 57.2957763671875) - 90.0f)));
        this.method_37908().method_8421((class_1297)this, (byte)54);
        this.attackingTicks = 30;
        if (this.bulb != null) {
            this.bulb.setAngryFor(10);
            this.bulb.method_5702(class_2183.class_2184.field_9853, pos.method_46558());
        }
    }

    public float getAttackProgress(float tickDelta) {
        return (30.0f - class_3532.method_16439((float)tickDelta, (float)this.prevAttackingTicks, (float)this.attackingTicks)) / 30.0f;
    }

    public float getGrowth(float tickDelta) {
        return (float)class_3532.method_48781((float)tickDelta, (int)this.prevGrowth, (int)this.getGrowth()) / 25.0f;
    }

    public int getGrowth() {
        return (Integer)this.field_6011.method_12789(GROWTH);
    }

    public void setGrowth(int growth) {
        this.field_6011.method_12778(GROWTH, (Object)Math.max(0, growth));
    }

    public float getAnimationTimer(float tickDelta) {
        return ((float)this.field_6012 + tickDelta + (float)(this.method_5667().getMostSignificantBits() % 100L)) * 4.3E-4f + (float)class_3532.method_48781((float)tickDelta, (int)this.prevMotionOffset, (int)this.getMotionOffset()) * 0.002f;
    }

    public int getMotionOffset() {
        return (Integer)this.field_6011.method_12789(MOTION_OFFSET);
    }

    public void setMotionOffset(int motionOffset) {
        this.field_6011.method_12778(MOTION_OFFSET, (Object)motionOffset);
    }

    public boolean isAttacking() {
        return this.attackingTicks > 0;
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (player.method_5998(class_1268.field_5808).method_31573(class_3489.field_42612)) {
                this.method_5768();
                ParticleUtils.spawnParticles((class_2394)class_2398.field_11245, (class_1297)this, 10);
            }
            if (this.method_37908().field_9229.method_43048(5) == 0 && this.canTarget((class_1309)player)) {
                this.setTarget((class_1309)player);
            }
        }
        this.addActiveTicks(20 + this.method_37908().field_9229.method_43048(30));
        this.method_5783(USounds.ENTITY_TENTACLE_ROAR, 5.0f, 1.0f);
        this.hurtTime = 10;
        this.method_37908().method_8421((class_1297)this, (byte)4);
        this.method_32876((class_6880)class_5712.field_43322);
        return true;
    }

    public void addActiveTicks(int ticks) {
        this.ticksActive = Math.min(200, this.ticksActive + ticks);
    }

    public void method_5773() {
        int growth;
        this.prevMotionOffset = this.getMotionOffset();
        this.prevGrowth = growth = this.getGrowth();
        super.method_5773();
        this.prevAttackingTicks = this.attackingTicks;
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.isAttacking() && --this.attackingTicks == 12 && this.target != null) {
            if (!this.canTarget(this.target)) {
                this.target = null;
            } else {
                this.target.method_5643(this.method_48923().method_48796(class_8111.field_42360, (class_1297)this), 15.0f);
                class_243 diff = this.target.method_19538().method_1020(this.method_19538());
                this.target.method_6005(1.0, diff.field_1352, diff.field_1350);
                ParticleUtils.spawnParticles((class_2394)class_2398.field_11204, (class_1297)this.target, 10);
                for (class_1297 bystander : this.method_37908().method_8335((class_1297)this.target, this.target.method_5829().method_1014(3.0))) {
                    if (!(bystander instanceof class_1309)) continue;
                    class_1309 l = (class_1309)bystander;
                    diff = l.method_19538().method_1020(this.method_19538());
                    l.method_6005(1.0, diff.field_1352, diff.field_1350);
                    ParticleUtils.spawnParticles((class_2394)class_2398.field_11204, (class_1297)this.target, 10);
                }
            }
            this.target = null;
        }
        ParticleUtils.spawnParticles((class_2394)class_2398.field_22247, (class_1297)this, 4);
        Shape sphere = new Sphere(false, 10.0).translate(this.method_19538());
        ParticleUtils.spawnParticles(this.method_37908(), sphere, (class_2394)class_2398.field_22247, 4);
        if (!this.method_37908().field_9236) {
            if (growth >= 12) {
                if (this.field_6012 % 50 == 0) {
                    this.updateTarget();
                }
                if (this.target != null && !this.isAttacking()) {
                    this.attack(this.target.method_24515());
                }
            }
            if (growth < 25) {
                this.setGrowth(growth + 1);
                if (growth == 0) {
                    this.method_5783(USounds.ENTITY_TENTACLE_DIG, 1.0f, 1.0f);
                    this.method_32876((class_6880)class_5712.field_43308);
                }
            }
            if (this.method_37908().field_9229.method_43048(110) == 0) {
                this.method_5783(USounds.ENTITY_TENTACLE_AMBIENT, 1.0f, 0.3f);
            }
            if (this.ticksActive > 0) {
                --this.ticksActive;
                this.setMotionOffset(this.getMotionOffset() + this.ticksActive);
            }
        } else if (growth < 25 && this.field_6012 % 15 == this.method_37908().field_9229.method_43048(14)) {
            this.method_37908().method_31595(this.method_24515().method_10074(), this.method_37908().method_8320(this.method_24515().method_10074()));
        }
    }

    public void setTarget(class_1309 target) {
        this.target = target;
        this.method_5783(USounds.ENTITY_TENTACLE_ROAR, 5.0f, 1.0f);
        if (target instanceof class_1657) {
            class_1657 player = (class_1657)target;
            Pony.of(player).getMagicalReserves().getEnergy().add(6.0f);
        }
    }

    public class_1309 getTarget() {
        return this.target;
    }

    private void updateTarget() {
        if (!this.canTarget(this.target)) {
            this.target = null;
        }
        if (this.target == null && !this.isAttacking()) {
            this.method_37908().method_8390(class_1588.class, this.method_5829().method_1009(10.0, 3.0, 10.0), this::canTarget).stream().sorted(this.targetSorting).findFirst().ifPresent(this::setTarget);
        }
    }

    protected boolean canTarget(class_1309 target) {
        return target != null && target.method_36608() && target.method_33190() && !target.method_21751() && this.canSee((class_1297)target);
    }

    private boolean canSee(class_1297 entity) {
        return entity.method_37908() == this.method_37908() && this.method_5739(entity) <= 128.0f && this.method_37908().method_17742(new class_3959(this.method_19538(), entity.method_19538(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)).method_17783() == class_239.class_240.field_1333;
    }

    public void method_5711(byte status) {
        switch (status) {
            case 54: {
                this.attackingTicks = 30;
                break;
            }
            case 4: {
                this.hurtTime = 10;
                break;
            }
            default: {
                super.method_5711(status);
            }
        }
    }

    public void method_6889(class_1297 breaker) {
    }

    public void method_6894() {
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        if (this.method_37908().method_22347(this.method_24515()) && this.method_37908().method_8320(this.method_24515().method_10074()).method_26164(class_3481.field_29822)) {
            this.method_37908().method_8501(this.method_24515(), UBlocks.CURING_JOKE.method_9564());
        }
    }

    public boolean method_6888() {
        return this.method_37908().method_8515(this.method_24515().method_10074(), (class_1297)this);
    }

    public class_238 method_5830() {
        if (this.visibilityBox == null) {
            this.visibilityBox = this.method_5829().method_1009(10.0, 0.0, 10.0).method_1012(0.0, 10.0, 0.0);
        }
        return this.visibilityBox;
    }

    protected class_238 method_59943(class_2338 pos, class_2350 side) {
        this.visibilityBox = null;
        return class_238.method_30048((class_243)pos.method_10074().method_46558(), (double)1.0, (double)1.0, (double)1.0).method_1012(0.0, 2.0, 0.0);
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
    }

    public void method_5762(double deltaX, double deltaY, double deltaZ) {
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("growth", this.getGrowth());
        nbt.method_10569("motion_offset", this.getMotionOffset());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setGrowth(nbt.method_10550("growth"));
        this.setMotionOffset(nbt.method_10550("motion_offset"));
    }
}

