/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.player;

import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.client.render.PlayerPoser;
import com.minelittlepony.unicopia.entity.duck.LivingEntityDuck;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import com.minelittlepony.unicopia.util.PosHelper;
import com.minelittlepony.unicopia.util.Tickable;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5431;
import net.minecraft.class_7225;

public class Acrobatics
implements Tickable,
NbtSerialisable {
    private int ticksHanging;
    private class_2350 attachDirection;
    double distanceClimbed;
    private final Pony pony;
    private final class_1657 entity;
    private final DataTracker.Entry<Optional<class_2338>> hangingPos;

    public Acrobatics(Pony pony, DataTracker tracker) {
        this.pony = pony;
        this.entity = (class_1657)pony.asEntity();
        this.hangingPos = tracker.startTracking(TrackableDataType.OPTIONAL_POS, Optional.empty());
        pony.addTicker(this::checkDislodge);
    }

    public boolean isImmobile() {
        return this.isFloppy() && this.entity.method_24828();
    }

    public boolean isFloppy() {
        if (this.entity.method_7337() && this.entity.method_31549().field_7479) {
            return false;
        }
        return this.pony.getCompositeRace().any(Race::isFish) && !this.entity.method_5799() && !this.entity.method_37908().method_22351(PosHelper.findNearestSurface(this.entity.method_37908(), this.entity.method_24515()));
    }

    @Override
    public void tick() {
        class_2338 climbingPos = this.entity.method_24832().orElse(null);
        class_2338 hangingPos = this.pony.getPhysics().getHeadPosition();
        if (!(this.pony.getPhysics().isFlying() || this.entity.method_31549().field_7479 || climbingPos == null || this.pony.getObservedSpecies() != Race.CHANGELING || this.entity.method_55667().method_26164(class_3481.field_22414))) {
            class_243 vel = this.entity.method_18798();
            if (this.entity.method_5715()) {
                this.entity.method_18800(vel.field_1352, 0.0, vel.field_1350);
            }
            this.distanceClimbed += Math.abs(this.pony.getMotion().getClientVelocity().field_1351);
            boolean canhangHere = this.canHangAt(hangingPos);
            if (this.distanceClimbed > 1.5) {
                if (vel.method_1033() > (double)0.08f && this.entity.field_6012 % (3 + this.entity.method_59922().method_43048(5)) == 0) {
                    this.entity.method_5783(USounds.ENTITY_PLAYER_CHANGELING_CLIMB, (float)this.entity.method_59922().method_43385(0.5, 0.3), this.entity.method_6017());
                }
                boolean skipHangCheck = false;
                class_2350 newAttachDirection = this.entity.method_5735();
                if (this.isFaceClimbable(this.entity.method_37908(), this.entity.method_24515(), newAttachDirection) && newAttachDirection != this.attachDirection) {
                    this.attachDirection = newAttachDirection;
                    skipHangCheck = true;
                }
                if (!skipHangCheck && canhangHere) {
                    if (!this.isHanging()) {
                        this.startHanging(hangingPos);
                    } else {
                        if (((LivingEntityDuck)this.entity).isJumping()) {
                            return;
                        }
                        this.entity.method_18799(this.entity.method_18798().method_18805(1.0, 0.0, 1.0));
                        this.entity.method_5660(false);
                    }
                } else if (this.attachDirection != null) {
                    if (this.isFaceClimbable(this.entity.method_37908(), this.entity.method_24515(), this.attachDirection)) {
                        this.entity.method_5636(this.attachDirection.method_10144());
                        this.entity.field_6220 = this.attachDirection.method_10144();
                    } else {
                        this.entity.method_18799(vel);
                        this.entity.method_6101();
                    }
                }
            }
            if (canhangHere) {
                this.pony.setAnimation(PlayerPoser.Animation.HANG, PlayerPoser.Animation.Recipient.ANYONE);
            } else if (this.distanceClimbed > 1.5) {
                this.pony.setAnimation(PlayerPoser.Animation.CLIMB, PlayerPoser.Animation.Recipient.ANYONE);
            }
        } else {
            this.distanceClimbed = 0.0;
            this.attachDirection = null;
        }
    }

    private void checkDislodge() {
        if (this.isHanging()) {
            ((LivingEntityDuck)this.entity).setLeaningPitch(0.0f);
            if (!this.pony.isClient() && !this.canKeepHanging()) {
                this.stopHanging();
            }
        } else {
            this.ticksHanging = 0;
        }
        if (this.pony.getCompositeRace().includes(Race.SEAPONY) && !this.entity.method_5869() && this.pony.landedChanged()) {
            this.entity.method_37908().method_8396(null, this.entity.method_24515(), class_3417.field_14584, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    boolean isFaceClimbable(class_1937 world, class_2338 pos, class_2350 direction) {
        class_2680 state = world.method_8320(pos = pos.method_10093(direction));
        return !state.method_27852(class_2246.field_16492) && state.method_30368((class_1922)world, pos, direction, class_5431.field_25823);
    }

    public Optional<class_2338> getHangingPosition() {
        return this.hangingPos.get();
    }

    public boolean isHanging() {
        return this.getHangingPosition().isPresent();
    }

    public void stopHanging() {
        this.hangingPos.set(Optional.empty());
        this.entity.method_18382();
        this.ticksHanging = 0;
    }

    public void startHanging(class_2338 pos) {
        this.hangingPos.set(Optional.of(pos));
        this.entity.method_5859((double)pos.method_10263() + 0.5, (double)(pos.method_10264() + this.pony.getPhysics().getGravitySignum()), (double)pos.method_10260() + 0.5);
        this.entity.method_18799(class_243.field_1353);
        this.entity.method_5660(false);
        this.entity.method_23670();
        this.pony.getPhysics().cancelFlight(true);
    }

    public boolean canHangAt(class_2338 pos) {
        int gravity = this.pony.getPhysics().getGravitySignum() * (this.isHanging() && this.pony.getCompositeRace().includes(Race.BAT) ? -1 : 1);
        class_2680 state = this.pony.asWorld().method_8320(pos);
        if (!this.pony.asWorld().method_52569(this.pony.asEntity(), this.pony.getPhysics().getBoxAtPosition(pos.method_61082(), gravity > 0))) {
            return false;
        }
        pos = pos.method_10086(gravity);
        state = this.pony.asWorld().method_8320(pos);
        return state.method_26169((class_1922)this.pony.asWorld(), pos, (class_1297)this.entity, gravity > 0 ? class_2350.field_11036 : class_2350.field_11033);
    }

    private boolean canKeepHanging() {
        return this.pony.getCompositeRace().any(Race::canHang) && (this.ticksHanging++ <= 20 || this.getHangingPosition().filter(hangingPos -> this.pony.getCompositeRace().includes(Race.BAT) || hangingPos.method_19771((class_2382)((class_1657)this.pony.asEntity()).method_24515(), 1.5) && (!this.pony.isPosLoaded((class_2338)hangingPos) || this.canHangAt((class_2338)hangingPos))).isPresent());
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10569("ticksHanging", this.ticksHanging);
        this.getHangingPosition().ifPresent(pos -> compound.method_10566("hangingPosition", NbtSerialisable.encode(class_2338.field_25064, pos, lookup)));
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        this.ticksHanging = compound.method_10550("ticksHanging");
        this.hangingPos.set(NbtSerialisable.decode(class_2338.field_25064, compound.method_10580("hangingPosition"), lookup));
    }
}

