/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.player;

import com.minelittlepony.unicopia.FlightType;
import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.advancement.UCriteria;
import com.minelittlepony.unicopia.client.minelittlepony.MineLPDelegate;
import com.minelittlepony.unicopia.client.render.PlayerPoser;
import com.minelittlepony.unicopia.compat.ad_astra.OxygenApi;
import com.minelittlepony.unicopia.compat.trinkets.TrinketsDelegate;
import com.minelittlepony.unicopia.entity.EntityPhysics;
import com.minelittlepony.unicopia.entity.damage.MagicalDamageSource;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.duck.LivingEntityDuck;
import com.minelittlepony.unicopia.entity.effect.EffectUtils;
import com.minelittlepony.unicopia.entity.player.FlightStuntUtil;
import com.minelittlepony.unicopia.entity.player.MagicReserves;
import com.minelittlepony.unicopia.entity.player.Motion;
import com.minelittlepony.unicopia.entity.player.PlayerDimensions;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.input.Heuristic;
import com.minelittlepony.unicopia.item.AmuletItem;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.item.component.Charges;
import com.minelittlepony.unicopia.item.enchantment.EnchantmentUtil;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgPlayerFlightControlsInput;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.particle.TargetBoundParticleEffect;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.projectile.ProjectileUtil;
import com.minelittlepony.unicopia.server.world.BlockDestructionManager;
import com.minelittlepony.unicopia.server.world.ModificationType;
import com.minelittlepony.unicopia.server.world.UGameRules;
import com.minelittlepony.unicopia.server.world.WeatherConditions;
import com.minelittlepony.unicopia.util.AnimationUtil;
import com.minelittlepony.unicopia.util.Lerp;
import com.minelittlepony.unicopia.util.LimbAnimationUtil;
import com.minelittlepony.unicopia.util.MutableVector;
import com.minelittlepony.unicopia.util.PosHelper;
import com.minelittlepony.unicopia.util.RegistryUtils;
import com.minelittlepony.unicopia.util.SoundEmitter;
import com.minelittlepony.unicopia.util.Tickable;
import com.minelittlepony.unicopia.util.TraceHelper;
import com.minelittlepony.unicopia.util.VecHelper;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class PlayerPhysics
extends EntityPhysics<class_1657>
implements Tickable,
Motion,
NbtSerialisable {
    private static final int MAX_WALL_HIT_CALLDOWN = 30;
    private static final int MAX_TICKS_TO_GLIDE = 20;
    private static final int MAX_TICKS_TO_WEATHER_EFFECTS = 100;
    private static final int IDLE_FLAP_INTERVAL = 20;
    private static final int GLIDING_SOUND_INTERVAL = 200;
    private static final int LANDING_COLLISION_TIME = 3;
    private int ticksInAir;
    private int ticksToGlide;
    private int ticksDiving;
    private int ticksFlyingLow;
    private int ticksColliding;
    private float thrustScale = 0.0f;
    private float prevThrustScale;
    private boolean flapping;
    private boolean isCancelled;
    private int prevStrafe;
    private float strafe;
    private float descentRate;
    private FlightType lastFlightType = FlightType.NONE;
    public boolean isFlyingEither = false;
    public boolean isFlyingSurvival = false;
    private boolean soundPlaying;
    private int wallHitCooldown;
    @Nullable
    private class_2874 lastDimension;
    private Optional<class_243> lastPos = Optional.empty();
    private class_243 lastVel = class_243.field_1353;
    private final PlayerDimensions dimensions;
    private final Pony pony;
    private Lerp updraft = new Lerp(0.0f);
    private Lerp windStrength = new Lerp(0.0f);

    public PlayerPhysics(Pony pony, DataTracker tracker) {
        super((class_1657)pony.asEntity());
        this.pony = pony;
        this.dimensions = new PlayerDimensions(pony, this);
    }

    @Override
    public PlayerDimensions getDimensions() {
        return this.dimensions;
    }

    @Override
    public class_243 getClientVelocity() {
        return this.lastVel;
    }

    public final float getPersistantGravityModifier() {
        return super.getGravityModifier();
    }

    public float getFlapCooldown(float tickDelta) {
        float lerpedThrust = class_3532.method_16439((float)tickDelta, (float)this.prevThrustScale, (float)this.thrustScale);
        return lerpedThrust <= 1.0E-6f ? 0.0f : lerpedThrust;
    }

    @Override
    public float getGravityModifier() {
        float modifier = this.getPersistantGravityModifier();
        if (this.pony.getAcrobatics().isHanging() && this.pony.getObservedSpecies() == Race.BAT) {
            modifier *= -0.05f;
        }
        return modifier;
    }

    @Override
    public boolean isFlying() {
        return this.isFlyingSurvival && !((class_1657)this.entity).method_6128() && !((class_1657)this.entity).method_5765() && !((class_1657)this.entity).method_31549().field_7477 && !((class_1657)this.entity).method_7325();
    }

    @Override
    public boolean isGliding() {
        return this.ticksToGlide <= 0 && this.isFlying() && !this.pony.getJumpingHeuristic().getState();
    }

    @Override
    public boolean isDiving() {
        return this.ticksDiving > 0;
    }

    @Override
    public boolean isRainbooming() {
        return SpellType.RAINBOOM.isOn(this.pony);
    }

    @Override
    public float getWingAngle() {
        if (this.pony.getAnimation().isOf(PlayerPoser.Animation.SPREAD_WINGS)) {
            return AnimationUtil.seeSitSaw(this.pony.getAnimationProgress(1.0f), 1.5f);
        }
        float spreadAmount = -0.5f;
        if (this.isFlying()) {
            if (this.lastFlightType == FlightType.INSECTOID) {
                spreadAmount = (float)((double)spreadAmount + Math.sin((float)((class_1657)this.pony.asEntity()).field_6012 * 4.0f) * 8.0);
            } else if (this.isGliding()) {
                spreadAmount += MineLPDelegate.getInstance().getPlayerPonyRace((class_1657)this.entity).isEquine() ? -0.8f : 2.5f;
            } else {
                if (MineLPDelegate.getInstance().getPlayerPonyRace((class_1657)this.entity).isEquine()) {
                    spreadAmount -= 1.8f;
                }
                spreadAmount += this.strafe * 10.0f;
                spreadAmount += this.thrustScale * 24.0f;
            }
        } else {
            spreadAmount = (float)((double)spreadAmount + class_3532.method_15350((double)(-this.lastVel.field_1351), (double)-0.3f, (double)2.0));
            spreadAmount = (float)((double)spreadAmount + Math.sin((float)((class_1657)this.entity).field_6012 / 9.0f) / 9.0);
            if (((class_1657)this.entity).method_5715()) {
                spreadAmount += 2.0f;
            }
        }
        spreadAmount = class_3532.method_15363((float)spreadAmount, (float)-2.0f, (float)6.0f);
        return this.pony.getInterpolator().interpolate("wingSpreadAmount", spreadAmount, 10.0f);
    }

    public FlightType getFlightType() {
        return this.lastFlightType;
    }

    private FlightType recalculateFlightType() {
        class_2874 dimension = ((class_1657)this.entity).method_37908().method_8597();
        if ((RegistryUtils.isIn(((class_1657)this.entity).method_37908(), dimension, class_7924.field_41241, UTags.DimensionTypes.HAS_NO_ATMOSPHERE) || InteractionManager.getInstance().getSyncedConfig().dimensionsWithoutAtmosphere().contains(RegistryUtils.getId(((class_1657)this.entity).method_37908(), dimension, class_7924.field_41241).toString())) && !OxygenApi.API.get().hasOxygen(((class_1657)this.entity).method_37908(), ((class_1657)this.entity).method_24515())) {
            return FlightType.NONE;
        }
        if (AmuletItem.isApplicable((class_1309)this.entity, (class_1935)UItems.PEGASUS_AMULET)) {
            return FlightType.ARTIFICIAL;
        }
        return this.pony.getSpellSlot().get().filter(effect -> !effect.isDead() && effect instanceof FlightType.Provider).map(effect -> ((FlightType.Provider)((Object)effect)).getFlightType()).filter(FlightType::isPresent).orElse(this.pony.getCompositeRace().flightType());
    }

    public void cancelFlight(boolean force) {
        if (force) {
            this.isCancelled = true;
        }
        boolean wasFlying = this.isFlyingEither;
        ((class_1657)this.entity).method_31549().field_7479 = false;
        this.isFlyingEither = false;
        this.isFlyingSurvival = false;
        this.strafe = 0.0f;
        this.thrustScale = 0.0f;
        if (wasFlying) {
            ((class_1657)this.entity).method_18382();
        }
        this.pony.sendUpdatePacket();
    }

    public double getHorizontalMotion() {
        return this.getClientVelocity().method_37268();
    }

    @Override
    public void tick() {
        boolean startedFlyingCreative;
        boolean typeChanged;
        class_2874 dimension;
        super.tick();
        if (this.pony.isClientPlayer() && (this.pony.getJumpingHeuristic().hasChanged(Heuristic.ONCE) || this.pony.sneakingChanged())) {
            Channel.FLIGHT_CONTROLS_INPUT.sendToServer((Object)new MsgPlayerFlightControlsInput(this.pony));
        }
        this.prevThrustScale = this.thrustScale;
        if (this.wallHitCooldown > 0) {
            --this.wallHitCooldown;
        }
        if (this.ticksToGlide > 0) {
            --this.ticksToGlide;
        }
        if ((dimension = ((class_1657)this.entity).method_37908().method_8597()) != this.lastDimension) {
            this.lastDimension = dimension;
            this.lastPos = Optional.empty();
        }
        this.lastVel = this.lastPos.map(arg_0 -> ((class_243)((class_1657)this.entity).method_19538()).method_1020(arg_0)).orElse(class_243.field_1353);
        this.lastPos = Optional.of(((class_1657)this.entity).method_19538());
        MutableVector velocity = new MutableVector(((class_1657)this.entity).method_18798());
        FlightType type = this.recalculateFlightType();
        boolean bl = typeChanged = type != this.lastFlightType;
        if (typeChanged && (this.lastFlightType.isArtifical() || type.isArtifical())) {
            this.pony.spawnParticles((class_2394)class_2398.field_11204, 10);
            this.playSound(((class_1657)this.entity).method_37908().method_8597().comp_644() ? USounds.ITEM_ICARUS_WINGS_CORRUPT : USounds.ITEM_ICARUS_WINGS_PURIFY, 0.1125f, 1.5f);
        }
        this.lastFlightType = type;
        boolean creative = FlightType.canFlyCreative((class_1657)this.entity);
        boolean bl2 = startedFlyingCreative = !creative && this.isFlyingEither != ((class_1657)this.entity).method_31549().field_7479;
        if (!creative) {
            if (((class_1657)this.entity).method_24828() || this.isCancelled) {
                this.cancelFlight(false);
            }
            if (!this.pony.isClient() && type.canFly((class_1657)this.entity) && this.isFlying() && EffectUtils.hasBothBrokenWing((class_1309)this.entity) && this.ticksInAir > 90) {
                ((class_1657)this.entity).method_37908().method_43129(null, this.entity, USounds.Vanilla.field_14794, class_3419.field_15248, 2.0f, 1.0f);
                ((class_1657)this.entity).method_5643(((class_1657)this.entity).method_48923().method_48830(), 3.0f);
                this.cancelFlight(true);
            }
            if (((class_1657)this.entity).method_24828()) {
                this.isCancelled = false;
            }
            ((class_1657)this.entity).method_31549().field_7479 = ((class_1657)this.entity).method_31549().field_7479 | (this.lastFlightType.canFly((class_1657)this.entity) && this.isFlyingEither);
            if (!this.lastFlightType.canFly((class_1657)this.entity) && typeChanged) {
                ((class_1657)this.entity).method_31549().field_7479 = false;
            }
            this.ticksColliding = ((class_1657)this.entity).field_5976 || ((class_1657)this.entity).field_5992 || ((class_1657)this.entity).method_24828() ? ++this.ticksColliding : 0;
            if (((class_1657)this.entity).method_24828() && ((class_1657)this.entity).method_5715() && this.ticksColliding > 3 || ((class_1657)this.entity).method_5799() && this.ticksInAir > 20 || ((class_1657)this.entity).field_5976 || ((class_1657)this.entity).field_5992 && this.ticksColliding > 3 && (this.pony.getObservedSpecies() != Race.BAT || velocity.y < 0.0)) {
                if (((class_1657)this.entity).method_31549().field_7479 && ((class_1657)this.entity).field_5976) {
                    this.handleWallCollission(velocity);
                    return;
                }
                if (this.ticksColliding > 3 || ((class_1657)this.entity).method_5799()) {
                    this.cancelFlight(false);
                }
            }
        }
        if (this.isGravityNegative() && (((class_1657)this.entity).method_24828() || !creative && ((class_1657)this.entity).field_5976 && this.ticksColliding > 3)) {
            this.cancelFlight(false);
        }
        this.isFlyingSurvival = ((class_1657)this.entity).method_31549().field_7479 && !creative;
        boolean bl3 = this.isFlyingEither = this.isFlyingSurvival || creative && ((class_1657)this.entity).method_31549().field_7479;
        if (typeChanged || startedFlyingCreative) {
            ((class_1657)this.entity).method_18382();
        }
        if (this.lastFlightType.canFly((class_1657)this.entity)) {
            if (this.isFlying()) {
                ++this.ticksInAir;
                this.tickFlight(this.lastFlightType, velocity);
                int strafing = (int)Math.signum(((class_1657)this.entity).field_6212);
                if (strafing != this.prevStrafe) {
                    this.prevStrafe = strafing;
                    this.strafe = 1.0f;
                    this.ticksToGlide = 20;
                    if (!SpellPredicate.IS_DISGUISE.isOn(this.pony)) {
                        if (this.lastFlightType != FlightType.INSECTOID) {
                            this.playSound(this.lastFlightType.getWingFlapSound(), 0.25f, ((class_1657)this.entity).method_6017() * this.lastFlightType.getWingFlapSoundPitch());
                        }
                        ((class_1657)this.entity).method_37908().method_43275(this.entity, (class_6880)class_5712.field_28158, ((class_1657)this.entity).method_19538());
                    }
                } else {
                    this.strafe = (float)((double)this.strafe * 0.28);
                }
                if (((LivingEntityDuck)this.entity).isJumping()) {
                    velocity.y -= (double)0.2f;
                    velocity.y /= 2.0;
                }
                this.tickStunts(velocity);
            } else {
                this.tickGrounded();
                if (Abilities.RAINBOOM.canUse(this.pony.getCompositeRace()) && ((class_1657)this.entity).method_24828()) {
                    this.pony.getMagicalReserves().getCharge().set(0.0f);
                }
                if (!creative && !this.pony.isClient()) {
                    this.checkAvianTakeoffConditions(velocity);
                }
            }
        } else {
            this.tickGrounded();
        }
        float maximum = 1.5f;
        velocity.x = class_3532.method_15350((double)velocity.x, (double)(-maximum), (double)maximum);
        velocity.y = class_3532.method_15350((double)velocity.y, (double)(-maximum), (double)maximum);
        velocity.z = class_3532.method_15350((double)velocity.z, (double)(-maximum), (double)maximum);
        if (!((class_1657)this.entity).method_24828()) {
            float heavyness = EnchantmentUtil.getAirResistance((class_1309)this.entity);
            velocity.x /= (double)heavyness;
            velocity.z /= (double)heavyness;
        }
        ((class_1657)this.entity).method_18799(velocity.toImmutable());
        if (this.isFlying() && !((class_1657)this.entity).method_6128() && !this.pony.getAcrobatics().isHanging() && this.pony.isClient()) {
            float pitch;
            if (!MineLPDelegate.getInstance().getPlayerPonyRace((class_1657)this.entity).isEquine() && this.getHorizontalMotion() > 0.03 && (pitch = ((LivingEntityDuck)this.entity).getLeaningPitch()) < 1.0f) {
                if (pitch < 0.9f) {
                    pitch += 0.1f;
                }
                ((LivingEntityDuck)this.entity).setLeaningPitch(Math.max(0.0f, pitch += 0.09f));
            }
            LimbAnimationUtil.resetToZero(((class_1657)this.entity).field_42108);
        }
    }

    private void tickGrounded() {
        this.prevStrafe = 0;
        this.strafe = 0.0f;
        if (((class_1657)this.entity).method_24828()) {
            this.ticksInAir = 0;
        }
        this.wallHitCooldown = 30;
        this.soundPlaying = false;
        this.descentRate = 0.0f;
        this.ticksDiving = 0;
        this.ticksFlyingLow = 0;
        this.updraft.update(0.0f, 0L);
        this.windStrength.update(0.0f, 0L);
    }

    private void tickStunts(MutableVector velocity) {
        float verDiveScale;
        float horDiveScale;
        boolean canPerformStunts = Abilities.RAINBOOM.canUse(this.pony.getCompositeRace());
        this.ticksDiving = canPerformStunts && FlightStuntUtil.isPerformingDive(this.pony, velocity) ? this.ticksDiving + 1 : 0;
        int n = this.ticksFlyingLow = canPerformStunts && FlightStuntUtil.isFlyingLow(this.pony, velocity) ? this.ticksFlyingLow + 1 : 0;
        if (this.ticksDiving > 0) {
            horDiveScale = class_3532.method_15363((float)((float)this.ticksDiving / 100.0f), (float)0.0f, (float)10.0f);
            verDiveScale = class_3532.method_15363((float)((float)this.ticksDiving / 90.0f), (float)0.0f, (float)5.0f);
            velocity.multiply(1.0f + horDiveScale, 1.0f + verDiveScale, 1.0f + horDiveScale);
        }
        if (this.ticksFlyingLow > 0) {
            horDiveScale = class_3532.method_15363((float)((float)this.ticksFlyingLow / 1000.0f), (float)0.0f, (float)0.9f);
            verDiveScale = class_3532.method_15363((float)((float)this.ticksFlyingLow / 900.0f), (float)0.0f, (float)0.5f);
            velocity.multiply(1.0f + horDiveScale, 1.0f + verDiveScale, 1.0f + horDiveScale);
        }
        if (((class_1657)this.pony.asEntity()).field_6012 % 2 == 0) {
            if (this.ticksDiving > 0) {
                this.pony.getMagicalReserves().getCharge().addPercent(1.0f);
            }
            if (this.ticksFlyingLow > 0) {
                this.pony.getMagicalReserves().getCharge().addPercent((float)this.ticksFlyingLow / 200.0f);
            }
        }
    }

    private void tickFlight(FlightType type, MutableVector velocity) {
        if (type.isArtifical()) {
            this.tickArtificialFlight(velocity);
        } else {
            this.tickNaturalFlight(velocity);
        }
        ((class_1657)this.entity).field_6017 = 0.0f;
        if (!EffectUtils.hasABrokenWing((class_1309)this.entity) || ((class_1657)this.entity).field_6012 % 50 < 25) {
            this.applyThrust(velocity);
        } else if (((class_1657)this.entity).method_37908().field_9229.method_43048(40) == 0) {
            ((class_1657)this.entity).method_37908().method_43129(null, this.entity, USounds.Vanilla.field_14794, class_3419.field_15248, 2.0f, 1.5f);
            ((class_1657)this.entity).method_5643(((class_1657)this.entity).method_48923().method_48830(), 0.5f);
        }
        if (type.isAvian() && !((class_1657)this.entity).method_37908().field_9236 && this.pony.getObservedSpecies() != Race.BAT && ((class_1657)this.entity).method_37908().field_9229.method_43048(9000) == 0) {
            ((class_1657)this.entity).method_5706((class_1935)(this.pony.getObservedSpecies() == Race.HIPPOGRIFF ? UItems.GRYPHON_FEATHER : UItems.PEGASUS_FEATHER));
            this.playSound(USounds.ENTITY_PLAYER_PEGASUS_MOLT, 0.3f, 1.0f);
            UCriteria.SHED_FEATHER.trigger(this.entity);
        }
        this.moveFlying(velocity);
        if (((class_1657)this.entity).method_37908().field_9236 && this.ticksInAir % 20 == 0 && ((class_1657)this.entity).method_18798().method_1033() < 0.29) {
            this.flapping = true;
            this.ticksToGlide = 20;
        }
        if (type.isAvian()) {
            if (!SpellPredicate.IS_DISGUISE.isOn(this.pony) && this.pony.isClient() && this.ticksInAir % 200 == 5) {
                InteractionManager.getInstance().playLoopingSound(this.entity, 4, ((class_1657)this.entity).method_5628());
            }
        } else if (type == FlightType.INSECTOID && !SpellPredicate.IS_DISGUISE.isOn(this.pony) && ((class_1657)this.entity).method_37908().field_9236 && !this.soundPlaying) {
            this.soundPlaying = true;
            InteractionManager.getInstance().playLoopingSound(this.entity, 1, ((class_1657)this.entity).method_5628());
        }
        velocity.y -= 0.02;
        velocity.x *= 0.9896;
        velocity.z *= 0.9896;
    }

    private void tickArtificialFlight(MutableVector velocity) {
        if (this.ticksInAir % 10 == 0 && !((class_1657)this.entity).method_37908().field_9236) {
            TrinketsDelegate.EquippedStack stack = AmuletItem.get((class_1309)this.entity);
            Charges charges = Charges.of(stack.stack());
            if (charges.canHoldCharge() && charges.getPercentage() < 0.1f) {
                this.playSound(USounds.ITEM_ICARUS_WINGS_WARN, 0.13f, 0.5f);
            }
            int damageInterval = 20;
            int minDamage = 1;
            float energyConsumed = 2.0f + (float)this.getHorizontalMotion() / 10.0f;
            if (((class_1657)this.entity).method_37908().method_8520(((class_1657)this.entity).method_24515())) {
                energyConsumed *= 3.0f;
            }
            if (((class_1657)this.entity).method_37908().method_8597().comp_644()) {
                energyConsumed *= 4.0f;
                damageInterval /= 2;
                minDamage *= 3;
            }
            if (charges.canHoldCharge()) {
                Charges.discharge(stack.stack(), (int)energyConsumed);
            }
            if (((class_1657)this.entity).method_37908().field_9229.method_43048(damageInterval) == 0) {
                stack.stack().method_7956(minDamage + ((class_1657)this.entity).method_37908().field_9229.method_43048(50), (class_3218)((class_1657)this.entity).method_37908(), (class_3222)this.entity, stack.breakStatusSender());
            }
            if (!this.lastFlightType.canFly((class_1657)this.entity)) {
                this.playSound(USounds.ITEM_ICARUS_WINGS_EXHAUSTED, 1.0f, 2.0f);
                this.cancelFlight(false);
            }
        }
    }

    private void playSound(class_3414 sound, float volume, float pitch) {
        ((class_1657)this.entity).method_37908().method_43129(((class_1657)this.entity).method_37908().field_9236 ? (class_1657)this.entity : null, this.entity, sound, class_3419.field_15248, volume, pitch);
    }

    private void tickNaturalFlight(MutableVector velocity) {
        float level = this.pony.getLevel().getScaled(5.0f) + 1.0f;
        if ((float)this.ticksInAir > level * 100.0f) {
            MagicReserves.Bar mana = this.pony.getMagicalReserves().getMana();
            float cost = (float)(-this.getHorizontalMotion()) / 2.0f;
            if (((LivingEntityDuck)this.entity).isJumping()) {
                cost /= 10.0f;
            }
            mana.add(class_3532.method_15363((float)cost, (float)-100.0f, (float)0.0f));
            boolean overVoid = PosHelper.isOverVoid(this.pony.asWorld(), this.pony.getOrigin(), this.getGravitySignum());
            if (overVoid) {
                mana.addPercent(-2.0f);
            }
            float f = mana.getPercentFill();
            float f2 = overVoid ? 0.4f : 0.2f;
            if (f < f2) {
                this.pony.getMagicalReserves().getExertion().addPercent(overVoid ? 4.0f : 2.0f);
                this.pony.getMagicalReserves().getExhaustion().add((overVoid ? 4 : 0) + 2 + (int)(this.getHorizontalMotion() * 50.0));
                if ((double)mana.getPercentFill() < 0.1 && this.ticksInAir % 10 == 0) {
                    float exhaustion = 0.3f * (float)this.ticksInAir / 70.0f;
                    if (((class_1657)this.entity).method_5624()) {
                        exhaustion *= 3.11f;
                    }
                    ((class_1657)this.entity).method_7322(exhaustion);
                }
                if (this.pony.getMagicalReserves().getExhaustion().getPercentFill() > 0.99f && this.ticksInAir % 25 == 0 && !this.pony.isClient()) {
                    ((class_1657)this.entity).method_5643((class_1282)this.pony.damageOf(UDamageTypes.EXHAUSTION), (float)((class_1657)this.entity).method_37908().field_9229.method_39332(2, 4));
                    if (((class_1657)this.entity).method_37908().field_9229.method_43048(110) == 1) {
                        this.pony.getLevel().add(1);
                        if (Abilities.RAINBOOM.canUse(this.pony.getCompositeRace())) {
                            this.pony.getMagicalReserves().getCharge().addPercent(4.0f);
                        }
                        this.pony.getMagicalReserves().getExertion().set(0.0f);
                        this.pony.getMagicalReserves().getExhaustion().set(0.0f);
                        mana.set(mana.getMax() * 100.0f);
                        UCriteria.SECOND_WIND.trigger(this.entity);
                    }
                }
            }
        }
    }

    private void checkAvianTakeoffConditions(MutableVector velocity) {
        boolean fallingTakeOffCondition;
        double horMotion = this.getHorizontalMotion();
        double motion = this.lastVel.method_1027();
        boolean takeOffCondition = (horMotion > 0.05 || motion > 0.05) && this.pony.getJumpingHeuristic().hasChanged(Heuristic.TWICE);
        boolean bl = fallingTakeOffCondition = !((class_1657)this.entity).method_24828() && velocity.y < -1.6 && ((class_1657)this.entity).field_6017 > 1.0f;
        if ((takeOffCondition || fallingTakeOffCondition) && !this.pony.getAcrobatics().isHanging() && !this.isCancelled) {
            this.initiateTakeoff(velocity);
        }
    }

    private void initiateTakeoff(MutableVector velocity) {
        this.startFlying(false);
        velocity.y += this.getHorizontalMotion() + 0.3;
        this.applyThrust(velocity);
        velocity.x *= 0.2;
        velocity.z *= 0.2;
    }

    public void startFlying(boolean force) {
        if (force) {
            this.isCancelled = false;
        }
        ((class_1657)this.entity).method_31549().field_7479 = true;
        this.isFlyingEither = true;
        this.isFlyingSurvival = true;
        this.thrustScale = 0.0f;
        this.descentRate = 0.0f;
        ((class_1657)this.entity).method_18382();
        this.pony.sendUpdatePacket();
        if (((class_1657)this.entity).method_24828() || !force) {
            Supplier<class_243> pos = VecHelper.sphere(this.pony.asWorld().method_8409(), 0.5);
            Supplier<class_243> vel = VecHelper.sphere(this.pony.asWorld().method_8409(), 0.015);
            this.pony.spawnParticles((class_2394)class_2398.field_11204, pos, vel, 5);
        }
    }

    private void handleWallCollission(MutableVector velocity) {
        double motion;
        float distance;
        if (this.wallHitCooldown > 0) {
            return;
        }
        class_2338 pos = class_2338.method_49638((class_2374)((class_1657)this.entity).method_5836(1.0f).method_1019(((class_1657)this.entity).method_5828(1.0f).method_1029().method_1021(2.0)));
        class_2680 state = ((class_1657)this.entity).method_37908().method_8320(pos);
        if (!((class_1657)this.entity).method_37908().method_22347(pos) && class_2248.method_9501((class_265)state.method_26220((class_1922)((class_1657)this.entity).method_37908(), pos), (class_2350)((class_1657)this.entity).method_5735().method_10153()) && (distance = (float)((motion = Math.sqrt(this.getHorizontalMotion())) * 20.0 - 3.0)) > 0.0f) {
            this.wallHitCooldown = 30;
            float bouncyness = EnchantmentUtil.getBouncyness((class_1309)this.entity);
            if (bouncyness > 0.0f) {
                this.playSound(USounds.ENTITY_PLAYER_REBOUND, 1.0f, ((class_1657)this.entity).method_6017());
                ProjectileUtil.ricochet(this.entity, class_243.method_24954((class_2382)pos), 0.4f + Math.min(2.0f, bouncyness / 18.0f));
                velocity.fromImmutable(((class_1657)this.entity).method_18798());
                distance /= bouncyness;
            } else {
                class_1309.class_6823 fallSounds = ((class_1657)this.entity).method_39760();
                this.playSound(distance > 4.0f ? fallSounds.comp_302() : fallSounds.comp_301(), 1.0f, ((class_1657)this.entity).method_6017());
            }
            ((class_1657)this.entity).method_5643(((class_1657)this.entity).method_48923().method_48828(), distance);
        }
        ((class_1657)this.entity).method_18799(velocity.toImmutable());
        if (this.ticksColliding > 3) {
            this.cancelFlight(false);
        }
    }

    private void moveFlying(MutableVector velocity) {
        float effectChance;
        double motion = this.getHorizontalMotion();
        float forward = 1.5E-5f * (1.0f + this.pony.getLevel().getScaled(10.0f) / 10.0f) * (float)Math.sqrt(motion);
        velocity.x += (double)(-(forward += 0.005f) * class_3532.method_15374((float)(((class_1657)this.entity).method_36454() * ((float)Math.PI / 180))));
        velocity.z += (double)(forward * class_3532.method_15362((float)(((class_1657)this.entity).method_36454() * ((float)Math.PI / 180))));
        if (this.pony.isClient() && ((class_1657)this.entity).method_37908().field_9229.method_43048(1 + (int)(120.0f * (effectChance = 1.0f - (float)class_3532.method_15350((double)velocity.horizontalLengthSquared(), (double)0.0, (double)1.0)))) == 0) {
            this.pony.spawnParticles(new TargetBoundParticleEffect(UParticles.WIND, (class_1297)this.pony.asEntity()), 3);
        }
        if (((class_1657)this.entity).method_37908().method_8520(((class_1657)this.entity).method_24515())) {
            this.applyTurbulance(velocity);
        } else {
            float targetUpdraft;
            if (this.pony.isPosLoaded(((class_1657)this.entity).method_24515())) {
                targetUpdraft = WeatherConditions.THERMAL_FIELD.getValue(((class_1657)this.entity).method_37908(), new class_2338.class_2339().method_10101((class_2382)((class_1657)this.entity).method_24515())) / 3.0f;
                targetUpdraft = (float)((double)targetUpdraft * (1.0 + motion));
                if (this.isGravityNegative()) {
                    targetUpdraft *= -1.0f;
                }
            } else {
                targetUpdraft = this.updraft.getValue();
            }
            this.updraft.update(targetUpdraft, targetUpdraft > this.updraft.getTarget() ? 30000L : 3000L);
            double updraft = this.updraft.getValue();
            velocity.y += updraft;
            this.descentRate = (float)((double)this.descentRate - updraft);
        }
        this.descentRate += 0.001f;
        this.descentRate = Math.min(1.5f, this.descentRate);
        if (this.descentRate < 0.0f) {
            this.descentRate *= 0.8f;
        }
        velocity.y -= (double)this.descentRate;
    }

    private void applyThrust(MutableVector velocity) {
        boolean hovering;
        boolean manualFlap;
        boolean bl = manualFlap = this.pony.getJumpingHeuristic().hasChanged(Heuristic.ONCE) && this.pony.getJumpingHeuristic().getState();
        if (manualFlap) {
            this.flapping = true;
            this.ticksToGlide = 20;
        }
        this.thrustScale *= 0.2889f;
        boolean bl2 = hovering = ((class_1657)this.entity).method_18798().method_37267() < 0.1;
        if (this.lastFlightType == FlightType.INSECTOID) {
            this.descentRate = this.pony.getJumpingHeuristic().getState() ? -0.5f : 0.0f;
        } else if (this.thrustScale <= 1.0E-6f & this.flapping) {
            this.flapping = false;
            if (!SpellPredicate.IS_DISGUISE.isOn(this.pony)) {
                this.playSound(this.lastFlightType.getWingFlapSound(), 0.25f, ((class_1657)this.entity).method_6017() * this.lastFlightType.getWingFlapSoundPitch());
                ((class_1657)this.entity).method_37908().method_43275(this.entity, (class_6880)class_5712.field_28158, ((class_1657)this.entity).method_19538());
            }
            this.thrustScale = 1.0f;
            if (manualFlap) {
                this.descentRate = (float)((double)this.descentRate - 0.5);
            } else {
                this.descentRate *= 0.25f;
                if (velocity.y < 0.0) {
                    velocity.y *= (double)0.6f;
                }
            }
        }
        float thrustStrength = 0.235f * this.thrustScale / EnchantmentUtil.getWeight((class_1309)this.entity);
        class_243 direction = ((class_1657)this.entity).method_5828(1.0f).method_1029().method_1021((double)thrustStrength);
        if (hovering || !manualFlap) {
            velocity.y = ((class_1657)this.entity).method_5715() ? (velocity.y -= (double)0.006f) : (velocity.y *= (double)(1.0f - this.thrustScale));
        } else {
            velocity.x += direction.field_1352 * (double)1.3f;
            velocity.z += direction.field_1350 * (double)1.3f;
            velocity.y += direction.field_1351 * 2.45 + Math.abs(direction.field_1351) * 10.0;
        }
        if (velocity.y < 0.0 && hovering) {
            velocity.y *= 0.01;
        }
    }

    private void applyTurbulance(MutableVector velocity) {
        class_243 gust;
        int globalEffectStrength = ((class_1657)this.entity).method_37908().method_8450().method_8356(UGameRules.WEATHER_EFFECTS_STRENGTH);
        float effectStrength = Math.min(1.0f, (float)this.ticksInAir / 100.0f) * ((float)globalEffectStrength / 100.0f);
        if ((double)effectStrength * (gust = WeatherConditions.getGustStrength(((class_1657)this.entity).method_37908(), ((class_1657)this.entity).method_24515()).method_1021((double)globalEffectStrength / 100.0).method_1021(1.0 / (1.0 + Math.floor((float)this.pony.getLevel().get() / 10.0f)))).method_10216() >= 1.0) {
            SoundEmitter.playSoundAt(this.entity, USounds.AMBIENT_WIND_GUST, class_3419.field_15256, 3.0f, 1.0f);
        }
        float weight = EnchantmentUtil.getWindBuffetResistance((class_1309)this.entity);
        class_243 airflow = WeatherConditions.getAirflow(((class_1657)this.entity).method_24515(), ((class_1657)this.entity).method_37908()).method_1021((double)(0.04f * effectStrength)).method_1019(class_243.method_1030((float)(((class_1657)this.entity).method_36455() + (float)gust.method_10214()), (float)(((class_1657)this.entity).method_36454() + (float)gust.method_10215())).method_1021((double)(effectStrength * (float)gust.method_10216() / weight)));
        this.windStrength.update((float)airflow.method_1033(), airflow.method_1033() > (double)this.windStrength.getValue() ? 1000L : 500L);
        velocity.add(airflow.method_1029(), this.windStrength.getValue());
        if (!((class_1657)this.entity).method_37908().field_9236 && effectStrength > 0.9f && ((class_1657)this.entity).method_37908().method_8546() && ((class_1657)this.entity).method_37908().field_9229.method_43048(9000) == 0) {
            class_1538 lightning = (class_1538)class_1299.field_6112.method_5883(((class_1657)this.entity).method_37908());
            lightning.method_24203(((class_1657)this.entity).method_23317(), ((class_1657)this.entity).method_23318(), ((class_1657)this.entity).method_23321());
            ((class_1657)this.entity).method_37908().method_8649((class_1297)lightning);
            UCriteria.LIGHTNING_STRUCK.trigger(this.entity);
        }
    }

    public void updateFlightState() {
        FlightType type = this.recalculateFlightType();
        ((class_1657)this.entity).method_31549().field_7479 &= type.canFly((class_1657)this.entity);
        this.isFlyingSurvival = ((class_1657)this.entity).method_31549().field_7479;
        this.lastFlightType = type;
    }

    public void dashForward(float speed) {
        if (this.pony.isClient()) {
            return;
        }
        class_243 orientation = ((class_1657)this.entity).method_5828(1.0f).method_1021((double)speed);
        ((class_1657)this.entity).method_5762(orientation.field_1352, orientation.field_1351, orientation.field_1350);
        boolean isEarthPonySmash = this.pony.getObservedSpecies().canUseEarth() && !this.isFlying();
        int damage = TraceHelper.findBlocks(this.entity, speed + (float)(isEarthPonySmash ? 2 : 4), 1.0f, state -> isEarthPonySmash && !state.method_26215() || state.method_26164(ConventionalBlockTags.GLASS_PANES)).stream().flatMap(pos -> class_2338.method_25998((class_2338)pos, (int)2, (int)2, (int)2)).filter(pos -> isEarthPonySmash && !((class_1657)this.entity).method_37908().method_22347(pos) && pos.method_10264() >= ((class_1657)this.entity).method_31478() || ((class_1657)this.entity).method_37908().method_8320(pos).method_26164(ConventionalBlockTags.GLASS_PANES)).reduce(0, (u, pos) -> {
            if (this.pony.canModifyAt((class_2338)pos, ModificationType.PHYSICAL)) {
                if (isEarthPonySmash) {
                    float destruction = BlockDestructionManager.of(((class_1657)this.entity).method_37908()).damageBlock((class_2338)pos, (int)((class_1657)this.entity).method_37908().method_8409().method_43385(5.0, 3.0));
                    if (destruction >= 9.0f && this.pony.canModifyAt((class_2338)pos, ModificationType.PHYSICAL)) {
                        ((class_1657)this.entity).method_37908().method_22352(pos, true);
                    } else {
                        ((class_1657)this.entity).method_37908().method_20290(2001, pos, class_2248.method_9507((class_2680)((class_1657)this.entity).method_37908().method_8320(pos)));
                    }
                } else {
                    ((class_1657)this.entity).method_37908().method_22352(pos, true);
                }
            } else {
                ParticleUtils.spawnParticles(new MagicParticleEffect(43775), ((class_1657)this.entity).method_37908(), class_243.method_24953((class_2382)pos), 15);
            }
            return 1;
        }, Integer::sum);
        if (damage > 0) {
            this.pony.subtractEnergyCost((float)damage / 5.0f);
            ((class_1657)this.entity).method_5643(((class_1657)this.entity).method_48923().method_48828(), Math.min((float)damage, ((class_1657)this.entity).method_6032() - 1.0f));
            if (!isEarthPonySmash) {
                UCriteria.BREAK_WINDOW.trigger(this.entity);
            }
        }
        if (isEarthPonySmash) {
            MagicalDamageSource damageSource = this.pony.damageOf(UDamageTypes.STEAMROLLER);
            this.pony.findAllEntitiesInRange(speed + 4.0f, class_1301.field_6156.and(class_1301.field_6157)).forEach(e -> e.method_5643(damageSource, 50.0f));
        }
        this.pony.updateVelocity();
        this.pony.spawnParticles(new TargetBoundParticleEffect(UParticles.WIND, (class_1297)this.pony.asEntity()), 4);
        if (this.isFlying()) {
            this.playSound(USounds.ENTITY_PLAYER_PEGASUS_DASH, 1.0f, 1.0f);
        } else {
            this.playSound(USounds.ENTITY_PLAYER_EARTHPONY_DASH, 2.0f, 1.3f);
        }
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10556("isFlying", this.isFlyingSurvival);
        compound.method_10556("isCancelled", this.isCancelled);
        compound.method_10556("isFlyingEither", this.isFlyingEither);
        compound.method_10569("ticksInAir", this.ticksInAir);
        compound.method_10548("descentRate", this.descentRate);
        compound.method_10548("updraft", this.updraft.getValue());
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.isFlyingSurvival = compound.method_10577("isFlying");
        this.isCancelled = compound.method_10577("isCancelled");
        this.isFlyingEither = compound.method_10577("isFlyingEither");
        this.ticksInAir = compound.method_10550("ticksInAir");
        this.descentRate = compound.method_10583("descentRate");
        this.updraft.update(compound.method_10583("updraft"), 0L);
        ((class_1657)this.entity).method_18382();
    }
}

