/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.item;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_6067;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;

public class CuringJokeItem
extends class_1747 {
    static final List<Predicate<class_1309>> EFFECTS = List.of(CuringJokeItem::restoreAir, CuringJokeItem::restoreHunger, CuringJokeItem::restoreHealth, CuringJokeItem::removeEffect, CuringJokeItem::uncurseItem, CuringJokeItem::repairItem);

    public CuringJokeItem(class_2248 block, class_1792.class_1793 settings) {
        super(block, settings);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        ArrayList<Predicate<class_1309>> items = new ArrayList<Predicate<class_1309>>(EFFECTS);
        while (!items.isEmpty()) {
            if (!items.remove(world.field_9229.method_43048(items.size())).test(user)) continue;
            ParticleUtils.spawnParticles(new MagicParticleEffect(0x3388EE), (class_1297)user, 25);
            world.method_8396(null, user.method_24515(), USounds.ITEM_CURING_JOKE_CURE, user.method_5634(), 1.0f, 1.0f);
            break;
        }
        return super.method_7861(stack, world, user);
    }

    static boolean restoreAir(class_1309 user) {
        if (user.method_5669() < user.method_5748()) {
            user.method_5855(user.method_5748());
            return true;
        }
        return false;
    }

    static boolean restoreHunger(class_1309 user) {
        class_1657 player;
        if (user instanceof class_1657 && (player = (class_1657)user).method_7344().method_7586() < 20) {
            player.method_7344().method_7585(20, 0.0f);
            return true;
        }
        return false;
    }

    static boolean restoreHealth(class_1309 user) {
        if (user.method_6032() < user.method_6063()) {
            user.method_6033(user.method_6063());
            return true;
        }
        return false;
    }

    static boolean removeEffect(class_1309 user) {
        return user.method_6026().stream().filter(effect -> !((class_1291)effect.method_5579().comp_349()).method_5573()).findAny().filter(effect -> {
            user.method_6016(effect.method_5579());
            return true;
        }).isPresent();
    }

    static boolean uncurseItem(class_1309 user) {
        return CuringJokeItem.getInventory(user).filter(s -> {
            class_9304 enchantments = (class_9304)s.method_57824(class_9334.field_49633);
            return enchantments != null && enchantments.method_57534().stream().anyMatch(entry -> entry.method_40220(class_9636.field_51551));
        }).findAny().map(s -> {
            class_1890.method_57531((class_1799)s, builder -> builder.method_57548(entry -> entry.method_40220(class_9636.field_51551)));
            return s;
        }).isPresent();
    }

    static boolean repairItem(class_1309 user) {
        return CuringJokeItem.getInventory(user).filter(s -> s.method_7919() < s.method_7936()).findAny().filter(s -> {
            s.method_7974(0);
            return true;
        }).isPresent();
    }

    static Stream<class_1799> getInventory(class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return InventoryUtil.stream((class_1263)player.method_31548());
        }
        if (entity instanceof class_6067) {
            class_6067 owner = (class_6067)entity;
            return InventoryUtil.stream((class_1263)owner.method_35199());
        }
        return StreamSupport.stream(entity.method_56675().spliterator(), false);
    }
}

