/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.item;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.Owned;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.compat.trinkets.SlotKey;
import com.minelittlepony.unicopia.compat.trinkets.TrinketsDelegate;
import com.minelittlepony.unicopia.entity.AmuletSelectors;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.item.WearableItem;
import com.minelittlepony.unicopia.item.component.Issuer;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3468;
import org.jetbrains.annotations.Nullable;

public class FriendshipBraceletItem
extends WearableItem {
    private static final Predicate<class_1799> IS_BANGLE = stack -> stack.method_31574(UItems.FRIENDSHIP_BRACELET);

    public FriendshipBraceletItem(class_1792.class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!Issuer.isSigned(stack) && (EquinePredicates.PLAYER_UNICORN.test((class_1297)player) || EquinePredicates.RACE_CAN_INFLUENCE_WEATHER.test((class_1297)player) || AmuletSelectors.PEARL_NECKLACE.test((class_1309)player))) {
            player.method_6019(hand);
            class_1799 result = Issuer.set(stack.method_46651(1), (class_1297)player);
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            player.method_5783(USounds.ITEM_BRACELET_SIGN, 1.0f, 1.0f);
            if (stack.method_7960()) {
                return class_1271.method_22428((Object)result);
            }
            if (!player.method_7270(result)) {
                player.method_5775(result);
            }
            return class_1271.method_22428((Object)stack);
        }
        return super.method_7836(world, player, hand);
    }

    @Override
    public class_1304 getSlotType(class_1799 stack) {
        return Issuer.isSigned(stack) ? class_1304.field_6174 : super.getSlotType(stack);
    }

    @Nullable
    public static String getSignatorName(class_1799 stack) {
        return Issuer.getSignatorName(stack);
    }

    @Nullable
    public static UUID getSignatorId(class_1799 stack) {
        return Issuer.getSignatorId(stack);
    }

    @Deprecated
    public static boolean isSigned(class_1799 stack) {
        return Issuer.isSigned(stack);
    }

    @Deprecated
    public static boolean isSignedBy(class_1799 stack, class_1657 player) {
        return Issuer.isSignedBy(stack, player);
    }

    @Deprecated
    public static boolean isSignedBy(class_1799 stack, UUID player) {
        return Issuer.isSignedBy(stack, player);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isComrade(Owned<?> caster, class_1297 entity) {
        if (!(entity instanceof class_1309)) return false;
        class_1309 l = (class_1309)entity;
        if (!caster.getMasterId().filter(id -> FriendshipBraceletItem.getWornBangles(l).anyMatch(stack -> Issuer.isSignedBy(stack.stack(), id))).isPresent()) return false;
        return true;
    }

    public static boolean isComrade(UUID signator, class_1297 entity) {
        class_1309 l;
        return entity instanceof class_1309 && FriendshipBraceletItem.getWornBangles(l = (class_1309)entity, (class_1799 stack) -> Issuer.isSignedBy(stack, signator)).findAny().isPresent();
    }

    public static Stream<Pony> getPartyMembers(Caster<?> caster, double radius) {
        return Pony.stream(caster.findAllEntitiesInRange(radius, entity -> FriendshipBraceletItem.isComrade(caster, entity)));
    }

    public static Stream<TrinketsDelegate.EquippedStack> getWornBangles(class_1309 entity) {
        return Stream.concat(TrinketsDelegate.getInstance(entity).getEquipped(entity, TrinketsDelegate.MAIN_GLOVE, IS_BANGLE), TrinketsDelegate.getInstance(entity).getEquipped(entity, TrinketsDelegate.SECONDARY_GLOVE, IS_BANGLE));
    }

    public static Stream<TrinketsDelegate.EquippedStack> getWornBangles(class_1309 entity, @Nullable Predicate<class_1799> predicate) {
        predicate = predicate == null ? IS_BANGLE : IS_BANGLE.and(predicate);
        return Stream.concat(TrinketsDelegate.getInstance(entity).getEquipped(entity, TrinketsDelegate.MAIN_GLOVE, predicate), TrinketsDelegate.getInstance(entity).getEquipped(entity, TrinketsDelegate.SECONDARY_GLOVE, predicate));
    }

    public static Stream<TrinketsDelegate.EquippedStack> getWornBangles(class_1309 entity, SlotKey slot) {
        return TrinketsDelegate.getInstance(entity).getEquipped(entity, slot, IS_BANGLE);
    }
}

