/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.item.component;

import com.minelittlepony.unicopia.item.component.UDataComponentTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;

public record Charges(int energy, int maximum, int baseline, boolean showInTooltip) implements class_9299
{
    public static final Charges DEFAULT = new Charges(0, 0, 0, false);
    public static final Codec<Charges> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("energy").forGetter(Charges::energy), (App)Codec.INT.optionalFieldOf("maximum", (Object)0).forGetter(Charges::maximum), (App)Codec.INT.optionalFieldOf("baseline", (Object)0).forGetter(Charges::baseline), (App)Codec.BOOL.fieldOf("show_in_tooltip").forGetter(Charges::showInTooltip)).apply((Applicative)instance, Charges::new));
    public static final class_9139<ByteBuf, Charges> PACKET_CODEC = class_9139.method_56905((class_9139)class_9135.field_49675, Charges::energy, (class_9139)class_9135.field_49675, Charges::maximum, (class_9139)class_9135.field_49675, Charges::baseline, (class_9139)class_9135.field_48547, Charges::showInTooltip, Charges::new);

    public static Charges of(int initial, int maximum) {
        return new Charges(initial, maximum, initial, true);
    }

    public static Charges of(class_1799 stack) {
        return (Charges)stack.method_57825(UDataComponentTypes.CHARGES, (Object)DEFAULT);
    }

    public static boolean discharge(class_1799 stack, int energy) {
        Charges charges = Charges.of(stack);
        if (charges.energy() < energy) {
            return false;
        }
        stack.method_57379(UDataComponentTypes.CHARGES, (Object)charges.withEnergy(charges.energy() - energy));
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ChargeChangeCallback) {
            ChargeChangeCallback callback = (ChargeChangeCallback)class_17922;
            callback.onDischarge(stack);
        }
        return true;
    }

    public static boolean recharge(class_1799 stack, int energy) {
        Charges charges = Charges.of(stack);
        if (charges.energy() >= charges.maximum()) {
            return false;
        }
        stack.method_57379(UDataComponentTypes.CHARGES, (Object)charges.withEnergy(charges.energy() + energy));
        return true;
    }

    public static boolean recharge(class_1799 stack) {
        Charges charges = Charges.of(stack);
        if (charges.energy() >= charges.maximum()) {
            return false;
        }
        stack.method_57379(UDataComponentTypes.CHARGES, (Object)charges.ofDefault());
        return true;
    }

    public boolean canHoldCharge() {
        return this.maximum > 0;
    }

    public float getPercentage() {
        return this.canHoldCharge() ? (float)this.energy() / (float)this.maximum() : 0.0f;
    }

    public Charges withEnergy(int energy) {
        return new Charges(class_3532.method_15340((int)energy, (int)0, (int)this.maximum), this.maximum, this.baseline, this.showInTooltip);
    }

    public Charges ofDefault() {
        return this.withEnergy(this.baseline);
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type) {
        if (this.showInTooltip() && this.maximum() > 0) {
            tooltip.accept((class_2561)class_2561.method_43469((String)"item.unicopia.amulet.energy", (Object[])new Object[]{(int)Math.floor(this.energy()), this.maximum()}));
        }
    }

    public static interface ChargeChangeCallback {
        public void onDischarge(class_1799 var1);
    }
}

