/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.item.group;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.item.group.MultiItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public interface ItemGroupRegistry {
    public static final List<class_1792> ITEMS = new ArrayList<class_1792>();
    public static final Map<class_5321<class_1761>, Set<class_1792>> REGISTRY = new HashMap<class_5321<class_1761>, Set<class_1792>>();

    public static List<class_1799> getVariations(class_1792 item) {
        if (item instanceof MultiItem) {
            MultiItem m = (MultiItem)item;
            return m.getDefaultStacks();
        }
        return List.of(item.method_7854());
    }

    public static <T extends class_1792> T register(T item, class_5321<class_1761> group) {
        REGISTRY.computeIfAbsent(group, g -> new LinkedHashSet()).add(item);
        return item;
    }

    public static <T extends class_1792> T register(class_2960 id, T item, class_5321<class_1761> group) {
        return ItemGroupRegistry.register(ItemGroupRegistry.register(id, item), group);
    }

    public static <T extends class_1792> T register(class_2960 id, T item) {
        class_1747 bi;
        if (item instanceof class_1747 && (bi = (class_1747)item).method_7711() == null) {
            throw new NullPointerException("Registered block item did not have a block " + String.valueOf(id));
        }
        ITEMS.add(item);
        return (T)((class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)id, item));
    }

    public static class_5321<class_1761> createDynamic(String name, class_1935 icon, Supplier<Stream<class_1792>> items) {
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)Unicopia.id(name));
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)key.method_29177(), (Object)FabricItemGroup.builder().method_47317((context, entries) -> ((Stream)items.get()).forEach(item -> entries.method_45423(ItemGroupRegistry.getVariations(item)))).method_47320(() -> icon.method_8389().method_7854()).method_47321((class_2561)class_2561.method_43471((String)class_156.method_646((String)"itemGroup", (class_2960)key.method_29177()))).method_47324());
        return key;
    }

    public static class_5321<class_1761> createGroupFromTag(String name, class_6862<class_1792> tag, class_1935 icon) {
        return ItemGroupRegistry.createDynamic(name, icon, () -> class_7923.field_41178.method_40266(tag).stream().flatMap(named -> named.method_40239()).map(entry -> (class_1792)entry.comp_349()));
    }

    public static void bootstrap() {
        REGISTRY.forEach((group, items) -> ItemGroupEvents.modifyEntriesEvent((class_5321)group).register(event -> event.method_45423(items.stream().map(class_1792::method_7854).toList())));
    }
}

