/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.mixin;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.entity.Equine;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.duck.EntityDuck;
import com.minelittlepony.unicopia.entity.duck.LavaAffine;
import com.minelittlepony.unicopia.network.track.DataTrackerManager;
import com.minelittlepony.unicopia.network.track.Trackable;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
abstract class MixinEntity
implements EntityDuck,
Trackable {
    @Nullable
    private transient Caster<?> host;
    private DataTrackerManager dataTrackerManager;

    MixinEntity() {
    }

    @Override
    @Nullable
    public Caster<?> getHost() {
        return this.host;
    }

    @Override
    public void setHost(Caster<?> host) {
        this.host = host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTrackerManager getDataTrackers() {
        MixinEntity mixinEntity = this;
        synchronized (mixinEntity) {
            if (this.dataTrackerManager == null) {
                this.dataTrackerManager = new DataTrackerManager((class_1297)this);
                MixinEntity mixinEntity2 = this;
                if (mixinEntity2 instanceof Equine.Container) {
                    Equine.Container eq = (Equine.Container)((Object)mixinEntity2);
                    eq.get();
                }
            }
            return this.dataTrackerManager;
        }
    }

    @Override
    @Accessor(value="submergedFluidTag")
    public abstract Set<class_6862<class_3611>> getSubmergedFluidTags();

    @Override
    @Accessor
    public abstract void setRemovalReason(class_1297.class_5529 var1);

    @Override
    @Accessor
    public abstract void setVehicle(class_1297 var1);

    @Override
    @Accessor
    public abstract float getNextStepSoundDistance();

    @Override
    public boolean isLavaAffine() {
        LavaAffine affine;
        class_1297 class_12972;
        class_1297 self = (class_1297)this;
        return self.method_5765() && (class_12972 = self.method_5854()) instanceof LavaAffine && (affine = (LavaAffine)class_12972).isLavaAffine();
    }

    @Inject(method={"isFireImmune"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsFireImmune(CallbackInfoReturnable<Boolean> info) {
        Equine.Container c;
        MixinEntity mixinEntity;
        if (this.isLavaAffine() || (mixinEntity = this) instanceof Equine.Container && (c = (Equine.Container)((Object)mixinEntity)).get().getCompositeRace().includes(Race.KIRIN)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isSneaky"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsSneaky(CallbackInfoReturnable<Boolean> info) {
        if (EquinePredicates.PLAYER_KIRIN.test((class_1297)this) && !EquinePredicates.RAGING.test((class_1297)this)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getMaxAir"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetMaxAir(CallbackInfoReturnable<Integer> info) {
        if (EquinePredicates.PLAYER_KIRIN.test((class_1297)this)) {
            info.setReturnValue((Object)150);
        }
    }

    @Inject(method={"doesRenderOnFire"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDoesRenderOnFire(CallbackInfoReturnable<Boolean> info) {
        if (EquinePredicates.RAGING.test((class_1297)this)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"updatePassengerPosition(Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/Entity$PositionUpdater;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void updatePassengerPosition(class_1297 passenger, class_1297.class_4738 positionUpdater, CallbackInfo info) {
        if (Living.getOrEmpty((class_1297)this).filter(l -> l.onUpdatePassengerPosition(passenger, positionUpdater)).isPresent()) {
            info.cancel();
        }
    }

    @Inject(method={"dropStack(Lnet/minecraft/item/ItemStack;F)Lnet/minecraft/entity/ItemEntity;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDropStack(class_1799 stack, float yOffset, CallbackInfoReturnable<class_1542> info) {
        if (this.getHost() != null) {
            info.setReturnValue(null);
        }
    }

    @Inject(method={"move"}, at={@At(value="HEAD")})
    private void beforeMove(class_1313 movementType, class_243 movement, CallbackInfo info) {
        Living<class_1297> living = Living.living((class_1297)this);
        if (living != null) {
            living.getTransportation().updatePreviousPosition();
        }
    }

    @Inject(method={"move"}, at={@At(value="RETURN")})
    private void afterMove(class_1313 movementType, class_243 movement, CallbackInfo info) {
        Living<class_1297> living = Living.living((class_1297)this);
        if (living != null) {
            living.getTransportation().onMove(movementType);
        }
    }
}

