/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.mixin.gravity;

import com.minelittlepony.unicopia.entity.Equine;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class}, priority=29000)
abstract class MixinEntity {
    @Shadow
    private class_2338 field_22468;

    MixinEntity() {
    }

    @Inject(method={"getFinalGravity"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyGravity(CallbackInfoReturnable<Double> info) {
        MixinEntity mixinEntity = this;
        if (mixinEntity instanceof Equine.Container) {
            Equine.Container eq = (Equine.Container)((Object)mixinEntity);
            info.setReturnValue((Object)Math.abs(eq.get().getPhysics().calcGravity((Double)info.getReturnValue())));
        }
    }

    @Inject(method={"setPos"}, at={@At(value="FIELD", target="net/minecraft/entity/Entity.blockPos:Lnet/minecraft/util/math/BlockPos;", opcode=181, shift=At.Shift.AFTER, ordinal=0)})
    private void onUpdateBlockPos(double x, double y, double z, CallbackInfo info) {
        Equine.Container eq;
        MixinEntity mixinEntity = this;
        if (mixinEntity instanceof Equine.Container && (eq = (Equine.Container)((Object)mixinEntity)).get().getPhysics().isGravityNegative()) {
            this.field_22468 = eq.get().getPhysics().getHeadPosition();
        }
    }

    @ModifyVariable(method={"move"}, at=@At(value="HEAD"), argsOnly=true)
    private class_243 modifyMovement(class_243 movement) {
        return this.unicopiaIsGravityInverted() ? movement.method_18805(1.0, -1.0, 1.0) : movement;
    }

    @Inject(method={"move"}, at={@At(value="FIELD", target="net/minecraft/entity/Entity.groundCollision:Z", shift=At.Shift.AFTER, ordinal=0)})
    private void onUpdateOnGroundFlag(class_1313 movementType, class_243 movement, CallbackInfo info) {
        if (this.unicopiaIsGravityInverted()) {
            ((class_1297)this).field_36331 = ((class_1297)this).field_5992 && movement.field_1351 > 0.0;
        }
    }

    @ModifyVariable(method={"getPosWithYOffset"}, at=@At(value="HEAD"), argsOnly=true)
    private float onGetPosWithYOffset(float offset) {
        return this.unicopiaIsGravityInverted() ? -(((class_1297)this).method_17682() + offset) : offset;
    }

    @ModifyArg(method={"spawnSprintingParticles"}, at=@At(value="INVOKE", target="net/minecraft/world/World.addParticle(Lnet/minecraft/particle/ParticleEffect;DDDDDD)V"), index=2)
    private double modifyParticleY(double y) {
        return this.unicopiaIsGravityInverted() ? (double)((class_1297)this).method_17682() - y + ((class_1297)this).method_23318() * 2.0 : y;
    }

    @ModifyArg(method={"move"}, at=@At(value="INVOKE", target="net/minecraft/entity/Entity.fall(DZLnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;)V"))
    private double modifyFallDistance(double heightDifference) {
        return this.unicopiaIsGravityInverted() ? -heightDifference : heightDifference;
    }

    @ModifyVariable(method={"adjustMovementForCollisions(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Box;Lnet/minecraft/world/World;Ljava/util/List;)Lnet/minecraft/util/math/Vec3d;"}, at=@At(value="HEAD"), argsOnly=true)
    private static class_243 modifyMovementForStepheight(class_243 movement, @Nullable class_1297 entity) {
        Equine.Container eq;
        if (entity instanceof Equine.Container && (eq = (Equine.Container)entity).get().getPhysics().isGravityNegative() && movement.method_10214() == (double)entity.method_49476()) {
            return movement.method_18805(1.0, -1.0, 1.0);
        }
        return movement;
    }

    @Inject(method={"calculateBoundingBox"}, at={@At(value="RETURN")}, cancellable=true)
    private void adjustPoseBoxForGravity(CallbackInfoReturnable<class_238> info) {
        if (this.unicopiaIsGravityInverted()) {
            class_1297 self = (class_1297)this;
            class_238 box = (class_238)info.getReturnValue();
            class_238 oldBox = self.method_5829();
            double newHeight = box.method_17940();
            if (newHeight > oldBox.method_17940()) {
                double targetMaxY = oldBox.field_1325;
                class_243 min = new class_243(box.field_1323, targetMaxY - newHeight, box.field_1321);
                class_243 max = new class_243(box.field_1320, targetMaxY, box.field_1324);
                box = new class_238(min, max);
                info.setReturnValue((Object)box);
                self.method_23327(self.method_23317(), box.field_1322, self.method_23321());
            }
        }
    }

    @Unique
    private boolean unicopiaIsGravityInverted() {
        Equine.Container eq;
        MixinEntity mixinEntity = this;
        return mixinEntity instanceof Equine.Container && (eq = (Equine.Container)((Object)mixinEntity)).get().getPhysics().isGravityNegative();
    }
}

