/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.network.handler;

import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.data.Rot;
import com.minelittlepony.unicopia.ability.data.tree.TreeTypes;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.client.ClientBlockDestructionManager;
import com.minelittlepony.unicopia.client.DiscoveryToast;
import com.minelittlepony.unicopia.client.UnicopiaClient;
import com.minelittlepony.unicopia.client.gui.TribeSelectionScreen;
import com.minelittlepony.unicopia.client.gui.spellbook.ClientChapters;
import com.minelittlepony.unicopia.diet.PonyDiets;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.entity.player.SkinFeatures;
import com.minelittlepony.unicopia.item.TotemOfDying;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgBlockDestruction;
import com.minelittlepony.unicopia.network.MsgCancelPlayerAbility;
import com.minelittlepony.unicopia.network.MsgCasterLookRequest;
import com.minelittlepony.unicopia.network.MsgConfigurationChange;
import com.minelittlepony.unicopia.network.MsgEntityStatus;
import com.minelittlepony.unicopia.network.MsgPlayerAnimationChange;
import com.minelittlepony.unicopia.network.MsgServerResources;
import com.minelittlepony.unicopia.network.MsgSkyAngle;
import com.minelittlepony.unicopia.network.MsgTribeSelect;
import com.minelittlepony.unicopia.network.MsgTrinketBroken;
import com.minelittlepony.unicopia.network.MsgUnlockTraits;
import com.minelittlepony.unicopia.network.MsgZapAppleStage;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_437;

public class ClientNetworkHandlerImpl {
    private final class_310 client = class_310.method_1551();

    public ClientNetworkHandlerImpl() {
        Channel.SERVER_SELECT_TRIBE.receiver().addPersistentListener(this::handleTribeScreen);
        Channel.SERVER_BLOCK_DESTRUCTION.receiver().addPersistentListener(this::handleBlockDestruction);
        Channel.CANCEL_PLAYER_ABILITY.receiver().addPersistentListener(this::handleCancelAbility);
        Channel.UNLOCK_TRAITS.receiver().addPersistentListener(this::handleUnlockTraits);
        Channel.SERVER_RESOURCES.receiver().addPersistentListener(this::handleServerResources);
        Channel.SERVER_SKY_ANGLE.receiver().addPersistentListener(this::handleSkyAngle);
        Channel.SERVER_ZAP_STAGE.receiver().addPersistentListener(this::handleZapStage);
        Channel.SERVER_PLAYER_ANIMATION_CHANGE.receiver().addPersistentListener(this::handlePlayerAnimation);
        Channel.SERVER_REQUEST_PLAYER_LOOK.receiver().addPersistentListener(this::handleCasterLookRequest);
        Channel.SERVER_TRINKET_BROKEN.receiver().addPersistentListener(this::handleTrinketBroken);
        Channel.CONFIGURATION_CHANGE.receiver().addPersistentListener(this::handleConfigurationChange);
        Channel.ENTITY_STATUS.receiver().addPersistentListener(this::handleEntityStatus);
    }

    private void handleTribeScreen(class_1657 sender, MsgTribeSelect packet) {
        this.client.method_1507((class_437)new TribeSelectionScreen(packet.availableRaces(), packet.serverMessage()));
    }

    private void handleBlockDestruction(class_1657 sender, MsgBlockDestruction packet) {
        ClientBlockDestructionManager destr = ((ClientBlockDestructionManager.Source)this.client.field_1769).getDestructionManager();
        packet.destructions().forEach((i, d) -> destr.setBlockDestruction((long)i, d.floatValue()));
    }

    private void handleEntityStatus(class_1657 sender, MsgEntityStatus status) {
        Living.getOrEmpty(sender.method_37908().method_8469(status.entityId())).ifPresent(living -> {
            if (status.status() == 1) {
                this.client.field_1713.method_3051(living.asEntity(), (class_2394)class_2398.field_11220, 30);
                living.asWorld().method_8486(living.asEntity().method_23317(), living.asEntity().method_23318(), living.asEntity().method_23321(), class_3417.field_14931, living.asEntity().method_5634(), 1.0f, 1.0f, false);
                if (living.asEntity() == this.client.field_1724) {
                    class_1799 totem = TotemOfDying.getTotem((class_1309)this.client.field_1724, false);
                    this.client.field_1773.method_3189(totem.method_7960() ? UItems.TOTEM_OF_DYING.method_7854() : totem);
                }
            }
        });
    }

    private void handleCancelAbility(class_1657 sender, MsgCancelPlayerAbility packet) {
        this.client.field_1724.method_5783(USounds.GUI_ABILITY_FAIL, 1.0f, 1.0f);
        Pony.of((class_1657)this.client.field_1724).getAbilities().getStats().forEach(s -> s.setCooldown(0));
    }

    private void handleUnlockTraits(class_1657 sender, MsgUnlockTraits packet) {
        for (Trait trait : packet.traits()) {
            DiscoveryToast.show(this.client.method_1566(), trait.getSprite());
        }
    }

    private void handleSkyAngle(class_1657 sender, MsgSkyAngle packet) {
        UnicopiaClient.getInstance().tangentalSkyAngle.update(packet.tangentalSkyAngle(), 200L);
    }

    private void handleZapStage(class_1657 sender, MsgZapAppleStage packet) {
        UnicopiaClient.getInstance().setZapAppleStage(packet.stage());
    }

    private void handleServerResources(class_1657 sender, MsgServerResources packet) {
        SpellTraits.load(packet.traits());
        ClientChapters.load(packet.chapters());
        TreeTypes.load(packet.treeTypes());
        PonyDiets.load(packet.diets());
        Pony.of(sender).setSkinFeatures((SkinFeatures)Unicopia.getConfig().skinFeatures.get());
    }

    private void handlePlayerAnimation(class_1657 sender, MsgPlayerAnimationChange packet) {
        Pony player = Pony.of(class_310.method_1551().field_1687.method_18470(packet.playerId()));
        if (player == null) {
            return;
        }
        player.setAnimation(packet.animation(), packet.duration());
    }

    private void handleCasterLookRequest(class_1657 sender, MsgCasterLookRequest packet) {
        Pony player = Pony.of((class_1657)class_310.method_1551().field_1724);
        if (player == null) {
            return;
        }
        Channel.CLIENT_CASTER_LOOK.sendToServer((Object)new MsgCasterLookRequest.Reply(packet.spellId(), Rot.of(player)));
    }

    private void handleTrinketBroken(class_1657 player, MsgTrinketBroken packet) {
        class_1297 class_12972 = player.method_37908().method_8469(packet.entityId());
        if (class_12972 instanceof class_1309) {
            class_1309 sender = (class_1309)class_12972;
            class_1799 stack = packet.stack();
            if (!stack.method_7960()) {
                if (!sender.method_5701()) {
                    sender.method_37908().method_8486(sender.method_23317(), sender.method_23318(), sender.method_23321(), class_3417.field_15075, sender.method_5634(), 0.8f, 0.8f + sender.method_37908().field_9229.method_43057() * 0.4f, false);
                }
                int count = 5;
                for (int i = 0; i < count; ++i) {
                    class_243 vec3d = new class_243(((double)sender.method_37908().field_9229.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                    vec3d = vec3d.method_1037(-sender.method_36455() * ((float)Math.PI / 180));
                    vec3d = vec3d.method_1024(-sender.method_36454() * ((float)Math.PI / 180));
                    double d = (double)(-sender.method_37908().field_9229.method_43057()) * 0.6 - 0.3;
                    class_243 vec3d2 = new class_243(((double)sender.method_37908().field_9229.method_43057() - 0.5) * 0.3, d, 0.6);
                    vec3d2 = vec3d2.method_1037(-sender.method_36455() * ((float)Math.PI / 180));
                    vec3d2 = vec3d2.method_1024(-sender.method_36454() * ((float)Math.PI / 180));
                    vec3d2 = vec3d2.method_1031(sender.method_23317(), sender.method_23320(), sender.method_23321());
                    sender.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, stack), vec3d2.field_1352, vec3d2.field_1351, vec3d2.field_1350, vec3d.field_1352, vec3d.field_1351 + 0.05, vec3d.field_1350);
                }
            }
        }
    }

    private void handleConfigurationChange(class_1657 sender, MsgConfigurationChange packet) {
        InteractionManager.getInstance().setSyncedConfig(packet.config());
    }
}

