/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.projectile;

import com.minelittlepony.unicopia.Affinity;
import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.ability.magic.Affine;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.Levelled;
import com.minelittlepony.unicopia.ability.magic.SpellInventory;
import com.minelittlepony.unicopia.ability.magic.SpellSlots;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.block.state.StatePredicate;
import com.minelittlepony.unicopia.entity.EntityPhysics;
import com.minelittlepony.unicopia.entity.MagicImmune;
import com.minelittlepony.unicopia.entity.Physics;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class MagicBeamEntity
extends MagicProjectileEntity
implements Caster<MagicBeamEntity>,
MagicImmune {
    private static final class_2940<Boolean> HYDROPHOBIC = class_2945.method_12791(MagicBeamEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> LEVEL = class_2945.method_12791(MagicBeamEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MAX_LEVEL = class_2945.method_12791(MagicBeamEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> CORRUPTION = class_2945.method_12791(MagicBeamEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MAX_CORRUPTION = class_2945.method_12791(MagicBeamEntity.class, (class_2941)class_2943.field_13327);
    private final SpellInventory spells = SpellSlots.ofSingle(this);
    private final EntityPhysics<MagicProjectileEntity> physics = new EntityPhysics<MagicBeamEntity>(this);
    private final Levelled.LevelStore level = Levelled.of(() -> (Integer)this.field_6011.method_12789(LEVEL), l -> this.field_6011.method_12778(LEVEL, (Object)l), () -> (Integer)this.field_6011.method_12789(MAX_LEVEL));
    private final Levelled.LevelStore corruption = Levelled.of(() -> (Integer)this.field_6011.method_12789(CORRUPTION), l -> this.field_6011.method_12778(CORRUPTION, (Object)l), () -> (Integer)this.field_6011.method_12789(MAX_CORRUPTION));

    public MagicBeamEntity(class_1299<MagicBeamEntity> type, class_1937 world) {
        super(type, world);
    }

    public MagicBeamEntity(class_1937 world, class_1297 owner, float divergance, Spell spell) {
        super(UEntities.MAGIC_BEAM, world);
        this.method_5814(owner.method_23317(), owner.method_23320() - (double)0.1f, owner.method_23321());
        this.method_7432(owner);
        this.method_24919(owner, owner.method_36455(), owner.method_36454(), 0.0f, 1.5f, divergance);
        this.method_5875(true);
        spell.apply(this);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HYDROPHOBIC, (Object)false).method_56912(LEVEL, (Object)0).method_56912(CORRUPTION, (Object)0).method_56912(MAX_LEVEL, (Object)1).method_56912(MAX_CORRUPTION, (Object)1);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_24921() != null) {
            this.spells.tick(Situation.PROJECTILE);
        }
        if (this.getHydrophobic() && StatePredicate.isFluid(this.method_37908().method_8320(this.method_24515()))) {
            class_243 vel = this.method_18798();
            double velY = vel.field_1351;
            velY *= -1.0;
            if (!this.method_5740()) {
                velY += 0.16;
            }
            this.method_18799(new class_243(vel.field_1352, velY, vel.field_1350));
        }
    }

    public void setHydrophobic() {
        this.method_5841().method_12778(HYDROPHOBIC, (Object)true);
    }

    public boolean getHydrophobic() {
        return (Boolean)this.method_5841().method_12789(HYDROPHOBIC);
    }

    @Override
    public MagicBeamEntity asEntity() {
        return this;
    }

    @Override
    public void method_7432(@Nullable class_1297 entity) {
        super.method_7432(entity);
        Caster.of(entity).ifPresent(caster -> {
            this.field_6011.method_12778(LEVEL, (Object)caster.getLevel().get());
            this.field_6011.method_12778(MAX_LEVEL, (Object)caster.getLevel().getMax());
            this.field_6011.method_12778(CORRUPTION, (Object)caster.getCorruption().get());
            this.field_6011.method_12778(MAX_CORRUPTION, (Object)caster.getCorruption().getMax());
        });
    }

    @Override
    public Levelled.LevelStore getLevel() {
        return this.level;
    }

    @Override
    public Levelled.LevelStore getCorruption() {
        return this.corruption;
    }

    @Override
    public Physics getPhysics() {
        return this.physics;
    }

    @Override
    public Affinity getAffinity() {
        return this.getSpellSlot().get().map(Affine::getAffinity).orElse(Affinity.NEUTRAL);
    }

    @Override
    public SpellSlots getSpellSlot() {
        return this.spells.getSlots();
    }

    @Override
    public boolean subtractEnergyCost(double amount) {
        return Caster.of(this.getMaster()).filter(c -> c.subtractEnergyCost(amount)).isPresent();
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        InteractionManager.getInstance().playLoopingSound((class_1297)this, 5, this.method_5628());
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        this.getSpellSlot().clear();
    }

    @Override
    protected <T extends ProjectileDelegate> void forEachDelegates(Consumer<T> consumer, Function<Object, T> predicate) {
        this.spells.tick(spell -> {
            Optional.ofNullable((ProjectileDelegate)predicate.apply(spell)).ifPresent(consumer);
            return SpellInventory.Operation.SKIP;
        });
        super.forEachDelegates(consumer, predicate);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.method_5841().method_12778(HYDROPHOBIC, (Object)compound.method_10577("hydrophobic"));
        this.physics.fromNBT(compound, (class_7225.class_7874)this.method_56673());
        this.spells.getSlots().fromNBT(compound, (class_7225.class_7874)this.method_56673());
        Levelled.LevelStore level = NbtSerialisable.decode(Levelled.CODEC, compound.method_10580("level"), (class_7225.class_7874)this.method_56673()).orElse(Levelled.ZERO);
        this.field_6011.method_12778(MAX_LEVEL, (Object)level.getMax());
        this.field_6011.method_12778(LEVEL, (Object)level.get());
        Levelled.LevelStore corruption = NbtSerialisable.decode(Levelled.CODEC, compound.method_10580("corruption"), (class_7225.class_7874)this.method_56673()).orElse(Levelled.ZERO);
        this.field_6011.method_12778(MAX_CORRUPTION, (Object)corruption.getMax());
        this.field_6011.method_12778(CORRUPTION, (Object)corruption.get());
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10566("level", NbtSerialisable.encode(Levelled.CODEC, this.level, (class_7225.class_7874)this.method_56673()));
        compound.method_10566("corruption", NbtSerialisable.encode(Levelled.CODEC, this.corruption, (class_7225.class_7874)this.method_56673()));
        compound.method_10556("hydrophobic", this.getHydrophobic());
        this.physics.toNBT(compound, (class_7225.class_7874)this.method_56673());
        this.spells.getSlots().toNBT(compound, (class_7225.class_7874)this.method_56673());
    }
}

