/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.projectile;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.item.UItems;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3856;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8109;
import net.minecraft.class_8110;
import org.jetbrains.annotations.Nullable;

public class PhysicsBodyProjectileEntity
extends class_1665
implements class_3856 {
    private static final class_2940<class_1799> ITEM = class_2945.method_12791(PhysicsBodyProjectileEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Boolean> BOUNCY = class_2945.method_12791(PhysicsBodyProjectileEntity.class, (class_2941)class_2943.field_13323);
    private int inWaterTime;
    private class_5321<class_8110> damageType = UDamageTypes.ROCK;

    public PhysicsBodyProjectileEntity(class_1299<PhysicsBodyProjectileEntity> type, class_1937 world, class_1799 stack) {
        super(type, 0.0, 0.0, 0.0, world, stack, null);
        this.method_57313(stack);
    }

    public PhysicsBodyProjectileEntity(class_1937 world, class_1799 stack) {
        this(UEntities.MUFFIN, world, stack);
    }

    public PhysicsBodyProjectileEntity(class_1937 world, @Nullable class_1309 thrower, class_1799 stack) {
        super(UEntities.MUFFIN, thrower, world, stack, null);
        this.method_57313(stack);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ITEM, (Object)class_1799.field_8037).method_56912(BOUNCY, (Object)false);
    }

    public void method_57313(class_1799 stack) {
        this.method_5841().method_12778(ITEM, (Object)(stack.method_7960() ? this.method_57314() : stack.method_7972()));
        super.method_57313(stack);
    }

    public class_1799 method_7495() {
        return (class_1799)this.method_5841().method_12789(ITEM);
    }

    protected class_1799 method_57314() {
        return UItems.MUFFIN.method_7854();
    }

    public void setDamageType(class_5321<class_8110> damageType) {
        this.damageType = damageType;
    }

    protected class_1799 method_7445() {
        return this.method_7495().method_7972();
    }

    public class_1799 method_54759() {
        return this.method_7495();
    }

    public void setBouncy() {
        this.method_5841().method_12778(BOUNCY, (Object)true);
    }

    public boolean isBouncy() {
        return (Boolean)this.method_5841().method_12789(BOUNCY);
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_7588) {
            class_243 vel = this.method_18798();
            vel = vel.method_18805(0.0, 1.0, 0.0);
            this.method_5784(class_1313.field_6308, vel);
            this.method_18799(vel.method_1021(0.3));
            this.method_5762(0.0, -0.025, 0.0);
        }
        if (this.isBouncy() && this.method_5816()) {
            this.method_18799(this.method_18798().method_1021(0.3).method_1031(0.0, 0.05125, 0.0));
            ++this.inWaterTime;
        } else {
            this.inWaterTime = 0;
        }
    }

    public void method_5694(class_1657 player) {
        if (this.method_37908().field_9236 || this.method_7441() || this.field_7574 > 0) {
            return;
        }
        if (this.inWaterTime <= 0) {
            super.method_5694(player);
        } else if (this.method_34713(player)) {
            player.method_6103((class_1297)this, 1);
            this.method_31472();
        }
    }

    protected void method_7454(class_3966 hit) {
        class_1937 class_19372;
        if (this.isBouncy()) {
            this.method_18799(this.method_18798().method_18805(-0.1, -0.3, -0.1));
            this.method_36456(this.method_36454() + 180.0f);
            this.field_5982 += 180.0f;
            return;
        }
        class_1799 stack = this.method_7445();
        if (stack.method_31573(UTags.Items.HORSE_SHOES) && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 sw = (class_3218)class_19372;
            stack.method_7956(1 + this.field_5974.method_43048(10), sw, null, i -> this.method_5783(USounds.Vanilla.field_15075, 1.0f, 1.0f));
            if (!stack.method_7960()) {
                this.method_5775(stack);
            }
            this.method_31472();
        }
        super.method_7454(hit);
    }

    public class_8109 method_48923() {
        return new class_8109(this.method_56673()){

            public class_1282 method_48803(class_1665 source, @Nullable class_1297 attacker) {
                return this.method_48797(PhysicsBodyProjectileEntity.this.damageType, (class_1297)source, attacker);
            }
        };
    }

    protected void method_24920(class_3965 hit) {
        class_2586 e;
        class_2248 class_22482;
        class_1657 p;
        class_1657 player;
        class_2338 buttonPos = hit.method_17777().method_10093(hit.method_17780());
        class_2680 state = this.method_37908().method_8320(buttonPos);
        class_1297 class_12972 = this.method_24921();
        class_1657 class_16572 = player = class_12972 instanceof class_1657 ? (p = (class_1657)class_12972) : null;
        if (state.method_26164(class_3481.field_15499) && (class_22482 = state.method_26204()) instanceof class_2269) {
            class_2269 button = (class_2269)class_22482;
            button.method_21845(state, this.method_37908(), buttonPos, player);
        } else {
            class_22482 = state.method_26204();
            if (class_22482 instanceof class_2401) {
                class_2401 lever = (class_2401)class_22482;
                lever.method_21846(state, this.method_37908(), buttonPos, player);
            }
        }
        class_2338 belowPos = buttonPos.method_10074();
        class_2680 below = this.method_37908().method_8320(belowPos);
        class_1799 stack = this.method_7495();
        if (below.method_26204() instanceof class_2377 && (e = this.method_37908().method_8321(belowPos)) instanceof class_1263) {
            class_1263 inventory = (class_1263)e;
            for (int i2 = 0; i2 < inventory.method_5439(); ++i2) {
                class_1799 slotStack = inventory.method_5438(i2);
                if (slotStack.method_7960()) {
                    inventory.method_5447(i2, stack);
                    this.method_31472();
                    break;
                }
                if (!class_1799.method_31577((class_1799)slotStack, (class_1799)stack) || slotStack.method_7947() >= slotStack.method_7914()) continue;
                slotStack.method_7933(1);
                this.method_31472();
                break;
            }
        }
        if (this.method_18798().method_1033() > (double)0.2f) {
            boolean ownerCanModify;
            boolean bl = ownerCanModify = !this.method_37908().field_9236 && Caster.of(this.method_24921()).filter(pony -> pony.canModifyAt(hit.method_17777())).isPresent();
            if (ownerCanModify && this.method_37908().method_8450().method_8355(class_1928.field_19388) && (!this.isBouncy() || this.method_37908().field_9229.method_43048(200) == 0) && this.method_37908().method_8320(hit.method_17777()).method_26164(UTags.Blocks.FRAGILE)) {
                this.method_37908().method_22352(hit.method_17777(), true);
            }
            if (this.isBouncy()) {
                class_2350.class_2351 side = hit.method_17780().method_10166();
                double randomisation = (this.method_37908().field_9229.method_43057() - 0.5f) / 5.0f;
                double inflectionAmount = randomisation + -0.4;
                double deflectionAmount = randomisation + 0.3;
                if (side == class_2350.class_2351.field_11048) {
                    this.method_18799(this.method_18798().method_18805(inflectionAmount, deflectionAmount, deflectionAmount));
                }
                if (side == class_2350.class_2351.field_11052) {
                    this.method_18799(this.method_18798().method_18805(deflectionAmount, inflectionAmount, deflectionAmount));
                }
                if (side == class_2350.class_2351.field_11051) {
                    this.method_18799(this.method_18798().method_18805(deflectionAmount, deflectionAmount, inflectionAmount));
                }
                this.method_5762((this.method_37908().field_9229.method_43057() - 0.5f) / 5.0f, (this.method_37908().field_9229.method_43057() - 0.5f) / 5.0f, (this.method_37908().field_9229.method_43057() - 0.5f) / 5.0f);
            } else {
                super.method_24920(hit);
            }
        } else {
            super.method_24920(hit);
        }
        this.method_7444(state.method_26231().method_10594());
        this.method_32876((class_6880)class_5712.field_28155);
        if (!this.isBouncy()) {
            if (stack.method_31573(UTags.Items.HORSE_SHOES)) {
                class_1937 class_19372 = this.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 sw = (class_3218)class_19372;
                    stack.method_7956(1 + this.field_5974.method_43048(10), sw, null, i -> this.method_5783(USounds.Vanilla.field_15075, 1.0f, 1.0f));
                }
                if (stack.method_7960()) {
                    this.method_31472();
                    return;
                }
            }
            this.method_37908().method_43129(null, (class_1297)this, this.method_7440(), class_3419.field_15245, 0.6f, 1.0f);
        } else {
            this.method_37908().method_43129(null, (class_1297)this, state.method_26231().method_10594(), class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public boolean method_54457(class_1937 world) {
        return !this.isBouncy() && super.method_54457(world);
    }

    protected class_3414 method_7440() {
        if (this.method_7495().method_31573(UTags.Items.HORSE_SHOES)) {
            return USounds.Vanilla.field_15104;
        }
        return this.isBouncy() ? (class_3414)USounds.ITEM_MUFFIN_BOUNCE.comp_349() : USounds.ITEM_ROCK_LAND;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        class_1799 stack = this.method_7495();
        if (!stack.method_7960()) {
            class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, (Object)stack).result().ifPresent(item -> nbt.method_10566("item", item));
        }
        nbt.method_10582("damageType", this.damageType.method_29177().toString());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_57313(class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)nbt.method_10562("item")));
        if (nbt.method_10573("damageType", 8)) {
            Optional.ofNullable(class_2960.method_12829((String)nbt.method_10558("damageType"))).ifPresent(id -> this.setDamageType((class_5321<class_8110>)class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)id)));
        }
    }
}

