/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.server.world;

import com.google.common.base.Suppliers;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgBlockDestruction;
import com.minelittlepony.unicopia.server.world.WorldOverlay;
import com.minelittlepony.unicopia.util.Tickable;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public class BlockDestructionManager
implements Tickable {
    private static final class_2960 ID = Unicopia.id("destruction_manager");
    public static final int DESTRUCTION_COOLDOWN = 50;
    public static final int UNSET_DAMAGE = -1;
    public static final int MAX_DAMAGE = 10;
    private final WorldOverlay<Destruction> chunks;

    public static Supplier<BlockDestructionManager> create(class_1937 world) {
        return Suppliers.memoize(() -> new BlockDestructionManager(world));
    }

    public static BlockDestructionManager of(class_1937 world) {
        return ((Source)world).getDestructionManager();
    }

    private BlockDestructionManager(class_1937 world) {
        this.chunks = WorldOverlay.getOverlay(world, ID, w -> new WorldOverlay<Destruction>(world, () -> new Destruction(this), this::sendUpdates));
    }

    public float getBlockDestruction(class_2338 pos) {
        Destruction destr = this.chunks.getState(pos);
        return destr == null ? -1.0f : destr.amount;
    }

    public void setBlockDestruction(class_2338 pos, float amount) {
        this.chunks.getOrCreateState(pos).set(amount);
        this.chunks.method_80();
    }

    public float damageBlock(class_2338 pos, float amount) {
        if (amount == 0.0f) {
            return this.getBlockDestruction(pos);
        }
        amount = class_3532.method_15363((float)(Math.max(this.getBlockDestruction(pos), 0.0f) + amount), (float)0.0f, (float)10.0f);
        this.setBlockDestruction(pos, amount);
        return amount;
    }

    public void onBlockChanged(class_2338 pos, class_2680 oldState, class_2680 newstate) {
        if (oldState.method_26204() != newstate.method_26204()) {
            this.setBlockDestruction(pos, -1.0f);
        }
    }

    @Override
    public void tick() {
        this.chunks.tick();
    }

    private void sendUpdates(Long2ObjectMap<Destruction> destructions, List<class_3222> players) {
        Long2ObjectOpenHashMap values = new Long2ObjectOpenHashMap();
        destructions.forEach((blockPos, item) -> {
            if (item.dirty) {
                item.dirty = false;
                values.put(blockPos.longValue(), (Object)Float.valueOf(item.amount));
            }
        });
        class_2596 packet = Channel.SERVER_BLOCK_DESTRUCTION.toPacket((Object)new MsgBlockDestruction((Long2ObjectMap<Float>)values));
        players.forEach(player -> {
            if (player instanceof class_3222) {
                class_3222 spe = player;
                spe.field_13987.method_14364(packet);
            }
        });
    }

    public static interface Source {
        public BlockDestructionManager getDestructionManager();
    }

    private class Destruction
    implements WorldOverlay.State {
        float amount = -1.0f;
        int age = 50;
        boolean dirty;

        private Destruction(BlockDestructionManager blockDestructionManager) {
        }

        @Override
        public boolean tick() {
            if (this.age-- > 0) {
                return false;
            }
            if (this.amount >= 0.0f) {
                this.set(this.amount - 1.0f);
            }
            return this.amount < 0.0f || this.age-- <= 0;
        }

        void set(float amount) {
            this.age = 50;
            this.amount = amount >= 0.0f && amount < 10.0f ? amount : -1.0f;
            this.dirty = true;
        }

        @Override
        public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
            compound.method_10548("destruction", this.amount);
            compound.method_10569("age", this.age);
        }

        @Override
        public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
            this.amount = compound.method_10583("destruction");
            this.age = compound.method_10550("age");
            this.dirty = true;
        }
    }
}

