/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.server.world;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.server.world.WorldOverlay;
import com.minelittlepony.unicopia.server.world.chunk.Chunk;
import com.minelittlepony.unicopia.server.world.chunk.PositionalDataMap;
import com.minelittlepony.unicopia.util.Tickable;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class Ether
extends class_18
implements Tickable {
    private static final class_2960 ID = Unicopia.id("ether");
    private final Map<class_2960, Map<UUID, Map<UUID, Entry<?>>>> endpoints;
    private final PositionalDataMap<Entry<?>> positionData = new PositionalDataMap();
    private final Object locker = new Object();
    private final class_1937 world;

    public static Ether get(class_1937 world) {
        return WorldOverlay.getPersistableStorage(world, ID, Ether::new, Ether::new);
    }

    Ether(class_1937 world, class_2487 compound) {
        this.world = world;
        this.endpoints = NbtSerialisable.readMap(compound.method_10562("endpoints"), class_2960::method_12829, typeNbt -> NbtSerialisable.readMap((class_2487)typeNbt, UUID::fromString, entityNbt -> NbtSerialisable.readMap((class_2487)entityNbt, UUID::fromString, nbt -> new Entry((class_2520)nbt, (class_7225.class_7874)world.method_30349()))));
    }

    Ether(class_1937 world) {
        this.world = world;
        this.endpoints = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_2487 method_75(class_2487 compound, class_7225.class_7874 lookup) {
        Object object = this.locker;
        synchronized (object) {
            this.pruneNodes();
            compound.method_10566("endpoints", (class_2520)NbtSerialisable.writeMap(this.endpoints, class_2960::toString, entities -> NbtSerialisable.writeMap(entities, UUID::toString, spells -> NbtSerialisable.writeMap(spells, UUID::toString, e -> e.toNBT(lookup)))));
            return compound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Spell> Entry<T> getOrCreate(T spell, Caster<?> caster) {
        Object object = this.locker;
        synchronized (object) {
            Entry entry = this.endpoints.computeIfAbsent(spell.getTypeAndTraits().type().getId(), typeId -> new HashMap()).computeIfAbsent(caster.asEntity().method_5667(), entityId -> new HashMap()).computeIfAbsent(spell.getUuid(), spellid -> {
                this.method_80();
                return new Entry(this, spell, caster);
            });
            if (entry.spell.get() != spell) {
                entry.spell = new WeakReference<T>(spell);
                this.method_80();
            }
            if (entry.removed) {
                entry.removed = false;
                this.positionData.update(entry);
                this.method_80();
            }
            return entry;
        }
    }

    @Override
    public void tick() {
        this.endpoints.values().forEach(byType -> byType.values().forEach(entries -> entries.values().forEach(Entry::update)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Spell> void remove(SpellType<T> spellType, UUID entityId) {
        Object object = this.locker;
        synchronized (object) {
            this.endpoints.computeIfPresent(spellType.getId(), (typeId, entries) -> {
                Map data = (Map)entries.remove(entityId);
                if (data != null) {
                    this.method_80();
                    data.values().forEach(this.positionData::remove);
                }
                return entries.isEmpty() ? null : entries;
            });
        }
    }

    public void remove(SpellType<?> spellType, Caster<?> caster) {
        this.remove(spellType, caster.asEntity().method_5667());
    }

    public <T extends Spell> void remove(T spell, Caster<?> caster) {
        Entry<T> entry = this.get(spell, caster);
        if (entry != null) {
            entry.markDead();
        }
    }

    public <T extends Spell> Entry<T> get(T spell, Caster<?> caster) {
        return this.get(spell.getTypeAndTraits().type(), caster.asEntity().method_5667(), spell.getUuid());
    }

    public <T extends Spell> Entry<T> get(SpellType<T> spell, EntityReference.EntityValues<?> entityId, @Nullable UUID spellId) {
        return this.get(spell, entityId.uuid(), spellId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T extends Spell> Entry<T> get(SpellType<T> spell, UUID entityId, @Nullable UUID spellId) {
        if (spellId == null) {
            return null;
        }
        Object object = this.locker;
        synchronized (object) {
            Entry entry = (Entry)this.endpoints.getOrDefault(spell.getId(), Map.of()).getOrDefault(entityId, Map.of()).get(spellId);
            return entry == null || entry.isDead() ? null : entry;
        }
    }

    public <T extends Spell> boolean anyMatch(SpellType<T> spellType, BiPredicate<T, Caster<?>> condition) {
        return this.anyMatch(spellType, (Entry<T> entry) -> {
            Object spell = entry.getSpell();
            Caster<?> caster = entry.getCaster();
            return spell != null && caster != null && condition.test(spell, caster);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Spell> boolean anyMatch(SpellType<T> spellType, Predicate<Entry<T>> condition) {
        Object object = this.locker;
        synchronized (object) {
            for (Map entries : this.endpoints.getOrDefault(spellType.getId(), Map.of()).values()) {
                for (Entry entry : entries.values()) {
                    if (entry.isDead() || !condition.test(entry)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Set<Entry<?>> getAtPosition(class_2338 pos) {
        return this.world.method_8608() ? Set.of() : this.positionData.getState(pos);
    }

    public Chunk<Entry<?>> getChunk(class_1923 pos) {
        return this.world.method_8608() ? null : this.positionData.getChunk(pos);
    }

    private void pruneNodes() {
        this.endpoints.values().removeIf(entities -> {
            entities.values().removeIf(spells -> {
                spells.values().removeIf(Entry::isDead);
                return spells.isEmpty();
            });
            return entities.isEmpty();
        });
    }

    public class Entry<T extends Spell>
    implements PositionalDataMap.Hotspot,
    NbtSerialisable {
        public final EntityReference<?> entity;
        @Nullable
        private UUID spellId;
        private WeakReference<T> spell;
        private boolean removed;
        private float pitch;
        private final AtomicBoolean changed = new AtomicBoolean(true);
        private float yaw;
        private float radius;
        private final Set<UUID> claimants = new HashSet<UUID>();
        private class_2338 currentPos = class_2338.field_10980;
        private class_2338 previousPos = class_2338.field_10980;

        private Entry(class_2520 nbt, class_7225.class_7874 lookup) {
            this.entity = new EntityReference();
            this.spell = new WeakReference<Object>(null);
            this.fromNBT((class_2487)nbt, lookup);
        }

        public Entry(T spell, Caster<?> caster) {
            this.entity = new EntityReference(caster.asEntity());
            this.spell = new WeakReference<T>(spell);
            this.spellId = spell.getUuid();
            this.update();
        }

        void update() {
            this.previousPos = this.currentPos;
            this.currentPos = this.entity.getTarget().map(t -> class_2338.method_49638((class_2374)t.pos())).orElse(class_2338.field_10980);
            if (!this.currentPos.equals((Object)this.previousPos)) {
                Ether.this.positionData.update(this);
            }
        }

        public boolean hasChanged() {
            return this.changed.getAndSet(false);
        }

        public float getPitch() {
            return this.pitch;
        }

        public void setPitch(float pitch) {
            if (!class_3532.method_15347((float)this.pitch, (float)pitch)) {
                this.pitch = pitch;
                this.changed.set(true);
            }
            Ether.this.method_80();
        }

        public float getYaw() {
            return this.yaw;
        }

        public void setYaw(float yaw) {
            if (!class_3532.method_15347((float)this.yaw, (float)yaw)) {
                this.yaw = yaw;
                this.changed.set(true);
            }
            Ether.this.method_80();
        }

        @Override
        public class_2338 getCenter() {
            return this.currentPos;
        }

        @Override
        public float getRadius() {
            return this.radius;
        }

        public void setRadius(float radius) {
            if (!class_3532.method_15347((float)this.radius, (float)radius)) {
                this.radius = radius;
                if ((int)radius != (int)this.radius) {
                    Ether.this.positionData.update(this);
                }
                this.changed.set(true);
            }
            Ether.this.method_80();
        }

        public boolean isAlive() {
            return !this.isDead();
        }

        boolean isDead() {
            if (!this.removed) {
                this.getSpell();
            }
            return this.removed;
        }

        @Nullable
        public UUID getSpellId() {
            return this.spellId;
        }

        public void markDead() {
            Unicopia.LOGGER.debug("Marking " + String.valueOf(this.entity.getTarget().orElse(null)) + " as dead");
            this.removed = true;
            Ether.this.positionData.remove(this);
            this.claimants.clear();
            Ether.this.method_80();
        }

        public boolean entityMatches(UUID uuid) {
            return this.entity.getTarget().filter(target -> uuid.equals(target.uuid())).isPresent();
        }

        public void claim(UUID claimant) {
            this.claimants.add(claimant);
            Ether.this.method_80();
        }

        public void release(UUID claimant) {
            this.claimants.remove(claimant);
            Ether.this.method_80();
        }

        public boolean isClaimedBy(UUID claimant) {
            return this.claimants.contains(claimant);
        }

        public boolean hasClaimant() {
            return !this.claimants.isEmpty();
        }

        @Nullable
        public T getSpell() {
            if (this.removed) {
                return null;
            }
            Spell spell = (Spell)this.spell.get();
            if (spell == null && this.spellId != null && (spell = (Spell)this.entity.getOrEmpty(Ether.this.world).flatMap(Caster::of).flatMap(caster -> caster.getSpellSlot().get(s -> s.getUuid().equals(this.spellId))).orElse(null)) != null) {
                this.spell = new WeakReference<Spell>(spell);
            }
            if (spell != null && spell.isDead()) {
                this.spellId = null;
                spell = null;
                this.markDead();
            }
            return (T)spell;
        }

        @Nullable
        public Caster<?> getCaster() {
            if (this.removed) {
                return null;
            }
            return Caster.of(this.entity.get(Ether.this.world)).orElse(null);
        }

        @Override
        public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
            this.entity.toNBT(compound, lookup);
            compound.method_10556("removed", this.removed);
            compound.method_10548("pitch", this.pitch);
            compound.method_10548("yaw", this.yaw);
            compound.method_10548("radius", this.radius);
            if (this.spellId != null) {
                compound.method_25927("spellId", this.spellId);
            }
            class_2499 list = new class_2499();
            this.claimants.forEach(claimant -> list.add((Object)class_2512.method_25929((UUID)claimant)));
            compound.method_10566("claimants", (class_2520)list);
        }

        @Override
        public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
            this.entity.fromNBT(compound, lookup);
            this.removed = compound.method_10577("removed");
            this.pitch = compound.method_10583("pitch");
            this.yaw = compound.method_10583("yaw");
            this.radius = compound.method_10583("radius");
            this.spellId = compound.method_25928("spellid") ? compound.method_25926("spellId") : null;
            this.claimants.clear();
            if (compound.method_10573("claimants", 9)) {
                compound.method_10554("claimants", 11).forEach(el -> this.claimants.add(class_2512.method_25930((class_2520)el)));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (!(other instanceof Entry)) return false;
            Entry e = (Entry)other;
            if (!e.entity.referenceEquals(this.entity)) return false;
            if (!Objects.equals(e.spell.get(), this.spell.get())) return false;
            return true;
        }

        public boolean equals(UUID entityId, UUID spellId) {
            return this.entity.referenceEquals(entityId) && spellId.equals(this.spellId);
        }

        public int hashCode() {
            return Objects.hash(this.entity, this.spell.get());
        }
    }
}

