/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.server.world;

import com.minelittlepony.unicopia.util.Tickable;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class WorldOverlay<T extends State>
extends class_18
implements Tickable {
    private final class_1937 world;
    private final Long2ObjectMap<Chunk> chunks = new Long2ObjectOpenHashMap();
    private final Object locker = new Object();
    private final Supplier<T> factory;
    @Nullable
    private final BiConsumer<Long2ObjectMap<T>, List<class_3222>> updateSender;

    public static <T extends class_18> T getPersistableStorage(class_1937 world, class_2960 id, BiFunction<class_1937, class_2487, T> loadFunc, Function<class_1937, T> factory) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            return (T)serverWorld.method_17983().method_17924(new class_18.class_8645(() -> (class_18)factory.apply(world), (compound, lookup) -> (class_18)loadFunc.apply(world, (class_2487)compound), class_4284.field_19212), id.method_12836() + "_" + id.method_12832().replace('/', '_'));
        }
        return ClientInstance.of(world, id, factory).instance();
    }

    public static <T extends State> WorldOverlay<T> getOverlay(class_1937 world, class_2960 id, Supplier<T> factory, @Nullable BiConsumer<Long2ObjectMap<T>, List<class_3222>> updateSender) {
        return WorldOverlay.getOverlay(world, id, w -> new WorldOverlay((class_1937)w, factory, updateSender));
    }

    public static <T extends State> WorldOverlay<T> getOverlay(class_1937 world, class_2960 id, Function<class_1937, WorldOverlay<T>> overlayFactory) {
        return WorldOverlay.getPersistableStorage(world, id, (w, tag) -> {
            WorldOverlay overlay = (WorldOverlay)overlayFactory.apply((class_1937)w);
            overlay.readNbt((class_2487)tag, (class_7225.class_7874)w.method_30349());
            return overlay;
        }, overlayFactory);
    }

    WorldOverlay(class_1937 world, Supplier<T> factory, @Nullable BiConsumer<Long2ObjectMap<T>, List<class_3222>> updateSender) {
        this.world = world;
        this.factory = factory;
        this.updateSender = updateSender;
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 lookup) {
        class_2487 destructions = new class_2487();
        this.chunks.forEach((id, chunk) -> destructions.method_10566(id.toString(), (class_2520)chunk.toNBT(lookup)));
        compound.method_10566("chunks", (class_2520)destructions);
        return compound;
    }

    public void readNbt(class_2487 compound, class_7225.class_7874 lookup) {
        class_2487 d = compound.method_10562("chunks");
        d.method_10541().forEach(id -> ((Chunk)this.chunks.computeIfAbsent((Object)Long.valueOf(id), x$0 -> new Chunk((long)x$0))).fromNBT(d.method_10562(id), lookup));
    }

    @Nullable
    public T getState(class_2338 pos) {
        return this.getChunk(pos).getState(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getOrCreateState(class_2338 pos) {
        Object object = this.locker;
        synchronized (object) {
            return this.getChunk(pos).getOrCreateState(pos);
        }
    }

    private Chunk getChunk(class_2338 pos) {
        return (Chunk)this.chunks.computeIfAbsent(class_1923.method_37232((class_2338)pos), x$0 -> new Chunk(x$0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(class_2338 pos, @Nullable T state) {
        Object object = this.locker;
        synchronized (object) {
            this.getChunk(pos).setState(pos, state);
            this.method_80();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick() {
        Object object = this.locker;
        synchronized (object) {
            this.chunks.long2ObjectEntrySet().removeIf(entry -> ((Chunk)entry.getValue()).tick());
            if (this.world instanceof class_3218) {
                this.chunks.forEach((chunkPos, chunk) -> chunk.sendUpdates((class_3218)this.world));
            }
        }
    }

    record ClientInstance<T extends class_18>(WeakReference<class_1937> world, T instance) {
        private static final Map<class_2960, ClientInstance<?>> INSTANCES = new HashMap();

        public ClientInstance(class_1937 world, Function<class_1937, T> factory) {
            this(new WeakReference<class_1937>(world), (class_18)factory.apply(world));
        }

        public static <T extends class_18> ClientInstance<T> of(class_1937 world, class_2960 id, Function<class_1937, T> factory) {
            return INSTANCES.compute(id, (i, instance) -> {
                if (instance == null || !instance.matches(world)) {
                    return new ClientInstance(world, factory);
                }
                return instance;
            });
        }

        public boolean matches(class_1937 world) {
            return this.world().get() == world;
        }
    }

    private class Chunk
    implements NbtSerialisable {
        private final Long2ObjectMap<T> states = new Long2ObjectOpenHashMap();
        private final long pos;

        Chunk(long pos) {
            this.pos = pos;
        }

        @Nullable
        public T getState(class_2338 pos) {
            return (State)this.states.get(pos.method_10063());
        }

        public T getOrCreateState(class_2338 pos) {
            return (State)this.states.computeIfAbsent(pos.method_10063(), l -> (State)WorldOverlay.this.factory.get());
        }

        public void setState(class_2338 pos, @Nullable T state) {
            if (state == null) {
                this.states.remove(pos.method_10063());
            } else {
                this.states.put(pos.method_10063(), state);
            }
        }

        boolean tick() {
            this.states.long2ObjectEntrySet().removeIf(e -> ((State)e.getValue()).tick());
            return this.states.isEmpty();
        }

        void sendUpdates(class_3218 world) {
            if (WorldOverlay.this.updateSender == null) {
                return;
            }
            if (!world.method_14178().method_12123(class_1923.method_8325((long)this.pos), class_1923.method_8332((long)this.pos))) {
                return;
            }
            class_3898 storage = world.method_14178().field_17254;
            List players = storage.method_17210(new class_1923(this.pos), false);
            if (!players.isEmpty()) {
                WorldOverlay.this.updateSender.accept(this.states, players);
            }
        }

        @Override
        public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
            class_2487 states = new class_2487();
            this.states.forEach((id, state) -> states.method_10566(id.toString(), (class_2520)state.toNBT(lookup)));
            compound.method_10566("states", (class_2520)states);
        }

        @Override
        public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
            class_2487 d = compound.method_10562("states");
            WorldOverlay.this.chunks.clear();
            d.method_10541().forEach(id -> ((State)this.states.computeIfAbsent((Object)Long.valueOf(id), i -> (State)WorldOverlay.this.factory.get())).fromNBT(d.method_10562(id), lookup));
        }
    }

    public static interface State
    extends NbtSerialisable {
        public boolean tick();
    }
}

