/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.server.world.chunk;

import com.minelittlepony.unicopia.server.world.chunk.Chunk;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;

public class PositionalDataMap<T extends Hotspot> {
    private final Long2ObjectMap<Chunk<T>> chunks = new Long2ObjectOpenHashMap();
    private final Map<T, Set<Chunk<T>>> entryToChunks = new WeakHashMap<T, Set<Chunk<T>>>();

    public Set<T> getState(class_2338 pos) {
        Chunk chunk = (Chunk)this.chunks.get(class_1923.method_37232((class_2338)pos));
        return chunk == null ? Set.of() : chunk.getState(pos);
    }

    @Nullable
    public Chunk<T> getChunk(class_1923 pos) {
        return (Chunk)this.chunks.get(pos.method_8324());
    }

    public void remove(T entry) {
        Set<Chunk<Chunk>> chunks = this.entryToChunks.remove(entry);
        if (chunks != null) {
            chunks.forEach(chunk -> chunk.remove(entry));
        }
    }

    public void update(T entry) {
        class_238 entryBox = new class_238(entry.getCenter()).method_1014((double)class_3532.method_15386((float)entry.getRadius()));
        Set<Chunk<Chunk>> oldChunks = this.entryToChunks.get(entry);
        Set<Chunk<Chunk>> newChunks = this.getIntersectingChunks(entryBox);
        if (oldChunks != null) {
            oldChunks.forEach(chunk -> chunk.remove(entry));
        }
        newChunks.forEach(chunk -> chunk.update(entry, entryBox));
        this.entryToChunks.put(entry, newChunks);
    }

    private Set<Chunk<T>> getIntersectingChunks(class_238 entryBox) {
        int minX = class_4076.method_32204((double)entryBox.field_1323);
        int maxX = class_4076.method_32204((double)entryBox.field_1320);
        int minZ = class_4076.method_32204((double)entryBox.field_1321);
        int maxZ = class_4076.method_32204((double)entryBox.field_1324);
        HashSet<Chunk<T>> chunks = new HashSet<Chunk<T>>();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                chunks.add((Chunk)this.chunks.computeIfAbsent(class_1923.method_8331((int)x, (int)z), Chunk::new));
            }
        }
        return chunks;
    }

    public static interface Hotspot {
        public float getRadius();

        public class_2338 getCenter();
    }
}

