/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.util;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface Swap<T>
extends BiConsumer<T, T> {
    default public <E> Swap<E> upcast(Predicate<E> shouldRun) {
        Swap swap = this;
        return (a, b) -> {
            if (shouldRun.test(a) && shouldRun.test(b)) {
                swap.accept(a, b);
            }
        };
    }

    @SafeVarargs
    public static <E> Swap<E> union(Swap<E> ... swaps) {
        return Swap.union(List.of(swaps));
    }

    public static <E> Swap<E> union(Iterable<Swap<E>> swaps) {
        return (a, b) -> swaps.forEach(consumer -> consumer.accept(a, b));
    }

    public static <E, N extends Number> Swap<E> of(Function<E, N> getter, BiConsumer<E, N> setter, Function<Float, N> converter) {
        return Swap.of(getter, e -> (Number)converter.apply(Float.valueOf(1.0f)), setter, converter);
    }

    public static <E, N extends Number> Swap<E> of(Function<E, N> getter, Function<E, N> maxGetter, BiConsumer<E, N> setter, Function<Float, N> converter) {
        return Swap.of(e -> Float.valueOf(((Number)getter.apply(e)).floatValue() / ((Number)maxGetter.apply(e)).floatValue()), (e, value) -> setter.accept(e, (Number)converter.apply(Float.valueOf(value.floatValue() * ((Number)maxGetter.apply(e)).floatValue()))));
    }

    public static <E, T> Swap<E> of(Function<E, T> getter, BiConsumer<E, T> setter) {
        return (a, b) -> {
            Object aa = getter.apply(a);
            Object bb = getter.apply(b);
            setter.accept(a, bb);
            setter.accept(b, aa);
        };
    }
}

