/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.util.serialization;

import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class NbtMap<K, V>
implements NbtSerialisable {
    private final Codec<Map<K, V>> codec;
    private final Map<K, V> data = new HashMap();

    public static <K, V> NbtMap<K, V> of(Codec<K> keyCodec, Codec<V> valueCodec) {
        return new NbtMap<K, V>(Codec.unboundedMap(keyCodec, valueCodec));
    }

    public NbtMap(Codec<Map<K, V>> codec) {
        this.codec = codec;
    }

    public Optional<V> getOrEmpty(K key) {
        return Optional.ofNullable(this.data.get(key));
    }

    public V computeIfAbsent(K key, Supplier<V> factory) {
        return (V)this.data.computeIfAbsent(key, (? super K e) -> factory.get());
    }

    public V put(K key, V value) {
        return this.data.put(key, value);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> function) {
        return this.data.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)function);
    }

    @Nullable
    public V remove(K key) {
        return this.data.remove(key);
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10566("data", NbtSerialisable.encode(this.codec, this.data, lookup));
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        this.data.clear();
        NbtSerialisable.decode(this.codec, compound.method_10580("data"), lookup).ifPresent(this.data::putAll);
    }
}

