/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.util.shape;

import com.minelittlepony.unicopia.util.shape.Shape;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class Cylinder
implements Shape {
    private final boolean hollow;
    private final double stretchX;
    private final double stretchZ;
    private final double height;
    private final double rad;
    private final double volume;

    public Cylinder(boolean hollow, double height, double radius) {
        this(hollow, height, radius, 1.0, 1.0);
    }

    public Cylinder(boolean hollow, double height, double radius, double stretchX, double stretchZ) {
        this.hollow = hollow;
        this.height = height;
        this.rad = radius;
        this.stretchX = stretchX;
        this.stretchZ = stretchZ;
        this.volume = this.computeSpawnableSpace();
    }

    @Override
    public double getVolume() {
        return this.volume;
    }

    private double computeSpawnableSpace() {
        if (!this.hollow) {
            return Math.PI * (this.stretchX * this.rad * this.stretchZ * this.rad) * this.height;
        }
        if (this.stretchX != this.stretchZ) {
            double result = 3.0 * (this.stretchX + this.stretchZ);
            return Math.PI * (result -= Math.sqrt(10.0 * this.stretchX * this.stretchZ + 3.0 * (this.stretchX * this.stretchX + this.stretchZ * this.stretchZ)));
        }
        return Math.PI * 2 * this.rad * this.stretchX * this.height;
    }

    @Override
    public class_243 computePoint(class_5819 rand) {
        double y = class_3532.method_15366((class_5819)rand, (double)0.0, (double)this.height);
        double pheta = class_3532.method_15366((class_5819)rand, (double)0.0, (double)(Math.PI * 2));
        double rho = this.hollow && Math.abs(y) != this.height / 2.0 ? this.rad : class_3532.method_15366((class_5819)rand, (double)0.0, (double)this.rad);
        return new class_243(rho * Math.cos(pheta) * this.stretchX, y, rho * Math.sin(pheta) * this.stretchZ);
    }

    @Override
    public boolean isPointInside(class_243 point) {
        point = new class_243(point.field_1352 / this.stretchX, point.field_1351, point.field_1350 / this.stretchZ);
        double y = Math.abs(point.field_1351);
        if (y < this.height / 2.0) {
            double r = Math.sqrt(point.field_1352 * point.field_1352 + point.field_1350 * point.field_1350);
            return this.hollow ? r == this.rad : r <= this.rad;
        }
        return y == this.height / 2.0;
    }

    @Override
    public class_243 getLowerBound() {
        return new class_243(-this.rad * this.stretchX, 0.0, -this.rad * this.stretchZ);
    }

    @Override
    public class_243 getUpperBound() {
        return new class_243(-this.rad * this.stretchX, this.height, -this.rad * this.stretchZ);
    }
}

