/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.ActivationType;
import com.minelittlepony.unicopia.ability.data.Hit;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgPlayerAbility;
import com.minelittlepony.unicopia.util.Tickable;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class AbilityDispatcher
implements Tickable,
NbtSerialisable {
    private final Pony player;
    private final Map<AbilitySlot, Stat> stats = new EnumMap<AbilitySlot, Stat>(AbilitySlot.class);
    @Nullable
    private Race prevRace;
    private long maxPage = -1L;

    public AbilityDispatcher(Pony player) {
        this.player = player;
    }

    public void clear(AbilitySlot slot, ActivationType pressType, long page) {
        Stat stat = this.getStat(slot);
        if (stat.canSwitchStates()) {
            stat.clear(pressType, page);
        }
    }

    public Optional<Ability<?>> activate(AbilitySlot slot, long page) {
        Stat stat = this.getStat(slot);
        if (stat.canSwitchStates()) {
            return stat.getAbility(page).flatMap(stat::setActiveAbility);
        }
        return Optional.empty();
    }

    public Collection<Stat> getStats() {
        return this.stats.values();
    }

    public Optional<Stat> getActiveStat() {
        return this.stats.values().stream().filter(stat -> stat.getFillProgress() > 0.0f).findFirst();
    }

    public Stat getStat(AbilitySlot slot) {
        return this.stats.computeIfAbsent(slot, x$0 -> new Stat((AbilitySlot)((Object)x$0)));
    }

    public boolean isFilled(AbilitySlot slot) {
        return this.getStat(slot).getMaxPage() > 0L;
    }

    public int getMaxPage() {
        Race newRace = this.player.getCompositeRace().collapsed();
        if (this.maxPage < 0L || this.prevRace != newRace) {
            this.prevRace = newRace;
            this.maxPage = 0L;
            for (AbilitySlot slot : AbilitySlot.values()) {
                this.maxPage = Math.max(this.maxPage, this.getStat(slot).getMaxPage() - 1L);
            }
        }
        return (int)this.maxPage;
    }

    @Override
    public void tick() {
        this.stats.values().forEach(Stat::tick);
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        if (compound.method_10545("stats")) {
            this.stats.clear();
            class_2487 li = compound.method_10562("stats");
            li.method_10541().forEach(key -> this.getStat(AbilitySlot.valueOf(key)).fromNBT(li.method_10562(key), lookup));
        }
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        class_2487 li = new class_2487();
        this.stats.forEach((key, value) -> li.method_10566(key.name(), (class_2520)value.toNBT(lookup)));
        compound.method_10566("stats", (class_2520)li);
    }

    public class Stat
    implements NbtSerialisable {
        private int warmup;
        private int maxWarmup;
        private int cooldown;
        private int maxCooldown;
        public final AbilitySlot slot;
        private boolean triggered;
        private Optional<Ability<?>> activeAbility = Optional.empty();

        private Stat(AbilitySlot slot) {
            this.slot = slot;
        }

        boolean canSwitchStates() {
            return !this.activeAbility.isPresent() || this.warmup != 0 || this.triggered && this.cooldown == 0;
        }

        public int getRemainingCooldown() {
            return this.cooldown;
        }

        public float getFillProgress() {
            float cooldown = this.getWarmup();
            if (cooldown <= 0.0f || cooldown >= 1.0f) {
                return this.getCooldown();
            }
            return 1.0f - cooldown;
        }

        public float getCooldown() {
            return this.maxCooldown <= 0 ? 0.0f : (float)this.cooldown / (float)this.maxCooldown;
        }

        public void setCooldown(int value) {
            this.cooldown = value;
            this.maxCooldown = value;
        }

        public float getWarmup() {
            return this.maxWarmup <= 0 ? 0.0f : (float)this.warmup / (float)this.maxWarmup;
        }

        public double getCost(long page) {
            if (this.warmup <= 0) {
                return 0.0;
            }
            return this.getAbility(page).map(ability -> ability.getCostEstimate(AbilityDispatcher.this.player)).orElse(0.0);
        }

        public void setWarmup(int value) {
            this.maxWarmup = value;
            this.warmup = value;
        }

        public void tick() {
            Optional<Ability<?>> activeAbility = this.getActiveAbility();
            if (activeAbility.isEmpty()) {
                if (this.warmup > 0) {
                    --this.warmup;
                }
                if (this.cooldown > 0) {
                    --this.cooldown;
                }
            }
            this.getActiveAbility().ifPresent(ability -> {
                if (this.warmup > 0) {
                    --this.warmup;
                    ability.warmUp(AbilityDispatcher.this.player, this.slot);
                    return;
                }
                if (this.cooldown > 100 && ((class_1657)AbilityDispatcher.this.player.asEntity()).method_7337()) {
                    this.cooldown = Math.max(10, this.cooldown - 100);
                }
                if (this.cooldown > 0 && this.cooldown-- > 0) {
                    ability.coolDown(AbilityDispatcher.this.player, this.slot);
                    if (this.cooldown <= 0) {
                        this.setActiveAbility(null);
                    }
                    return;
                }
                this.tryFire((Ability)ability);
            });
        }

        private <T extends Hit> void tryFire(Ability<T> ability) {
            if (this.triggered) {
                return;
            }
            this.triggered = true;
            this.setCooldown(ability.getCooldownTime(AbilityDispatcher.this.player));
            if (AbilityDispatcher.this.player.isClientPlayer()) {
                Optional<T> data = ability.prepare(AbilityDispatcher.this.player);
                this.warmup = 0;
                if (data.isPresent()) {
                    InteractionManager.getInstance().sendPlayerLookAngles((class_1657)AbilityDispatcher.this.player.asEntity());
                    Channel.CLIENT_PLAYER_ABILITY.sendToServer(new MsgPlayerAbility<T>(ability, data, ActivationType.NONE));
                } else {
                    ((class_1657)AbilityDispatcher.this.player.asEntity()).method_5783(USounds.GUI_ABILITY_FAIL, 1.0f, 1.0f);
                    this.setCooldown(0);
                }
            }
            if (this.cooldown <= 0) {
                this.setActiveAbility(null);
            }
        }

        public Optional<Ability<?>> getAbility(long page) {
            List<Ability<?>> found = Abilities.BY_SLOT_AND_COMPOSITE_RACE.apply(this.slot, AbilityDispatcher.this.player.getCompositeRace());
            if (found.isEmpty()) {
                return Optional.empty();
            }
            return Optional.ofNullable(found.get((int)Math.min((long)(found.size() - 1), page)));
        }

        public void clear(ActivationType pressType, long page) {
            if (pressType == ActivationType.NONE || this.getAbility(page).filter(ability -> !this.triggerQuickAction((Ability)ability, pressType)).isEmpty()) {
                if (this.warmup > 0) {
                    this.getActiveAbility().filter(Ability::activateOnEarlyRelease).ifPresentOrElse(this::tryFire, () -> this.setActiveAbility(null));
                } else {
                    this.setActiveAbility(null);
                }
            }
        }

        private <T extends Hit> boolean triggerQuickAction(Ability<T> ability, ActivationType pressType) {
            Optional<T> data = ability.prepareQuickAction(AbilityDispatcher.this.player, pressType);
            if (ability.onQuickAction(AbilityDispatcher.this.player, pressType, data)) {
                Channel.CLIENT_PLAYER_ABILITY.sendToServer(new MsgPlayerAbility<T>(ability, data, pressType));
                return true;
            }
            return false;
        }

        public long getMaxPage() {
            return Abilities.BY_SLOT_AND_COMPOSITE_RACE.apply(this.slot, AbilityDispatcher.this.player.getCompositeRace()).size();
        }

        protected synchronized Optional<Ability<?>> setActiveAbility(@Nullable Ability<?> power) {
            if (this.activeAbility.orElse(null) != power) {
                this.triggered = false;
                this.activeAbility = Optional.ofNullable(power);
                this.setWarmup(this.activeAbility.map(p -> p.getWarmupTime(AbilityDispatcher.this.player)).orElse(0));
                this.setCooldown(0);
                return this.activeAbility;
            }
            return Optional.empty();
        }

        public synchronized Optional<Ability<?>> getActiveAbility() {
            return this.activeAbility.filter(ability -> ability != null && (!this.triggered || this.warmup != 0 || this.cooldown != 0) && ability.canUse(AbilityDispatcher.this.player.getCompositeRace()));
        }

        @Override
        public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
            compound.method_10569("warmup", this.warmup);
            compound.method_10569("cooldown", this.cooldown);
            compound.method_10569("maxWarmup", this.maxWarmup);
            compound.method_10569("maxCooldown", this.maxCooldown);
            compound.method_10556("triggered", this.triggered);
            this.getActiveAbility().ifPresent(ability -> compound.method_10582("activeAbility", Abilities.REGISTRY.method_10221(ability).toString()));
        }

        @Override
        public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
            this.warmup = compound.method_10550("warmup");
            this.cooldown = compound.method_10550("cooldown");
            this.maxWarmup = compound.method_10550("maxWarmup");
            this.maxCooldown = compound.method_10550("maxCooldown");
            this.triggered = compound.method_10577("triggered");
            this.activeAbility = Abilities.REGISTRY.method_17966(class_2960.method_60654((String)compound.method_10558("activeAbility")));
        }
    }
}

