/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.ActivationType;
import com.minelittlepony.unicopia.ability.data.Hit;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.util.TraceHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class CarryAbility
implements Ability<Hit> {
    @Override
    public int getWarmupTime(Pony player) {
        return 5;
    }

    @Override
    public int getCooldownTime(Pony player) {
        return 10;
    }

    @Override
    public double getCostEstimate(Pony player) {
        return 0.0;
    }

    @Override
    public Optional<Hit> prepare(Pony player) {
        return Hit.INSTANCE;
    }

    protected class_1309 findRider(class_1657 player, class_1937 w) {
        return TraceHelper.findEntity((class_1297)player, 10.0, 1.0f, hit -> EquinePredicates.VALID_LIVING_AND_NOT_MAGIC_IMMUNE.test((class_1297)hit) && !player.method_5794(hit)).orElse(null);
    }

    @Override
    public class_9139<? super class_9129, Hit> getSerializer() {
        return Hit.CODEC;
    }

    @Override
    public boolean onQuickAction(Pony player, ActivationType type, Optional<Hit> data) {
        if (type == ActivationType.TAP && player.getPhysics().isFlying()) {
            player.getPhysics().dashForward((float)player.asWorld().field_9229.method_43385(1.0, (double)0.3f));
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsQuickAction(Pony player, ActivationType type) {
        return type == ActivationType.NONE || type == ActivationType.TAP;
    }

    @Override
    public boolean apply(Pony iplayer, Hit data) {
        class_1657 player = (class_1657)iplayer.asEntity();
        class_1309 rider = this.findRider(player, iplayer.asWorld());
        this.dropAllPassengers(player);
        if (rider != null) {
            rider.method_5873((class_1297)player, true);
            Living.getOrEmpty((class_1297)rider).ifPresent(living -> living.setCarrier((class_1297)player));
        }
        Living.transmitPassengers((class_1297)player);
        return true;
    }

    protected void dropAllPassengers(class_1657 player) {
        if (player.method_5782()) {
            List passengers = StreamSupport.stream(player.method_5736().spliterator(), false).toList();
            player.method_5772();
            for (class_1297 passenger : passengers) {
                passenger.method_29495(player.method_19538());
                Living<class_1297> l = Living.living(passenger);
                if (l == null) continue;
                l.setCarrier((UUID)null);
            }
        }
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
    }

    @Override
    public void coolDown(Pony player, AbilitySlot slot) {
    }
}

