/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.ActivationType;
import com.minelittlepony.unicopia.ability.EarthPonyStompAbility;
import com.minelittlepony.unicopia.ability.data.Pos;
import com.minelittlepony.unicopia.ability.data.tree.TreeType;
import com.minelittlepony.unicopia.client.minelittlepony.MineLPDelegate;
import com.minelittlepony.unicopia.client.render.PlayerPoser;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.server.world.BlockDestructionManager;
import com.minelittlepony.unicopia.server.world.ModificationType;
import com.minelittlepony.unicopia.util.PosHelper;
import com.minelittlepony.unicopia.util.TraceHelper;
import com.minelittlepony.unicopia.util.VecHelper;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4466;
import net.minecraft.class_4481;
import net.minecraft.class_4482;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class EarthPonyKickAbility
implements Ability<Pos> {
    @Override
    public int getWarmupTime(Pony player) {
        return 3;
    }

    @Override
    public int getCooldownTime(Pony player) {
        return 50;
    }

    @Override
    public class_2960 getIcon(Pony player) {
        return this.getId().method_45134(p -> "textures/gui/ability/" + p + "_" + (player.getObservedSpecies().isHuman() ? Race.EARTH : player.getObservedSpecies()).getId().method_12832() + "_" + (this.getKickDirection(player) > 0 ? "forward" : "backward") + ".png");
    }

    @Override
    public double getCostEstimate(Pony player) {
        return TraceHelper.findBlock(player.asEntity(), this.getKickDirection(player) * 6, 1.0f).filter(pos -> TreeType.at(pos, player.asWorld()) != TreeType.NONE).isPresent() ? 3.0 : 1.0;
    }

    @Override
    public Optional<Pos> prepareQuickAction(Pony player, ActivationType type) {
        return Optional.of(this.getDefaultKickLocation(player));
    }

    @Override
    public boolean onQuickAction(Pony player, ActivationType type, Optional<Pos> data) {
        if (type == ActivationType.TAP) {
            if (!player.isClient()) {
                data.ifPresent(kickLocation -> {
                    class_243 origin = player.getOriginVector();
                    class_1937 w = player.asWorld();
                    ((class_1657)player.asEntity()).method_7322(3.0f);
                    for (class_1297 e : VecHelper.findInRange(player.asEntity(), (class_1924)w, kickLocation.vec(), 2.5, class_1301.field_6156)) {
                        if (!(e instanceof class_1309)) continue;
                        class_1309 entity = (class_1309)e;
                        float calculatedStrength = 0.5f * (1.0f + player.getLevel().getScaled(9.0f));
                        entity.method_5643((class_1282)player.damageOf(UDamageTypes.KICK, player), (float)player.asWorld().field_9229.method_39332(2, 10) + calculatedStrength);
                        entity.method_6005((double)calculatedStrength, origin.field_1352 - entity.method_23317(), origin.field_1350 - entity.method_23321());
                        Living.updateVelocity((class_1297)entity);
                        player.subtractEnergyCost(3.0);
                        player.setAnimation(PlayerPoser.Animation.KICK, PlayerPoser.Animation.Recipient.ANYONE);
                        return;
                    }
                    class_2338 pos = kickLocation.pos();
                    EarthPonyStompAbility.stompBlock(player, w, pos, 10.0f * (1.0f + player.getLevel().getScaled(5.0f)) * w.method_8320(pos).method_26165((class_1657)player.asEntity(), (class_1922)w, pos));
                    player.setAnimation(PlayerPoser.Animation.KICK, PlayerPoser.Animation.Recipient.ANYONE);
                });
            }
            return true;
        }
        if (type == ActivationType.DOUBLE_TAP && ((class_1657)player.asEntity()).method_24828() && player.getMagicalReserves().getMana().get() > 40.0f) {
            player.getPhysics().dashForward((float)player.asWorld().field_9229.method_43385(3.5, (double)0.3f));
            player.subtractEnergyCost(4.0);
            ((class_1657)player.asEntity()).method_7322(5.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsQuickAction(Pony player, ActivationType type) {
        return type == ActivationType.NONE || type == ActivationType.TAP || type == ActivationType.DOUBLE_TAP;
    }

    @Override
    @Nullable
    public Optional<Pos> prepare(Pony player) {
        return TraceHelper.findBlock(player.asEntity(), 6 * this.getKickDirection(player), 1.0f).filter(pos -> TreeType.at(pos, player.asWorld()) != TreeType.NONE).map(Pos::new).or(() -> Optional.of(this.getDefaultKickLocation(player)));
    }

    private int getKickDirection(Pony player) {
        return MineLPDelegate.getInstance().getPlayerPonyRace((class_1657)player.asEntity()).isEquine() && ((class_1657)player.asEntity()).method_18276() ? -1 : 1;
    }

    private Pos getDefaultKickLocation(Pony player) {
        class_243 kickVector = ((class_1657)player.asEntity()).method_5720().method_18805(1.0, 0.0, 1.0);
        if (MineLPDelegate.getInstance().getPlayerPonyRace((class_1657)player.asEntity()).isEquine()) {
            kickVector = kickVector.method_1024((float)Math.PI);
        }
        return new Pos((class_2382)class_2338.method_49638((class_2374)player.getOriginVector().method_1019(kickVector)));
    }

    @Override
    public class_9139<? super class_9129, Pos> getSerializer() {
        return Pos.CODEC;
    }

    @Override
    public boolean apply(Pony iplayer, Pos data) {
        class_2338 pos = data.pos();
        TreeType treeType = TreeType.at(pos, iplayer.asWorld());
        iplayer.setAnimation(PlayerPoser.Animation.KICK, PlayerPoser.Animation.Recipient.ANYONE);
        iplayer.subtractEnergyCost(treeType == TreeType.NONE ? 1.0 : 3.0);
        ((class_1657)iplayer.asEntity()).method_7322(3.0f);
        return treeType.collectBlocks(iplayer.asWorld(), pos).filter(tree -> {
            ParticleUtils.spawnParticle(iplayer.asWorld(), (class_2394)UParticles.GROUND_POUND, data.vec(), class_243.field_1353);
            class_1657 player = (class_1657)iplayer.asEntity();
            if (BlockDestructionManager.of(player.method_37908()).getBlockDestruction(pos) + 4.0f >= 10.0f) {
                if (player.method_37908().field_9229.method_43048(30) == 0) {
                    tree.logs().forEach(player.method_37908(), (w, state, p) -> {
                        if (iplayer.canModifyAt(p, ModificationType.PHYSICAL)) {
                            w.method_22352(p, true);
                        }
                    });
                    tree.leaves().forEach(player.method_37908(), (w, state, p) -> {
                        if (iplayer.canModifyAt(p, ModificationType.PHYSICAL)) {
                            class_2248.method_9497((class_2680)w.method_8320(p), (class_1937)w, (class_2338)p);
                            w.method_8652(p, class_2246.field_10124.method_9564(), 3);
                        }
                    });
                }
                iplayer.subtractEnergyCost(3.0);
            } else {
                tree.leaves().forEach(player.method_37908(), (w, state, p) -> {
                    if (w.field_9229.method_43048(30) == 0) {
                        w.method_20290(2001, p, class_2248.method_9507((class_2680)state));
                    }
                });
                int cost = this.dropApples(player, pos);
                if (cost > 0) {
                    iplayer.subtractEnergyCost((float)cost / 7.0f);
                }
            }
            return true;
        }).isPresent();
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
        player.getMagicalReserves().getExertion().addPercent(40.0f);
    }

    @Override
    public void coolDown(Pony player, AbilitySlot slot) {
        ((class_1657)player.asEntity()).method_7344().method_7583(0.1f);
    }

    private int dropApples(class_1657 player, class_2338 pos) {
        TreeType treeType = TreeType.at(pos, player.method_37908());
        return treeType.collectBlocks(player.method_37908(), pos).map(tree -> {
            tree.logs().forEach(player.method_37908(), (world, state, position) -> this.affectBlockChange(player, position));
            int[] dropCount = new int[]{0};
            tree.leaves().forEach(player.method_37908(), (world, state, position) -> {
                this.affectBlockChange(player, position);
                if (!this.buckBlock(treeType, state, world, position).filter(i -> !i.method_7960()).map(stack -> this.createDrop((class_1799)stack, position, world, dropCount)).toList().isEmpty()) {
                    world.method_20290(2001, position, class_2248.method_9507((class_2680)state));
                }
            });
            return dropCount[0] / 3;
        }).orElse(0);
    }

    private class_1542 createDrop(class_1799 stack, class_2338 pos, class_1937 world, int[] dropCount) {
        class_1542 entity = new class_1542(world, (double)((float)pos.method_10263() + world.field_9229.method_43057()), (double)pos.method_10264() - 0.5, (double)((float)pos.method_10260() + world.field_9229.method_43057()), stack);
        entity.method_6988();
        world.method_8649((class_1297)entity);
        dropCount[0] = dropCount[0] + 1;
        return entity;
    }

    private Stream<class_1799> buckBlock(TreeType treeType, class_2680 treeState, class_1937 world, class_2338 position) {
        class_2248 class_22482 = treeState.method_26204();
        if (class_22482 instanceof Buckable) {
            Buckable buckable = (Buckable)class_22482;
            return buckable.onBucked((class_3218)world, treeState, position).stream();
        }
        class_2338 down = position.method_10074();
        class_2680 below = world.method_8320(down);
        if (below.method_26215()) {
            return Stream.of(treeType.pickRandomStack(world.field_9229, treeState));
        }
        class_2248 class_22483 = below.method_26204();
        if (class_22483 instanceof Buckable) {
            Buckable buckable = (Buckable)class_22483;
            return buckable.onBucked((class_3218)world, below, down).stream();
        }
        return Stream.empty();
    }

    private void affectBlockChange(class_1657 player, class_2338 position) {
        BlockDestructionManager.of(player.method_37908()).damageBlock(position, 4.0f);
        PosHelper.fastAll(position, p -> {
            class_2680 s = player.method_37908().method_8320((class_2338)p);
            if (s.method_26204() instanceof class_4481) {
                class_2586 patt0$temp = player.method_37908().method_8321((class_2338)p);
                if (patt0$temp instanceof class_4482) {
                    class_4482 hive = (class_4482)patt0$temp;
                    hive.method_21850(player, s, class_4482.class_4484.field_21052);
                }
                player.method_37908().method_8455(position, s.method_26204());
                class_238 area = new class_238(position).method_1009(8.0, 6.0, 8.0);
                List nearbyBees = player.method_37908().method_18467(class_4466.class, area);
                if (!nearbyBees.isEmpty()) {
                    List nearbyPlayers = player.method_37908().method_18467(class_1657.class, area);
                    int i = nearbyPlayers.size();
                    for (class_4466 bee : nearbyBees) {
                        if (bee.method_5968() != null) continue;
                        bee.method_5980((class_1309)nearbyPlayers.get(player.method_37908().field_9229.method_43048(i)));
                    }
                }
            }
        }, PosHelper.HORIZONTAL);
    }

    public static interface Buckable {
        public List<class_1799> onBucked(class_3218 var1, class_2680 var2, class_2338 var3);
    }
}

