/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.data.Numeric;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.advancement.UCriteria;
import com.minelittlepony.unicopia.client.minelittlepony.MineLPDelegate;
import com.minelittlepony.unicopia.client.render.PlayerPoser;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.util.RegistryUtils;
import com.minelittlepony.unicopia.util.VecHelper;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ScreechAbility
implements Ability<Numeric> {
    public static final int MOB_SPOOK_PROBABILITY = 1000;

    @Override
    public int getWarmupTime(Pony player) {
        return 30;
    }

    @Override
    public int getCooldownTime(Pony player) {
        return 5;
    }

    @Override
    public double getCostEstimate(Pony player) {
        return 0.0;
    }

    @Override
    public boolean activateOnEarlyRelease() {
        return true;
    }

    @Override
    public Optional<Numeric> prepare(Pony player) {
        return player.getAbilities().getActiveStat().map(stat -> (int)(stat.getWarmup() * (float)this.getWarmupTime(player))).filter(i -> i >= 0).map(Numeric::new);
    }

    @Override
    public class_9139<? super class_9129, Numeric> getSerializer() {
        return Numeric.CODEC;
    }

    @Override
    public boolean apply(Pony player, Numeric data) {
        int total;
        float strength = 1.0f - class_3532.method_15363((float)((float)data.type() / (float)this.getWarmupTime(player)), (float)0.0f, (float)1.0f);
        class_5819 rng = player.asWorld().field_9229;
        this.playSounds(player, rng, strength);
        if (!player.getPhysics().isFlying()) {
            player.setAnimation(PlayerPoser.Animation.SPREAD_WINGS, PlayerPoser.Animation.Recipient.ANYONE);
        }
        if ((total = player.findAllEntitiesInRange((int)Math.max(1.0f, 8.0f * strength)).mapToInt(e -> {
            if (e instanceof class_1309) {
                class_1309 living = (class_1309)e;
                if (!SpellType.SHIELD.isOn((class_1297)e)) {
                    this.spookMob(player, living, strength);
                    return 1;
                }
            }
            return 0;
        }).sum()) >= 20) {
            UCriteria.SCREECH_TWENTY_MOBS.trigger((class_1297)player.asEntity());
        }
        return true;
    }

    protected void playSounds(Pony player, class_5819 rng, float strength) {
        player.playSound(USounds.ENTITY_PLAYER_HIPPOGRIFF_SCREECH, (1.2f + (rng.method_43057() - 0.5f) / 2.0f) * strength, 1.1f + (rng.method_43057() - 0.5f));
        player.asWorld().method_43275(player.asEntity(), (class_6880)class_5712.field_45148, ((class_1657)player.asEntity()).method_33571());
    }

    protected void spookMob(Pony player, class_1309 living, float strength) {
        boolean isBracing;
        boolean isEarthPony = EquinePredicates.PLAYER_EARTH.test((class_1297)living);
        boolean bl = isBracing = isEarthPony && ((class_1657)player.asEntity()).method_5715();
        if (!isBracing) {
            living.method_5643((class_1282)player.damageOf(UDamageTypes.BAT_SCREECH, player), isEarthPony ? 0.1f : 0.3f);
            if (living.method_37908().field_9229.method_43048(1000) == 0) {
                RegistryUtils.pickRandom(living.method_37908(), UTags.Items.SPOOKED_MOB_DROPS).ifPresent(drop -> {
                    living.method_5775(drop.method_7854());
                    living.method_5783(USounds.Vanilla.field_15197, 1.0f, 0.1f);
                    UCriteria.SPOOK_MOB.trigger((class_1297)player.asEntity());
                });
            }
        }
        class_243 knockVec = player.getOriginVector().method_1020(living.method_19538()).method_1021((double)strength);
        living.method_6005((double)((isBracing ? 0.2f : (isEarthPony ? 0.3f : 0.5f)) * strength), knockVec.method_10216(), knockVec.method_10215());
        if (!isEarthPony) {
            living.method_5762(0.0, 0.1 * (double)strength, 0.0);
        }
        Living.updateVelocity((class_1297)living);
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
    }

    @Override
    public void coolDown(Pony player, AbilitySlot slot) {
        class_243 eyePos = ((class_1657)player.asEntity()).method_19538().method_1031(0.0, (double)MineLPDelegate.getInstance().getPonyHeight((class_1297)player.asEntity()) * 0.8, 0.0);
        for (int i = 0; i < 20; ++i) {
            player.addParticle((class_2394)class_2398.field_11241, eyePos, VecHelper.supply(() -> (player.asWorld().method_8409().method_43059() - 0.5) * 0.3));
        }
    }
}

