/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.AbstractSpellCastingAbility;
import com.minelittlepony.unicopia.ability.data.Hit;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.HomingSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.client.render.PlayerPoser;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.AmuletItem;
import com.minelittlepony.unicopia.item.component.Charges;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.util.TraceHelper;
import com.minelittlepony.unicopia.util.VecHelper;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public class UnicornCastingAbility
extends AbstractSpellCastingAbility {
    @Override
    public int getWarmupTime(Pony player) {
        return (int)(20.0f - Math.min(17.0f, (float)player.getLevel().get() * 0.75f));
    }

    @Override
    public Optional<Hit> prepare(Pony player) {
        class_1271<CustomisedSpellType<?>> spell = player.getCharms().getSpellInHand(false);
        return Hit.of(player.canCast() && (double)player.getMagicalReserves().getMana().get() >= this.getCostEstimate(player) && (!spell.method_5467().method_23665() || this.canCast(((CustomisedSpellType)spell.method_5466()).type())));
    }

    @Override
    public double getCostEstimate(Pony player) {
        class_1271<class_1799> amulet = this.getAmulet(player);
        if (amulet.method_5467().method_23665()) {
            float manaLevel = player.getMagicalReserves().getMana().get();
            return Math.min(manaLevel, (float)Charges.of((class_1799)amulet.method_5466()).energy());
        }
        class_1271<CustomisedSpellType<?>> spell = player.getCharms().getSpellInHand(false);
        return !spell.method_5467().method_23665() || ((CustomisedSpellType)spell.method_5466()).isOn(player) ? 2.0 : 4.0;
    }

    @Override
    public int getColor(Pony player) {
        class_1271<class_1799> amulet = this.getAmulet(player);
        if (amulet.method_5467().method_23665()) {
            return 0;
        }
        return super.getColor(player);
    }

    @Override
    public boolean apply(Pony player, Hit data) {
        if (!player.canCast()) {
            return false;
        }
        class_1271<class_1799> amulet = this.getAmulet(player);
        if (amulet.method_5467().method_23665()) {
            int amount;
            class_1799 stack = (class_1799)amulet.method_5466();
            if (Charges.of(stack).canHoldCharge() && (amount = -((int)Math.min(player.getMagicalReserves().getMana().get(), (float)Charges.of(stack).energy()))) < 0) {
                Charges.discharge(stack, amount);
                player.getMagicalReserves().getMana().add(amount);
                player.asWorld().method_43129(null, player.asEntity(), USounds.ITEM_AMULET_RECHARGE, class_3419.field_15248, 1.0f, 1.0f);
            }
        } else {
            class_1271<CustomisedSpellType<?>> newSpell = player.getCharms().getSpellInHand(true);
            if (newSpell.method_5467() != class_1269.field_5814 && this.canCast(((CustomisedSpellType)newSpell.method_5466()).type())) {
                CustomisedSpellType<?> equippedType;
                CustomisedSpellType spell = (CustomisedSpellType)newSpell.method_5466();
                if (newSpell.method_5467() == class_1269.field_21466 && (equippedType = player.getCharms().getEquippedSpell(player.getCharms().getHand())).type() == spell.type()) {
                    player.getCharms().equipSpell(player.getCharms().getHand(), spell);
                }
                if (spell.isEmpty()) {
                    return false;
                }
                boolean has = !spell.isStackable() && player.getSpellSlot().contains(spell);
                boolean removed = !spell.isStackable() && player.getSpellSlot().removeWhere(spell.type());
                player.subtractEnergyCost(removed ? 2.0 : 4.0);
                if (!has) {
                    Object s = spell.apply(player, CastingMethod.DIRECT);
                    if (s == null) {
                        player.spawnParticles((class_2394)class_2398.field_11237, 6);
                        player.playSound(USounds.SPELL_CAST_FAIL, 1.0f, 0.5f);
                    } else {
                        player.setAnimation(PlayerPoser.Animation.ARMS_UP, PlayerPoser.Animation.Recipient.HUMAN);
                        if (s instanceof HomingSpell) {
                            HomingSpell homer = (HomingSpell)s;
                            TraceHelper.findEntity(player.asEntity(), homer.getRange(player), 1.0f, EquinePredicates.EXCEPT_MAGIC_IMMUNE).ifPresent(homer::setTarget);
                        }
                        player.playSound(USounds.SPELL_CAST_SUCCESS, 0.05f, 2.2f);
                    }
                } else {
                    player.setAnimation(PlayerPoser.Animation.WOLOLO, PlayerPoser.Animation.Recipient.ANYONE);
                }
            }
        }
        return true;
    }

    protected boolean canCast(SpellType<?> type) {
        return true;
    }

    private class_1271<class_1799> getAmulet(Pony player) {
        class_1799 stack = ((class_1657)player.asEntity()).method_5998(class_1268.field_5808);
        if (stack.method_7909() instanceof AmuletItem) {
            if (Charges.of(stack).canHoldCharge()) {
                return class_1271.method_22428((Object)stack);
            }
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
        player.getMagicalReserves().getExhaustion().multiply(3.3f);
        if (this.getAmulet(player).method_5467() == class_1269.field_21466) {
            class_243 eyes = ((class_1657)player.asEntity()).method_5836(1.0f);
            float i = player.getAbilities().getStat(slot).getFillProgress();
            class_5819 rng = player.asWorld().field_9229;
            player.addParticle((class_2394)(i > 0.5f ? class_2398.field_11237 : class_2398.field_11204), eyes, VecHelper.supply(() -> (rng.method_43059() - 0.5) * 0.1));
            player.playSound(USounds.ITEM_AMULET_CHARGING, 1.0f, i / 20.0f);
        } else {
            player.spawnParticles(MagicParticleEffect.UNICORN, 5);
        }
    }
}

