/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.ability.UnicornTeleportAbility;
import com.minelittlepony.unicopia.ability.data.Pos;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.FriendshipBraceletItem;
import java.util.stream.Stream;

public class UnicornGroupTeleportAbility
extends UnicornTeleportAbility {
    @Override
    public double getCostEstimate(Pony player) {
        double cost = super.getCostEstimate(player);
        if (cost == 0.0) {
            return 0.0;
        }
        return cost * (double)(1L + this.getComrades(player).count());
    }

    @Override
    public boolean apply(Pony player, Pos data) {
        this.getComrades(player).forEach(teleportee -> this.teleport(player, (Caster<?>)teleportee, data));
        return super.apply(player, data);
    }

    private Stream<Caster<?>> getComrades(Pony player) {
        return Caster.stream(player.findAllEntitiesInRange(3.0, e -> FriendshipBraceletItem.isComrade(player, e)));
    }
}

