/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.data.Pos;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.advancement.UCriteria;
import com.minelittlepony.unicopia.block.state.StatePredicate;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.util.Trace;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_5635;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class UnicornTeleportAbility
implements Ability<Pos> {
    @Override
    public class_2960 getIcon(Pony player) {
        return this.getId().method_45134(p -> "textures/gui/ability/" + p + (((class_1657)player.asEntity()).method_5715() ? "_far" : "_near") + ".png");
    }

    @Override
    public class_2561 getName(Pony player) {
        if (((class_1657)player.asEntity()).method_5715()) {
            return class_2561.method_43471((String)(this.getTranslationKey() + ".far"));
        }
        return Ability.super.getName(player);
    }

    @Override
    public int getWarmupTime(Pony player) {
        return (int)(20.0f - Math.min(17.0f, (float)player.getLevel().get() * 0.75f));
    }

    @Override
    public int getCooldownTime(Pony player) {
        return (int)(50.0f - Math.min(45.0f, (float)player.getLevel().get() * 0.75f));
    }

    @Override
    public double getCostEstimate(Pony player) {
        return this.prepare(player).map(pos -> pos.distanceTo(player) / 10.0).orElse(0.0);
    }

    @Override
    public int getColor(Pony player) {
        return SpellType.PORTAL.getColor();
    }

    @Override
    public Optional<Pos> prepare(Pony player) {
        if (!player.canCast()) {
            return Optional.empty();
        }
        int maxDistance = (int)((float)(((class_1657)player.asEntity()).method_7337() ? 1000 : 100) + (float)player.getLevel().get() * 0.25f);
        class_1937 w = player.asWorld();
        Trace trace = Trace.create(player.asEntity(), maxDistance, 1.0f, class_1301.field_6155);
        return trace.getBlockOrEntityPos().map(pos -> {
            boolean originalPosValid;
            class_2338 originalPos = pos;
            class_2350 globalUp = player.getPhysics().isGravityNegative() ? class_2350.field_11033 : class_2350.field_11036;
            boolean originalPosHasSupport = this.exception(w, (class_2338)pos, (class_1657)player.asEntity());
            boolean bl = originalPosValid = this.enterable(w, pos.method_10093(globalUp)) && this.enterable(w, pos.method_10079(globalUp, 2));
            if (w.method_8320(pos).method_27852(class_2246.field_27879) && !class_5635.method_32355(player.asEntity())) {
                return null;
            }
            if (originalPosHasSupport) {
                class_2338 p = pos;
                pos = trace.getSide().map(sideHit -> {
                    if (((class_1657)player.asEntity()).method_5715()) {
                        sideHit = sideHit.method_10153();
                    }
                    return p.method_10093(sideHit);
                }).orElse((class_2338)pos);
            }
            if (pos.method_10263() != originalPos.method_10263() || pos.method_10260() != originalPos.method_10260()) {
                int steps = 0;
                while (this.enterable(w, pos.method_10093(globalUp.method_10153()))) {
                    pos = pos.method_10093(globalUp.method_10153());
                    if (++steps <= 2) continue;
                    if (originalPosValid) {
                        pos = originalPos.method_10093(globalUp);
                        break;
                    }
                    return null;
                }
            }
            if (!this.enterable(w, (class_2338)pos) && this.exception(w, (class_2338)pos, (class_1657)player.asEntity()) || !this.enterable(w, pos.method_10093(globalUp)) && this.exception(w, pos.method_10093(globalUp), (class_1657)player.asEntity())) {
                return null;
            }
            return new Pos((class_2382)pos);
        });
    }

    @Override
    public class_9139<? super class_9129, Pos> getSerializer() {
        return Pos.CODEC;
    }

    @Override
    public boolean apply(Pony iplayer, Pos data) {
        return this.teleport(iplayer, iplayer, data);
    }

    protected boolean teleport(Pony teleporter, Caster<?> teleportee, Pos destination) {
        if (!teleporter.canCast()) {
            return false;
        }
        Object participant = teleportee.asEntity();
        if (participant == null) {
            return false;
        }
        teleportee.asWorld().method_8396(null, teleportee.getOrigin(), USounds.ENTITY_PLAYER_UNICORN_TELEPORT, class_3419.field_15248, 1.0f, 1.0f);
        double distance = destination.distanceTo(teleportee) / 10.0;
        if (participant.method_5765()) {
            class_1297 mount = participant.method_5854();
            participant.method_5848();
            Living.transmitPassengers(mount);
        }
        class_243 offset = teleportee.getOriginVector().method_1020(teleporter.getOriginVector()).method_1031(participant.method_23317() - Math.floor(participant.method_23317()), 0.0, participant.method_23321() - Math.floor(participant.method_23321()));
        double yPos = this.getTargetYPosition(participant.method_5770(), destination.pos(), class_3726.method_16195(participant));
        class_243 dest = new class_243((double)destination.x() + offset.method_10216(), yPos, (double)destination.z() + offset.method_10215());
        participant.method_5859(dest.field_1352, dest.field_1351, dest.field_1350);
        if (participant.method_37908().method_20812(participant, participant.method_5829()).iterator().hasNext()) {
            dest = destination.vec();
            participant.method_5859(dest.field_1352, participant.method_23318(), dest.field_1350);
        }
        teleporter.subtractEnergyCost(distance);
        ((class_1297)participant).field_6017 = (float)((double)((class_1297)participant).field_6017 / Math.min(distance, 1.0));
        class_2338 blockPos = class_2338.method_49638((class_2374)dest);
        participant.method_37908().method_8396(null, blockPos, USounds.ENTITY_PLAYER_UNICORN_TELEPORT, class_3419.field_15248, 1.0f, 1.0f);
        if (!participant.method_5770().method_24794(blockPos)) {
            UCriteria.TELEPORT_ABOVE_WORLD.trigger((class_1297)teleporter.asEntity());
        }
        return true;
    }

    private boolean enterable(class_1937 w, class_2338 pos) {
        class_2680 state = w.method_8320(pos);
        if (StatePredicate.isFluid(state) || state.method_26204() instanceof class_2397) {
            return false;
        }
        return w.method_22347(pos) || !state.method_26225() || !state.method_26228((class_1922)w, pos);
    }

    private boolean exception(class_1937 w, class_2338 pos, class_1657 player) {
        class_265 shape;
        class_2680 state = w.method_8320(pos);
        return state.method_26168((class_1922)w, pos, (class_1297)player) || StatePredicate.isFluid(state) || (shape = state.method_26194((class_1922)w, pos, class_3726.method_16195((class_1297)player))).method_1110() || shape.method_1107().method_17940() > 1.0;
    }

    private double getTargetYPosition(class_1937 world, class_2338 pos, class_3726 context) {
        class_265 shape = world.method_8320(pos).method_26194((class_1922)world, pos, context);
        return (double)pos.method_10264() + (shape.method_1110() ? 0.0 : shape.method_1107().method_17940());
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
        player.getMagicalReserves().getExertion().addPercent(30.0f);
        player.spawnParticles(MagicParticleEffect.UNICORN, 5);
    }

    @Override
    public void coolDown(Pony player, AbilitySlot slot) {
        player.spawnParticles(MagicParticleEffect.UNICORN, 5);
    }
}

